/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBox;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material3D;
import com.supermap.data.Matrix;
import com.supermap.data.ModelEntityManager;
import com.supermap.data.ModelNative;
import com.supermap.data.Point3D;
import com.supermap.data.Skeleton;
import com.supermap.data.SkeletonID;
import com.supermap.data.TextureData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class Model
extends InternalHandleDisposable {
    public Model() {
        long l = ModelNative.jni_New();
        this.setHandle(l, true);
    }

    public Model(Model model) {
        this(model, true);
    }

    protected Model(Model model, boolean dispose) {
        if (model == null) {
            String string = InternalResource.loadString("Model", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (model.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ModelNative.jni_Clone(model.getHandle());
        this.setHandle(l, dispose);
        InternalHandleDisposable.makeSureNativeObjectLive(model);
    }

    protected Model(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, true);
    }

    protected static final Model internalCreateInstance(long handle) {
        return new Model(handle);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ModelNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public int getLODCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLODCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_GetLodCount(this.getHandle());
    }

    public boolean isClosed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isClosed", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_IsClosed(this.getHandle());
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isClosed", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_IsEmpty(this.getHandle());
    }

    public boolean isHasLOD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isHasLOD", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_IsClosed(this.getHandle());
    }

    public int getSkeletonCount(int nLodIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSkeletonCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_GetSkeletonCount(this.getHandle(), nLodIndex);
    }

    public int getVertexCount(SkeletonID skeletonId) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVertexCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_GetSkeletonVertex(this.getHandle(), skeletonId.getLODIndex(), skeletonId.getSkeletonIndex());
    }

    public int getTriangleCount(SkeletonID skeletonId) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTriangleCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_GetSkeletonTriangle(this.getHandle(), skeletonId.getLODIndex(), skeletonId.getSkeletonIndex());
    }

    public boolean fromFile(String filePath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (filePath == null) {
            String string = InternalResource.loadString("filePath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(filePath);
        if (!file.exists()) {
            String string = InternalResource.loadString("file", "GeoModel_TheFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        bl = filePath.toLowerCase().endsWith(".terrainz") || filePath.toLowerCase().endsWith(".tinz") ? ModelNative.jni_FromTINFile(this.getHandle(), filePath) : ModelNative.jni_FromOSGB(this.getHandle(), filePath, bl2);
        return bl;
    }

    public boolean toFile(String filePath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFile", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (filePath == null) {
            String string = InternalResource.loadString("filePath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (filePath.toLowerCase().endsWith(".osgb") || filePath.toLowerCase().endsWith(".osg")) {
            bl = ModelNative.jni_ToOSGB(this.getHandle(), filePath, bl2);
        } else if (filePath.toLowerCase().endsWith(".s3m")) {
            bl = ModelNative.jni_ToS3M(this.getHandle(), filePath);
        } else if (filePath.toLowerCase().endsWith(".off")) {
            bl = ModelNative.jni_ToOFF(this.getHandle(), filePath);
        }
        return bl;
    }

    public BoundingBox getBoundingBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundingBox", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        ModelNative.jni_GetBoundingBox(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        Point3D point3D2 = new Point3D(dArray[3], dArray[4], dArray[5]);
        BoundingBox boundingBox = new BoundingBox(point3D, point3D2);
        return boundingBox;
    }

    public boolean fromStreamFile(byte[] byteFile) {
        boolean bl = false;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[byteFile.length - 4];
        System.arraycopy(byteFile, 0, byArray, 0, byArray.length);
        System.arraycopy(byteFile, byArray.length, byArray2, 0, byArray2.length);
        int n = Model.byte4ToInt(byArray);
        String string = Model.numberToSuffix(n);
        String string2 = System.getProperty("java.io.tmpdir");
        String string3 = string2 + "/model" + string;
        Model.byteToFile(string3, byArray2);
        bl = this.fromFile(string3);
        if (bl) {
            File file = new File(string3);
            file.deleteOnExit();
        }
        return bl;
    }

    public byte[] toStreamFile() {
        String string = System.getProperty("java.io.tmpdir");
        String string2 = String.valueOf(new Random().nextInt());
        String string3 = string + "/" + string2 + ".s3m";
        boolean bl = this.toFile(string3);
        if (this.getLODCount() > 0) {
            string3 = string + "/" + string2 + "_Lod" + this.getLODCount() + ".s3m";
        }
        byte[] byArray = Model.intToByte4(4);
        File file = new File(string3);
        byte[] byArray2 = Model.fileToByteArray(file);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        if (bl) {
            file.delete();
        }
        return byArray3;
    }

    public static byte[] intToByte4(int i) {
        byte[] byArray = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return byArray;
    }

    public static int byte4ToInt(byte[] bytes) {
        int n = bytes[0] & 0xFF;
        int n2 = bytes[1] & 0xFF;
        int n3 = bytes[2] & 0xFF;
        int n4 = bytes[3] & 0xFF;
        return n | n2 << 8 | n3 << 16 | n4 << 24;
    }

    public static String numberToSuffix(int number) {
        String string = ".osgb";
        switch (number) {
            case 1: {
                string = ".osgb";
                break;
            }
            case 2: {
                string = ".3ds";
                break;
            }
            case 3: {
                string = ".dae";
                break;
            }
            case 4: {
                string = ".s3m";
                break;
            }
            case 5: {
                string = ".obj";
                break;
            }
            case 6: {
                string = ".off";
                break;
            }
            case 7: {
                string = ".terrainz";
                break;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByteArray(File file) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            byArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                byArray.clone();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byteToFile(String filePath, byte[] data) {
        File file = new File(filePath);
        FilterOutputStream filterOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            filterOutputStream.write(data);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Skeleton getSkeleton(SkeletonID id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = ModelNative.jni_GetSkeleton(this.getHandle(), id.getLODIndex(), id.getSkeletonIndex());
        Skeleton skeleton = null;
        if (l != 0L) {
            skeleton = new Skeleton(l, this);
        }
        return skeleton;
    }

    public Skeleton getSkeleton(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = ModelNative.jni_GetSkeleton(this.getHandle(), name);
        Skeleton skeleton = null;
        if (l != 0L) {
            skeleton = new Skeleton(l, this);
        }
        return skeleton;
    }

    public Skeleton getSkeleton(SkeletonID id, double[] matrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix == null || matrix.length != 16) {
            String string = InternalResource.loadString("matrix", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = ModelNative.jni_GetSkeleton(this.getHandle(), id.getLODIndex(), id.getSkeletonIndex(), matrix);
        Skeleton skeleton = null;
        if (l != 0L) {
            skeleton = new Skeleton(l, this);
        } else {
            matrix = null;
        }
        return skeleton;
    }

    public Material3D getMaterial(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = ModelNative.jni_GetMaterial(this.getHandle(), name);
        Material3D material3D = null;
        if (l != 0L) {
            material3D = new Material3D(l, this.getHandle());
        }
        return material3D;
    }

    public TextureData getTexture(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = ModelNative.jni_GetTexture(this.getHandle(), name);
        TextureData textureData = null;
        if (l != 0L) {
            textureData = new TextureData(l);
        }
        return textureData;
    }

    public int[] getSkeletonInfo(SkeletonID id) {
        int[] nArray = null;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        nArray = new int[2];
        long l = ModelNative.jni_GetSkeleton(this.getHandle(), id.getLODIndex(), id.getSkeletonIndex());
        if (l == 0L) {
            String string = InternalResource.loadString("id", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        ModelNative.jni_GetSkeletonInfo(l, id.getLODIndex(), id.getSkeletonIndex(), nArray);
        return nArray;
    }

    public int[] getInfo(int lod) {
        int[] nArray = null;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = ModelNative.jni_GetLodCount(this.getHandle());
        if (lod < -1 || lod >= 0 && lod >= n) {
            String string = InternalResource.loadString("lod", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        nArray = new int[2];
        ModelNative.jni_GetInfo(this.getHandle(), lod, nArray);
        return nArray;
    }

    public void add(Skeleton skeleton) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (skeleton == null || skeleton.getHandle() == 0L) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3D material3D = skeleton.getMaterial();
        ArrayList<TextureData> arrayList = material3D.getTextures();
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray[i] = arrayList.get(i).getHandle();
        }
        arrayList.clear();
        arrayList = null;
        ModelNative.jni_Add(this.getHandle(), skeleton.getHandle(), material3D.getHandle(), lArray);
    }

    public void add(Skeleton skeleton, double[] matrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (skeleton == null || skeleton.getHandle() == 0L) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix == null) {
            String string = InternalResource.loadString("matrix", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix.length != 16) {
            String string = InternalResource.loadString("matrix", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3D material3D = skeleton.getMaterial();
        ArrayList<TextureData> arrayList = material3D.getTextures();
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray[i] = arrayList.get(i).getHandle();
        }
        arrayList.clear();
        arrayList = null;
        ModelNative.jni_Add(this.getHandle(), matrix, skeleton.getHandle(), material3D.getHandle(), lArray);
    }

    public boolean buildLOD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_BuildLOD(this.getHandle());
    }

    public ArrayList<Model> decompose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<Model> arrayList = null;
        long[] lArray = ModelNative.jni_Decompose(this.getHandle());
        if (lArray != null) {
            arrayList = new ArrayList<Model>();
            for (int i = 0; i < lArray.length; ++i) {
                arrayList.add(Model.internalCreateInstance(lArray[i]));
            }
        }
        return arrayList;
    }

    public String getAvailableName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_GetAvailableName(this.getHandle(), name);
    }

    public BoundingBox getBoundingBox(SkeletonID id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (id == null) {
            String string = InternalResource.loadString("id", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        ModelNative.jni_GetBoundingBox(this.getHandle(), id.getLODIndex(), id.getSkeletonIndex(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        Point3D point3D2 = new Point3D(dArray[3], dArray[4], dArray[5]);
        BoundingBox boundingBox = new BoundingBox(point3D, point3D2);
        return boundingBox;
    }

    public double getBoundingSphere(SkeletonID id, Point3D centerPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (centerPoint == null) {
            String string = InternalResource.loadString("centerPoint", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        double d = ModelNative.jni_GetBoundingSphere(this.getHandle(), id.getLODIndex(), id.getSkeletonIndex(), dArray);
        centerPoint.setX(dArray[0]);
        centerPoint.setY(dArray[1]);
        centerPoint.setZ(dArray[2]);
        return d;
    }

    public boolean removeLOD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_RemoveLOD(this.getHandle());
    }

    public boolean removeSkeleton(SkeletonID id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (id == null) {
            String string = InternalResource.loadString("id", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_RemoveSkeleton(this.getHandle(), id.getLODIndex(), id.getSkeletonIndex());
    }

    public boolean removeSkeleton(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_RemoveSkeleton(this.getHandle(), name);
    }

    public boolean setLODs(ArrayList<Model> listModel) {
        if (listModel == null) {
            String string = InternalResource.loadString("listModel", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[listModel.size()];
        for (int i = 0; i < listModel.size(); ++i) {
            lArray[i] = listModel.get(i).getHandle();
        }
        return ModelNative.jni_SetLODs(this.getHandle(), lArray);
    }

    public void setMatrix(double[] matrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix == null) {
            String string = InternalResource.loadString("matrix", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix.length != 16) {
            String string = InternalResource.loadString("matrix", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        ModelNative.jni_SetMatrix(this.getHandle(), matrix);
    }

    public void update(Skeleton skeleton) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (skeleton == null) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3D material3D = skeleton.getMaterial();
        ArrayList<TextureData> arrayList = material3D.getTextures();
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray[i] = arrayList.get(i).getHandle();
        }
        ModelNative.jni_Update(this.getHandle(), skeleton.getHandle(), material3D.getHandle(), lArray);
        for (TextureData textureData : arrayList) {
            textureData.dispose();
        }
        material3D.dispose();
        arrayList.clear();
        arrayList = null;
    }

    public boolean addSkeleton(ModelEntityManager em, String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (em == null) {
            String string = InternalResource.loadString("em", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_AddSkeleton(this.getHandle(), em.getHandle(), name);
    }

    public boolean addSkeleton(ModelEntityManager em, String name, double[] matrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (em == null) {
            String string = InternalResource.loadString("em", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return ModelNative.jni_AddSkeleton(this.getHandle(), em.getHandle(), name, matrix);
    }

    public boolean setLODs(ArrayList<Model> listModel, ArrayList<Double> listLodScales) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (listModel == null) {
            String string = InternalResource.loadString("listModel", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (listLodScales == null) {
            String string = InternalResource.loadString("listLodScales", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[listModel.size()];
        for (int i = 0; i < listModel.size(); ++i) {
            lArray[i] = listModel.get(i).getHandle();
        }
        double[] dArray = new double[listLodScales.size()];
        for (int i = 0; i < listLodScales.size(); ++i) {
            dArray[i] = listLodScales.get(i);
        }
        return ModelNative.jni_SetLODs2(this.getHandle(), lArray, dArray);
    }

    public void setMatrix(Matrix matrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix == null) {
            String string = InternalResource.loadString("matrix", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        ModelNative.jni_SetMatrix2(this.getHandle(), matrix.getHandle());
    }
}

