/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CustomGeometryCreatedEvent;
import com.supermap.data.CustomGeometryCreatedListener;
import com.supermap.data.Enum;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoBSpline;
import com.supermap.data.GeoBillboard;
import com.supermap.data.GeoBox;
import com.supermap.data.GeoCardinal;
import com.supermap.data.GeoChord;
import com.supermap.data.GeoCircle;
import com.supermap.data.GeoCircle3D;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoCone;
import com.supermap.data.GeoCurve;
import com.supermap.data.GeoCylinder;
import com.supermap.data.GeoEllipse;
import com.supermap.data.GeoEllipsoid;
import com.supermap.data.GeoEllipticArc;
import com.supermap.data.GeoGraphicObject;
import com.supermap.data.GeoHemiSphere;
import com.supermap.data.GeoLegend;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoLineEPS;
import com.supermap.data.GeoLineM;
import com.supermap.data.GeoMap;
import com.supermap.data.GeoMapBorder;
import com.supermap.data.GeoMapScale;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoNorthArrow;
import com.supermap.data.GeoParametricLine;
import com.supermap.data.GeoParametricLineCompound;
import com.supermap.data.GeoParametricRegion;
import com.supermap.data.GeoParametricRegionCompound;
import com.supermap.data.GeoParticle;
import com.supermap.data.GeoPicture;
import com.supermap.data.GeoPicture3D;
import com.supermap.data.GeoPie;
import com.supermap.data.GeoPie3D;
import com.supermap.data.GeoPieCylinder;
import com.supermap.data.GeoPlacemark;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoPointEPS;
import com.supermap.data.GeoPyramid;
import com.supermap.data.GeoRectangle;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoRegionEPS;
import com.supermap.data.GeoRoundRectangle;
import com.supermap.data.GeoSphere;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoTIM;
import com.supermap.data.GeoText;
import com.supermap.data.GeoText3D;
import com.supermap.data.GeoTextEPS;
import com.supermap.data.GeoUserDefined;
import com.supermap.data.GeometryNative;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import java.util.Vector;

public abstract class Geometry
extends InternalHandleDisposable {
    private GeoStyle m_style = null;
    private boolean m_setStyle = false;
    protected GeometryType m_geoType;
    private static final int[] g_GeometryTypeValues = Enum.getPredefineValues(GeometryType.class);
    static transient Vector m_customGeometryCreateListeners;

    protected Geometry() {
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        if (this.getType().equals(GeometryType.GEOCOMPOUND)) {
            GeometryNative.jni_SetBoundsDirty(this.getHandle(), true);
        }
        GeometryNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() == GeometryType.GEOREGION) {
            if (bounds.getWidth() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsWidthIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (bounds.getHeight() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsHeightIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
        }
        GeometryNative.jni_SetBounds(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom());
        if (this.getType() == GeometryType.GEOTEXT) {
            GeoText geoText = (GeoText)this;
            double d = geoText.getTextStyle().getFontWidth();
            double d2 = geoText.getTextStyle().getFontHeight();
            if (d < 0.0) {
                geoText.getTextStyle().setFontWidth(Math.abs(d));
            }
            if (d2 < 0.0) {
                geoText.getTextStyle().setFontHeight(Math.abs(d2));
            }
        }
    }

    public Point2D getInnerPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeometryNative.jni_GetInnerPoint(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryNative.jni_GetID(this.getHandle());
    }

    public void setID(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_setID(this.getHandle(), value);
    }

    public boolean isEmpty() {
        return false;
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_style == null && (l = GeometryNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_style = GeoStyle.createInstance(l);
        }
        return this.m_style;
    }

    public void setStyle(GeoStyle value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryType geometryType = this.getType();
        if (geometryType == GeometryType.GEOTEXT) {
            String string = InternalResource.loadString("value", "GeoText_UnsupprotStyle", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOTEXT3D) {
            String string = InternalResource.loadString("value", "GeoText_UnsupprotStyle", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPOINT3D) {
            String string = InternalResource.loadString("value", "GeoPoint3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOLINE3D) {
            String string = InternalResource.loadString("value", "GeoLine3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOREGION3D) {
            String string = InternalResource.loadString("value", "GeoRegion3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOCIRCLE3D) {
            String string = InternalResource.loadString("value", "GeoCircle3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPIE3D) {
            String string = InternalResource.loadString("value", "GeoPie3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPIECYLINDER) {
            String string = InternalResource.loadString("value", "GeoPieCylinder_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOSPHERE) {
            String string = InternalResource.loadString("value", "GeoSphere_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOHEMISPHERE) {
            String string = InternalResource.loadString("value", "GeoHemiSphere_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("value", "GeoEllipsoid_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOCYLINDER) {
            String string = InternalResource.loadString("value", "GeoCylinder_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPYRAMID) {
            String string = InternalResource.loadString("value", "GeoPyramid_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            if (this.m_style != null) {
                this.m_style.clearHandle();
                this.m_style = null;
            }
            GeometryNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle geoStyle = value.clone();
            GeometryNative.jni_SetStyle(this.getHandle(), geoStyle.getHandle());
            geoStyle.dispose();
        }
        this.m_setStyle = true;
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public GeometryType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoType == null) {
            int n = GeometryNative.jni_GetType(this.getHandle());
            try {
                this.m_geoType = GeometryType.parseUGCValue(n);
            }
            catch (Exception exception) {
                this.m_geoType = new GeometryType(n, n);
            }
        }
        return this.m_geoType;
    }

    public abstract Geometry clone();

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = GeometryNative.jni_FromXML(this.getHandle(), xml);
        }
        return bl;
    }

    public boolean hitTest(Point2D point, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Geometry_InvalidTolerance", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometryNative.jni_HitTest(this.getHandle(), point.getX(), point.getY(), tolerance);
    }

    public Geometry mirror(Point2D startPoint, Point2D endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "Geometry_MirroStartEqualToEnd", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = this.clone();
        GeometryNative.jni_Mirror(geometry.getHandle(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
        return geometry;
    }

    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_Offset(this.getHandle(), dx, dy);
    }

    public void resize(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() == GeometryType.GEOREGION) {
            if (bounds.getWidth() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsWidthIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (bounds.getHeight() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsHeightIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
        }
        GeometryNative.jni_Resize(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom());
        if (this.getType() == GeometryType.GEOTEXT) {
            GeoText geoText = (GeoText)this;
            double d = geoText.getTextStyle().getFontWidth();
            double d2 = geoText.getTextStyle().getFontHeight();
            if (d < 0.0) {
                geoText.getTextStyle().setFontWidth(Math.abs(d));
            }
            if (d2 < 0.0) {
                geoText.getTextStyle().setFontHeight(Math.abs(d2));
            }
        }
    }

    public void rotate(Point2D basePoint, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_Rotate(this.getHandle(), basePoint.getX(), basePoint.getY(), angle);
    }

    public void setEmpty() {
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryNative.jni_ToXML(this.getHandle());
    }

    static boolean copyGeometry(Geometry geometry1, Geometry geometry2) {
        boolean bl = GeometryNative.jni_CopyGeometry(InternalHandle.getHandle(geometry1), InternalHandle.getHandle(geometry2));
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    @Override
    public abstract void dispose();

    @Override
    protected void clearHandle() {
        if (this.m_style != null) {
            this.m_style.clearHandle();
            this.m_style = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(Geometry geometry) {
        geometry.clearHandle();
    }

    static final Geometry createInstance(GeometryType geoType) {
        Geometry geometry = null;
        if (geoType.equals(GeometryType.GEOPOINT)) {
            geometry = new GeoPoint();
        } else if (geoType.equals(GeometryType.GEOLINE)) {
            geometry = new GeoLine();
        } else if (geoType.equals(GeometryType.GEOREGION)) {
            geometry = new GeoRegion();
        } else if (geoType.equals(GeometryType.GEOTEXT)) {
            geometry = new GeoText();
        } else if (geoType.equals(GeometryType.GEOLINEM)) {
            geometry = new GeoLineM();
        } else if (geoType.equals(GeometryType.GEOPOINT3D)) {
            geometry = new GeoPoint3D();
        } else if (geoType.equals(GeometryType.GEOLINE3D)) {
            geometry = new GeoLine3D();
        } else if (geoType.equals(GeometryType.GEOREGION3D)) {
            geometry = new GeoRegion3D();
        } else if (geoType.equals(GeometryType.GEOPIE)) {
            geometry = new GeoPie();
        } else if (geoType.equals(GeometryType.GEOCIRCLE)) {
            geometry = new GeoCircle();
        } else if (geoType.equals(GeometryType.GEOCIRCLE3D)) {
            geometry = new GeoCircle3D();
        } else if (geoType.equals(GeometryType.GEOPIE3D)) {
            geometry = new GeoPie3D();
        } else if (geoType.equals(GeometryType.GEOPIECYLINDER)) {
            geometry = new GeoPieCylinder();
        } else if (geoType.equals(GeometryType.GEOSPHERE)) {
            geometry = new GeoSphere();
        } else if (geoType.equals(GeometryType.GEOHEMISPHERE)) {
            geometry = new GeoHemiSphere();
        } else if (geoType.equals(GeometryType.GEOELLIPSOID)) {
            geometry = new GeoEllipsoid();
        } else if (geoType.equals(GeometryType.GEOCOMPOUND)) {
            geometry = new GeoCompound();
        } else if (geoType.equals(GeometryType.GEORECTANGLE)) {
            geometry = new GeoRectangle();
        } else if (geoType.equals(GeometryType.GEOELLIPSE)) {
            geometry = new GeoEllipse();
        } else if (geoType.equals(GeometryType.GEOELLIPTICARC)) {
            geometry = new GeoEllipticArc();
        } else if (geoType.equals(GeometryType.GEOROUNDRECTANGLE)) {
            geometry = new GeoRoundRectangle();
        } else if (geoType.equals(GeometryType.GEOBOX)) {
            geometry = new GeoBox();
        } else if (geoType.equals(GeometryType.GEOCONE)) {
            geometry = new GeoCone();
        } else if (geoType.equals(GeometryType.GEOPLACEMARK)) {
            geometry = new GeoPlacemark();
        } else if (geoType.equals(GeometryType.GEOARC)) {
            geometry = new GeoArc();
        } else if (geoType.equals(GeometryType.GEOBSPLINE)) {
            geometry = new GeoBSpline();
        } else if (geoType.equals(GeometryType.GEOCARDINAL)) {
            geometry = new GeoCardinal();
        } else if (geoType.equals(GeometryType.GEOCHORD)) {
            geometry = new GeoChord();
        } else if (geoType.equals(GeometryType.GEOCYLINDER)) {
            geometry = new GeoCylinder();
        } else if (geoType.equals(GeometryType.GEOPYRAMID)) {
            geometry = new GeoPyramid();
        } else if (geoType.equals(GeometryType.GEOCURVE)) {
            geometry = new GeoCurve();
        } else if (geoType.equals(GeometryType.GEOPICTURE)) {
            geometry = new GeoPicture();
        } else if (geoType.equals(GeometryType.GEOMAP)) {
            geometry = new GeoMap();
        } else if (geoType.equals(GeometryType.GEOMAPSCALE)) {
            geometry = new GeoMapScale();
        } else if (geoType.equals(GeometryType.GEONORTHARROW)) {
            geometry = new GeoNorthArrow();
        } else if (geoType.equals(GeometryType.GEOMAPBORDER)) {
            geometry = new GeoMapBorder();
        } else if (geoType.equals(GeometryType.GEOMODEL)) {
            geometry = new GeoModel();
        } else if (geoType.equals(GeometryType.GEOMODEL3D)) {
            geometry = new GeoModel3D();
        } else if (geoType.equals(GeometryType.GEOTEXT3D)) {
            geometry = new GeoText3D();
        } else if (geoType.equals(GeometryType.GEOPICTURE3D)) {
            geometry = new GeoPicture3D();
        } else if (geoType.equals(GeometryType.GEOPARAMETRICLINECOMPOUND)) {
            geometry = new GeoParametricLineCompound();
        } else if (geoType.equals(GeometryType.GEOPARAMETRICREGIONCOMPOUND)) {
            geometry = new GeoParametricRegionCompound();
        } else if (geoType.equals(GeometryType.GEOPARAMETRICLINE)) {
            geometry = new GeoParametricLine();
        } else if (geoType.equals(GeometryType.GEOPARAMETRICREGION)) {
            geometry = new GeoParametricRegion();
        } else if (!geoType.equals(GeometryType.GEOLEGEND)) {
            if (geoType.equals(GeometryType.GEOPOINTEPS)) {
                geometry = new GeoPointEPS();
            } else if (geoType.equals(GeometryType.GEOLINEEPS)) {
                geometry = new GeoLineEPS();
            } else if (geoType.equals(GeometryType.GEOREGIONEPS)) {
                geometry = new GeoRegionEPS();
            } else if (geoType.equals(GeometryType.GEOTEXTEPS)) {
                geometry = new GeoTextEPS();
            } else if (geoType.equals(GeometryType.GEOUSERDEFINED)) {
                geometry = new GeoUserDefined();
            } else if (geoType.equals(GeometryType.GRAPHICOBJECT)) {
                geometry = new GeoGraphicObject();
            } else if (geoType.equals(GeometryType.GEOTIM)) {
                geometry = new GeoTIM();
            } else {
                throw new RuntimeException("$$$\u9429\u7a3f\u53e7\u7eeb\u8bf2\u7037\u6769\u6a3b\u6e6d\u7039\u70b5\u5e47");
            }
        }
        geometry.m_geoType = geoType;
        geometry.setIsDisposable(true);
        return geometry;
    }

    static final Geometry createInstance2(long geoHandle, Workspace workspace) {
        if (geoHandle == 0L) {
            return null;
        }
        Geometry geometry = null;
        int n = GeometryNative.jni_GetType(geoHandle);
        int[] nArray = g_GeometryTypeValues;
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            GeometryType geometryType = GeometryType.parseUGCValue(n);
            if (geometryType.equals(GeometryType.GEOPOINT)) {
                geometry = new GeoPoint(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINE)) {
                geometry = new GeoLine(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOREGION)) {
                geometry = new GeoRegion(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTEXT)) {
                geometry = new GeoText(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINEM)) {
                geometry = new GeoLineM(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPOINT3D)) {
                geometry = new GeoPoint3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINE3D)) {
                geometry = new GeoLine3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOREGION3D)) {
                geometry = new GeoRegion3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPIE)) {
                geometry = new GeoPie(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE)) {
                geometry = new GeoCircle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE3D)) {
                geometry = new GeoCircle3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPIE3D)) {
                geometry = new GeoPie3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPIECYLINDER)) {
                geometry = new GeoPieCylinder(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOSPHERE)) {
                geometry = new GeoSphere(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOHEMISPHERE)) {
                geometry = new GeoHemiSphere(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOELLIPSOID)) {
                geometry = new GeoEllipsoid(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCOMPOUND)) {
                geometry = new GeoCompound(geoHandle);
            } else if (geometryType.equals(GeometryType.GEORECTANGLE)) {
                geometry = new GeoRectangle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOELLIPSE)) {
                geometry = new GeoEllipse(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOELLIPTICARC)) {
                geometry = new GeoEllipticArc(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOROUNDRECTANGLE)) {
                geometry = new GeoRoundRectangle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOBOX)) {
                geometry = new GeoBox(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCONE)) {
                geometry = new GeoCone(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPLACEMARK)) {
                geometry = new GeoPlacemark(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOARC)) {
                geometry = new GeoArc(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOBSPLINE)) {
                geometry = new GeoBSpline(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCARDINAL)) {
                geometry = new GeoCardinal(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCHORD)) {
                geometry = new GeoChord(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCYLINDER)) {
                geometry = new GeoCylinder(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPYRAMID)) {
                geometry = new GeoPyramid(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCURVE)) {
                geometry = new GeoCurve(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPICTURE)) {
                geometry = new GeoPicture(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMAP)) {
                geometry = new GeoMap(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMAPSCALE)) {
                geometry = new GeoMapScale(geoHandle);
            } else if (geometryType.equals(GeometryType.GEONORTHARROW)) {
                geometry = new GeoNorthArrow(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMAPBORDER)) {
                geometry = new GeoMapBorder(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMODEL)) {
                geometry = new GeoModel(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMODEL3D)) {
                geometry = new GeoModel3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTEXT3D)) {
                geometry = new GeoText3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPICTURE3D)) {
                geometry = new GeoPicture3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLEGEND)) {
                geometry = new GeoLegend(geoHandle, workspace);
            } else if (geometryType.equals(GeometryType.GEOPARTICLE)) {
                geometry = new GeoParticle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINECOMPOUND)) {
                geometry = new GeoParametricLineCompound(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGIONCOMPOUND)) {
                geometry = new GeoParametricRegionCompound(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINE)) {
                geometry = new GeoParametricLine(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGION)) {
                geometry = new GeoParametricRegion(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPOINTEPS)) {
                geometry = new GeoPointEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINEEPS)) {
                geometry = new GeoLineEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOREGIONEPS)) {
                geometry = new GeoRegionEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTEXTEPS)) {
                geometry = new GeoTextEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOUSERDEFINED)) {
                geometry = new GeoUserDefined(geoHandle);
            } else if (geometryType.equals(GeometryType.GRAPHICOBJECT)) {
                geometry = new GeoGraphicObject(geoHandle);
            }
            geometry.m_geoType = geometryType;
        } else {
            CustomGeometryCreatedEvent customGeometryCreatedEvent = new CustomGeometryCreatedEvent(Geometry.class, geoHandle, null);
            Geometry.fireCustomGeometryCreated(customGeometryCreatedEvent);
            geometry = customGeometryCreatedEvent.getCustomGeometry();
        }
        if (geometry != null) {
            geometry.setIsDisposable(true);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return geometry;
    }

    static final Geometry createInstance(long geoHandle) {
        if (geoHandle == 0L) {
            return null;
        }
        Geometry geometry = null;
        int n = GeometryNative.jni_GetType(geoHandle);
        boolean bl = true;
        for (int i = 0; i < g_GeometryTypeValues.length; ++i) {
            if (n != g_GeometryTypeValues[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            GeometryType geometryType = GeometryType.parseUGCValue(n);
            if (geometryType.equals(GeometryType.GEOPOINT)) {
                geometry = new GeoPoint(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINE)) {
                geometry = new GeoLine(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOREGION)) {
                geometry = new GeoRegion(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTEXT)) {
                geometry = new GeoText(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINEM)) {
                geometry = new GeoLineM(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPOINT3D)) {
                geometry = new GeoPoint3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINE3D)) {
                geometry = new GeoLine3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOREGION3D)) {
                geometry = new GeoRegion3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPIE)) {
                geometry = new GeoPie(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE)) {
                geometry = new GeoCircle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE3D)) {
                geometry = new GeoCircle3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPIE3D)) {
                geometry = new GeoPie3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPIECYLINDER)) {
                geometry = new GeoPieCylinder(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOSPHERE)) {
                geometry = new GeoSphere(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOHEMISPHERE)) {
                geometry = new GeoHemiSphere(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOELLIPSOID)) {
                geometry = new GeoEllipsoid(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCOMPOUND)) {
                geometry = new GeoCompound(geoHandle);
            } else if (geometryType.equals(GeometryType.GEORECTANGLE)) {
                geometry = new GeoRectangle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOELLIPSE)) {
                geometry = new GeoEllipse(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOELLIPTICARC)) {
                geometry = new GeoEllipticArc(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOROUNDRECTANGLE)) {
                geometry = new GeoRoundRectangle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOBOX)) {
                geometry = new GeoBox(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCONE)) {
                geometry = new GeoCone(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPLACEMARK)) {
                geometry = new GeoPlacemark(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOARC)) {
                geometry = new GeoArc(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOBSPLINE)) {
                geometry = new GeoBSpline(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCARDINAL)) {
                geometry = new GeoCardinal(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCHORD)) {
                geometry = new GeoChord(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCYLINDER)) {
                geometry = new GeoCylinder(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPYRAMID)) {
                geometry = new GeoPyramid(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOCURVE)) {
                geometry = new GeoCurve(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPICTURE)) {
                geometry = new GeoPicture(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMAP)) {
                geometry = new GeoMap(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMAPSCALE)) {
                geometry = new GeoMapScale(geoHandle);
            } else if (geometryType.equals(GeometryType.GEONORTHARROW)) {
                geometry = new GeoNorthArrow(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMAPBORDER)) {
                geometry = new GeoMapBorder(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMODEL)) {
                geometry = new GeoModel(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOMODEL3D)) {
                geometry = new GeoModel3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOBILLBOARD)) {
                geometry = new GeoBillboard(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTEXT3D)) {
                geometry = new GeoText3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPICTURE3D)) {
                geometry = new GeoPicture3D(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARTICLE)) {
                geometry = new GeoParticle(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINECOMPOUND)) {
                geometry = new GeoParametricLineCompound(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGIONCOMPOUND)) {
                geometry = new GeoParametricRegionCompound(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINE)) {
                geometry = new GeoParametricLine(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGION)) {
                geometry = new GeoParametricRegion(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLEGEND)) {
                geometry = new GeoLegend(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOPOINTEPS)) {
                geometry = new GeoPointEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOLINEEPS)) {
                geometry = new GeoLineEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOREGIONEPS)) {
                geometry = new GeoRegionEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTEXTEPS)) {
                geometry = new GeoTextEPS(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOUSERDEFINED)) {
                geometry = new GeoUserDefined(geoHandle);
            } else if (geometryType.equals(GeometryType.GRAPHICOBJECT)) {
                geometry = new GeoGraphicObject(geoHandle);
            } else if (geometryType.equals(GeometryType.GEOTIM)) {
                geometry = new GeoTIM(geoHandle, false);
            }
            geometry.m_geoType = geometryType;
        } else {
            CustomGeometryCreatedEvent customGeometryCreatedEvent = new CustomGeometryCreatedEvent(Geometry.class, geoHandle, null);
            Geometry.fireCustomGeometryCreated(customGeometryCreatedEvent);
            geometry = customGeometryCreatedEvent.getCustomGeometry();
        }
        if (geometry != null) {
            geometry.setIsDisposable(true);
        }
        return geometry;
    }

    static final int[] getSpatialData(long geoHandle) {
        return GeometryNative.jni_GetSpatialData(geoHandle);
    }

    protected static final int[] internalGetSpatialData(long geoHandle) {
        return Geometry.getSpatialData(geoHandle);
    }

    protected static final Geometry internalCreateInstance(long geoHandle) {
        return Geometry.createInstance(geoHandle);
    }

    protected static final Geometry internalCreateInstance2(long geoHandle, Workspace workspace) {
        return Geometry.createInstance2(geoHandle, workspace);
    }

    protected void refreshHandle(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
        this.m_geoType = null;
    }

    public static synchronized void addCustomGeometryCreatedListener(CustomGeometryCreatedListener l) {
        if (m_customGeometryCreateListeners == null) {
            m_customGeometryCreateListeners = new Vector();
        }
        if (!m_customGeometryCreateListeners.contains(l)) {
            m_customGeometryCreateListeners.insertElementAt(l, 0);
        }
    }

    public static synchronized void removeCustomGeometryCreatedListener(CustomGeometryCreatedListener l) {
        if (m_customGeometryCreateListeners != null && m_customGeometryCreateListeners.contains(l)) {
            m_customGeometryCreateListeners.remove(l);
        }
    }

    protected static void fireCustomGeometryCreated(CustomGeometryCreatedEvent event) {
        if (m_customGeometryCreateListeners != null) {
            Vector vector = m_customGeometryCreateListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((CustomGeometryCreatedListener)vector.elementAt(i)).customGeometryCreated(event);
            }
        }
    }
}

