/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeometriesRelationNative;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.GriddingLevel;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SpatialQueryMode;
import java.util.ArrayList;

public class GeometriesRelation
extends InternalHandleDisposable {
    private ArrayList<Geometry> m_aryGeos = new ArrayList();
    private int m_nSource = -1;

    public GeometriesRelation() {
        this.setHandle(GeometriesRelationNative.jni_New(false), true);
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            GeometriesRelationNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
        this.m_aryGeos.clear();
    }

    public void setTolerance(double interval) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (interval < 0.0) {
            String string = InternalResource.loadString("interval", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometriesRelationNative.jni_SetInterval(this.getHandle(), interval);
    }

    public double getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return GeometriesRelationNative.jni_GetInterval(this.getHandle());
    }

    public GriddingLevel getGridding() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        int n = GeometriesRelationNative.jni_GetGriddingLevel(this.getHandle());
        return (GriddingLevel)Enum.parse(GriddingLevel.class, n);
    }

    public void setGridding(GriddingLevel level) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeometriesRelationNative.jni_SetGriddingLevel(this.getHandle(), level.getUGCValue());
    }

    public boolean insert(Geometry geometry, int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOPOINT && geometry.getType() != GeometryType.GEOLINE && geometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometry", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_aryGeos.add(geometry);
        return GeometriesRelationNative.jni_Insert(this.getHandle(), geometry.getHandle(), value);
    }

    public int getSourcesCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return GeometriesRelationNative.jni_GetSrcCount(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        double[] dArray = new double[4];
        GeometriesRelationNative.jni_GetBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public int[] matches(Geometry geometry, SpatialQueryMode mode) {
        return this.matches(geometry, mode, null);
    }

    public int[] matches(Geometry geometry, SpatialQueryMode mode, int[] excludes) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nSource == -1) {
            this.m_nSource = this.getSourcesCount();
        }
        if (this.m_nSource == 0) {
            String string = InternalResource.loadString("GeometriesRelation", "SourceGeometyCountMustBeGreaterThan0", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!GeometriesRelationNative.jni_Check(this.getHandle(), geometry.getType().getUGCValue(), mode.getUGCValue())) {
            String string = InternalResource.loadString("mode", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometriesRelationNative.jni_Match1(this.getHandle(), geometry.getHandle(), mode.getUGCValue(), excludes);
    }

    public int[] matches(Geometry[] geometries, SpatialQueryMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometries == null) {
            String string = InternalResource.loadString("geometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometries.length == 0) {
            String string = InternalResource.loadString("geometries", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nSource == -1) {
            this.m_nSource = this.getSourcesCount();
        }
        if (this.m_nSource == 0) {
            String string = InternalResource.loadString("GeometriesRelation", "SourceGeometyCountMustBeGreaterThan0", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            Geometry geometry = geometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("geometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getHandle() == 0L) {
                String string = InternalResource.loadString(String.format("geometries[%d]", i), "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (!GeometriesRelationNative.jni_Check(this.getHandle(), geometry.getType().getUGCValue(), mode.getUGCValue())) {
                String string = InternalResource.loadString(String.format("mode & geometries[%d]", i), "Geometry_Type_Invalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geometry.getHandle();
        }
        return GeometriesRelationNative.jni_Match4(this.getHandle(), lArray, mode.getUGCValue());
    }

    public int[] matches(Point2D point, SpatialQueryMode mode) {
        return this.matches(point, mode, null);
    }

    public int[] matches(Point2D point, SpatialQueryMode mode, int[] excludes) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nSource == -1) {
            this.m_nSource = this.getSourcesCount();
        }
        if (this.m_nSource == 0) {
            String string = InternalResource.loadString("GeometriesRelation", "SourceGeometyCountMustBeGreaterThan0", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!GeometriesRelationNative.jni_Check(this.getHandle(), GeometryType.GEOPOINT.getUGCValue(), mode.getUGCValue())) {
            String string = InternalResource.loadString("mode", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometriesRelationNative.jni_Match2(this.getHandle(), point.getX(), point.getY(), mode.getUGCValue(), excludes);
    }

    public int[] matches(Point2D[] points, SpatialQueryMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.length == 0) {
            String string = InternalResource.loadString("points", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < points.length; ++i) {
            if (points[i] != null) continue;
            String string = InternalResource.loadString(String.format("points[%d]", i), "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nSource == -1) {
            this.m_nSource = this.getSourcesCount();
        }
        if (this.m_nSource == 0) {
            String string = InternalResource.loadString("GeometriesRelation", "SourceGeometyCountMustBeGreaterThan0", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!GeometriesRelationNative.jni_Check(this.getHandle(), GeometryType.GEOPOINT.getUGCValue(), mode.getUGCValue())) {
            String string = InternalResource.loadString("mode", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[points.length];
        double[] dArray2 = new double[points.length];
        for (int i = 0; i < points.length; ++i) {
            dArray[i] = points[i].x;
            dArray2[i] = points[i].y;
        }
        return GeometriesRelationNative.jni_Match3(this.getHandle(), dArray, dArray2, mode.getUGCValue());
    }

    public boolean isMatch(Point2D point, int srcValue, SpatialQueryMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nSource == -1) {
            this.m_nSource = this.getSourcesCount();
        }
        if (this.m_nSource == 0) {
            String string = InternalResource.loadString("GeometriesRelation", "SourceGeometyCountMustBeGreaterThan0", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!GeometriesRelationNative.jni_Check(this.getHandle(), GeometryType.GEOPOINT.getUGCValue(), mode.getUGCValue())) {
            String string = InternalResource.loadString("mode", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometriesRelationNative.jni_isMatch1(this.getHandle(), point.getX(), point.getY(), mode.getUGCValue(), srcValue);
    }

    public boolean isMatch(Geometry geometry, int srcValue, SpatialQueryMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nSource == -1) {
            this.m_nSource = this.getSourcesCount();
        }
        if (this.m_nSource == 0) {
            String string = InternalResource.loadString("GeometriesRelation", "SourceGeometyCountMustBeGreaterThan0", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!GeometriesRelationNative.jni_Check(this.getHandle(), geometry.getType().getUGCValue(), mode.getUGCValue())) {
            String string = InternalResource.loadString("mode", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometriesRelationNative.jni_isMatch2(this.getHandle(), geometry.getHandle(), mode.getUGCValue(), srcValue);
    }

    public int[] intersectExtents(Rectangle2D extents) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeometriesRelation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (extents == null) {
            String string = InternalResource.loadString("extents", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = GeometriesRelationNative.jni_intersectExtents(this.getHandle(), extents.getLeft(), extents.getTop(), extents.getRight(), extents.getBottom());
        if (nArray != null) {
            return nArray;
        }
        return new int[0];
    }
}

