/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPlacemarkNative;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TextStyle;
import java.awt.Color;

public class GeoPlacemark
extends Geometry3D {
    private Geometry m_geometry;
    private TextStyle m_textStyle = null;

    public GeoPlacemark() {
        long l = GeoPlacemarkNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoPlacemark(GeoPlacemark geoPlacemark) {
        if (geoPlacemark == null) {
            String string = InternalResource.loadString("geoPlacemark", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoPlacemark);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPlacemark", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPlacemarkNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPlacemark);
    }

    GeoPlacemark(long handle) {
        this.setHandle(handle, false);
    }

    public GeoPlacemark(String name, Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("value", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPlacemarkNative.jni_New1(name, l);
        this.setHandle(l2, true);
        this.getNameStyle().setForeColor(Color.white);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPlacemarkNative.jni_getName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPlacemarkNative.jni_setName(this.getHandle(), value);
    }

    public Geometry getGeometry() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetGeometry()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoPlacemarkNative.jni_getGeometry(this.getHandle());
        if (this.m_geometry == null) {
            if (l != 0L) {
                this.m_geometry = Geometry.createInstance(l);
                this.m_geometry.setIsDisposable(false);
            }
        } else if (l != 0L) {
            this.m_geometry.clearHandle();
            this.m_geometry.setHandle(l, false);
        }
        return this.m_geometry;
    }

    public void setGeometry(Geometry value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetGeometry(Geometry value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value instanceof GeoPlacemark) {
            String string = InternalResource.loadString("value", "GeoPlacemark_SetGeometryShouldNotBeGeoPlacemark", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(value);
        if (l == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.getGeometry();
        if (this.m_geometry == null) {
            this.m_geometry = value.clone();
            InternalHandleDisposable.setIsDisposable(this.m_geometry, false);
            GeoPlacemarkNative.jni_setGeometry(this.getHandle(), this.m_geometry.getHandle());
        } else if (value.getClass().equals(this.m_geometry.getClass())) {
            this.m_geometry.clearHandle();
            Geometry geometry = value.clone();
            this.m_geometry.setHandle(geometry.getHandle(), false);
            GeoPlacemarkNative.jni_setGeometry(this.getHandle(), this.m_geometry.getHandle());
        } else {
            Geometry geometry;
            this.m_geometry.clearHandle();
            this.m_geometry = geometry = value.clone();
            InternalHandleDisposable.setIsDisposable(geometry, false);
            GeoPlacemarkNative.jni_setGeometry(this.getHandle(), this.m_geometry.getHandle());
        }
        long l2 = GeoPlacemarkNative.jni_getNameStyle(this.getHandle());
        this.m_textStyle = this.getNameStyle();
        if (l2 != 0L && l2 != this.m_textStyle.getHandle()) {
            TextStyle.refreshHandle(this.m_textStyle, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public TextStyle getNameStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetNameStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_textStyle == null) {
            long l = GeoPlacemarkNative.jni_getNameStyle(this.getHandle());
            if (l != 0L) {
                this.m_textStyle = TextStyle.createInstance(l);
            } else {
                TextStyle textStyle = new TextStyle();
                GeoPlacemarkNative.jni_setNameStyle(this.getHandle(), textStyle.getHandle());
                long l2 = GeoPlacemarkNative.jni_getNameStyle(this.getHandle());
                this.m_textStyle = TextStyle.createInstance(l2);
            }
        }
        return this.m_textStyle;
    }

    public void setNameStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetNameStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPlacemarkNative.jni_setNameStyle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    @Override
    public GeoPlacemark clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPlacemark(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPlacemarkNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.m_geometry != null) {
            this.m_geometry.clearHandle();
            this.m_geometry = null;
        }
    }
}

