/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoParticleNative;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.ParticleSystem;
import com.supermap.data.ParticleType;

public class GeoParticle
extends Geometry3D {
    public GeoParticle() {
        this.setHandle(GeoParticleNative.jni_New(), true);
    }

    GeoParticle(long handle) {
        this.setHandle(handle, false);
    }

    public GeoParticle(GeoParticle geoParticle) {
        if (geoParticle == null) {
            String string = InternalResource.loadString("GeoParticle(GeoParticle geoParticle)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoParticle);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParticle(GeoParticle geoParticle)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoParticleNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParticle);
    }

    public GeoParticle(String filename, Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("GeoParticle(String file, Geometry geometry)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParticle(String file, Geometry geometry)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(GeoParticleNative.jni_NewWithFileAndGeometry(filename, l), true);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
    }

    public GeoParticle(ParticleType type, Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("GeoParticle(ParticleType type, Geometry geometry)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParticle(ParticleType type, Geometry geometry)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.ConverType2FilePath(type);
        this.setHandle(GeoParticleNative.jni_NewWithFileAndGeometry(string, l), true);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
    }

    private int ConverFilePath2Type(String path) {
        int n = 0;
        if (path == "fire.par") {
            n = 1;
        } else if (path == "smoke.par") {
            n = 2;
        } else if (path == "fountain.par") {
            n = 3;
        } else if (path == "blast.par") {
            n = 4;
        } else if (path == "rain.par") {
            n = 5;
        } else if (path == "snow.par") {
            n = 6;
        } else if (path == "tailflame.par") {
            n = 7;
        } else if (path == "firesmoke.par") {
            n = 8;
        } else if (path == "firework.par") {
            n = 9;
        }
        return n;
    }

    private String ConverType2FilePath(ParticleType type) {
        String string = "";
        switch (type.value()) {
            case 1: {
                string = "fire.par";
                break;
            }
            case 2: {
                string = "smoke.par";
                break;
            }
            case 3: {
                string = "fountain.par";
                break;
            }
            case 4: {
                string = "blast.par";
                break;
            }
            case 5: {
                string = "rain.par";
                break;
            }
            case 6: {
                string = "snow.par";
                break;
            }
            case 7: {
                string = "tailflame.par";
                break;
            }
            case 8: {
                string = "firesmoke.par";
                break;
            }
            case 9: {
                string = "firework.par";
                break;
            }
        }
        return string;
    }

    public ParticleType getParticleType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.ConverFilePath2Type(this.getParticleFilePath());
        if (n == 0) {
            n = GeoParticleNative.jni_GetParticleType(this.getHandle());
        }
        return (ParticleType)Enum.parseUGCValue(ParticleType.class, n);
    }

    public void setParticleType(ParticleType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = this.ConverType2FilePath(type);
        GeoParticleNative.jni_SetParticleFilePath(this.getHandle(), string);
    }

    public void setParticleFilePath(String filename) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPath(String file)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParticleNative.jni_SetParticleFilePath(this.getHandle(), filename);
    }

    public String getParticleFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPath()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParticleNative.jni_GetParticleFilePath(this.getHandle());
    }

    public boolean makeWithGeometry(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeometry(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("setGeometry(Geometry geometry)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = geometry.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("setGeometry(Geometry geometry)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeoParticleNative.jni_MakeWithGemetry(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public boolean isValid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeometry(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParticleNative.jni_IsValid(this.getHandle());
    }

    @Override
    public GeoParticle clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoParticle(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoParticleNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public ParticleSystem[] getParticleSystems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoParticleNative.jni_GetParticleSystemCount(this.getHandle());
        long[] lArray = new long[n];
        GeoParticleNative.jni_GetParticleSystems(this.getHandle(), lArray);
        ParticleSystem[] particleSystemArray = new ParticleSystem[n];
        for (int i = 0; i < n; ++i) {
            particleSystemArray[i] = new ParticleSystem(lArray[i]);
        }
        return particleSystemArray;
    }
}

