/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoParametricLine;
import com.supermap.data.GeoParametricLineCompoundNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoParametricLineCompound
extends GeoParametricLine {
    private ArrayList<Geometry> m_ChildGeometryList;

    public GeoParametricLineCompound() {
        super(0L);
        long l = GeoParametricLineCompoundNative.jni_New();
        this.setHandle(l, true);
        this.m_ChildGeometryList = new ArrayList();
    }

    GeoParametricLineCompound(long handle) {
        super(0L);
        this.setHandle(handle, false);
        this.m_ChildGeometryList = new ArrayList();
        GeoParametricLineCompound.refreshFromUGC1(this);
    }

    public GeoParametricLineCompound(GeoParametricLineCompound geoParamLineComp) {
        super(0L);
        if (geoParamLineComp == null) {
            String string = InternalResource.loadString("GeoParametricLineCompound", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoParamLineComp);
        if (l == 0L) {
            String string = InternalResource.loadString("geoCompoundLine", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoParametricLineCompoundNative.jni_Clone(l);
        this.m_ChildGeometryList = new ArrayList();
        this.setHandle(l2, true);
        GeoParametricLineCompound.refreshFromUGC1(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParamLineComp);
    }

    @Override
    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricLineCompoundNative.jni_getLength(this.getHandle());
    }

    @Override
    public int add(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddSub(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoParametricLineCompoundNative.jni_add(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.m_ChildGeometryList.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.m_ChildGeometryList.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    @Override
    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSubCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricLineCompoundNative.jni_getCount(this.getHandle());
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemoveSub(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_ChildGeometryList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        bl = GeoParametricLineCompoundNative.jni_remove(this.getHandle(), index);
        if (bl) {
            this.m_ChildGeometryList.get(index).clearHandle();
            InternalHandleDisposable.setIsDisposable(this.m_ChildGeometryList.get(index), true);
            this.m_ChildGeometryList.remove(index);
        }
        return bl;
    }

    @Override
    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSub(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_ChildGeometryList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_ChildGeometryList.get(index);
    }

    public boolean insert(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Insert(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.m_ChildGeometryList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoParametricLineCompoundNative.jni_insert(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            this.m_ChildGeometryList.add(index, geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    @Override
    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSub(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.m_ChildGeometryList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoParametricLineCompoundNative.jni_set(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this.m_ChildGeometryList.get(index);
            geometry3.clearHandle();
            this.m_ChildGeometryList.remove(index);
            this.m_ChildGeometryList.add(index, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    @Override
    public GeoParametricLineCompound clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoParametricLineCompound(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoParametricLineCompoundNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricLineCompoundNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this.m_ChildGeometryList.size(); ++i) {
            this.m_ChildGeometryList.get(i).setIsDisposable(true);
            this.m_ChildGeometryList.get(i).setHandle(0L);
            this.m_ChildGeometryList.get(i).clearHandle();
        }
        this.m_ChildGeometryList.clear();
    }

    static void refreshFromUGC1(GeoParametricLineCompound geoCompound) {
        int n = geoCompound.getCount();
        long[] lArray = new long[n];
        GeoParametricLineCompoundNative.jni_AllGeometrys(geoCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoCompound.m_ChildGeometryList.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompound);
    }

    void refrashSubsList() {
        for (int i = 0; i < this.m_ChildGeometryList.size(); ++i) {
            Geometry geometry;
            if (this.m_ChildGeometryList.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this.m_ChildGeometryList.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this.m_ChildGeometryList.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this.m_ChildGeometryList.get(i);
            ((GeoLine)geometry).refrashPartsList();
        }
    }

    protected static GeoParametricLineCompound creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoParametricLineCompound(handle);
    }
}

