/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridNative;
import com.supermap.data.DatasetVolumeNative;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.StatisticsResult;
import java.util.HashMap;

public class DatasetVolume
extends Dataset {
    private GeoRegion m_clipRegion = null;
    private Colors m_colors;
    private static Integer m_lock = new Integer(0);

    protected DatasetVolume(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
    }

    protected DatasetVolume() {
        m_senderMethodName = "buildPyramid";
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_GetHeight(this.getHandle());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVolumeNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null && (l = DatasetVolumeNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.m_clipRegion = (GeoRegion)Geometry.createInstance(l);
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.m_clipRegion != null) {
                this.m_clipRegion.clearHandle();
                this.m_clipRegion = null;
            }
            DatasetVolumeNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVolumeNative.jni_SetClipRegion(this.getHandle(), value.getHandle());
            if (this.m_clipRegion != null) {
                this.m_clipRegion.fromXML(value.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public HashMap<Integer, StatisticsResult> getVolumeStatisticsResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
        int n = this.getSliceCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        boolean bl = DatasetVolumeNative.jni_GetRasterStatisticsResult(this.getHandle(), nArray, lArray);
        for (int i = 0; i < n; ++i) {
            StatisticsResult statisticsResult = new StatisticsResult(lArray[i]);
            hashMap.put(nArray[i], statisticsResult);
        }
        return hashMap;
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_GetHasPyramid(this.getHandle());
    }

    public int getSliceCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSliceCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_GetSliceCount(this.getHandle());
    }

    public double getNoData(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_GetNoData(this.getHandle(), index);
    }

    public void setNoData(double value, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        DatasetVolumeNative.jni_SetNoData(this.getHandle(), value, index);
    }

    public double getMinValue(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_GetMinValue1(this.getHandle(), index);
    }

    public double getMaxValue(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_GetMaxValue1(this.getHandle(), index);
    }

    public double getMinValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_GetMinValue2(this.getHandle());
    }

    public double getMaxValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_GetMaxValue2(this.getHandle());
    }

    public double getSliceAltitude(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_GetSliceAltitude(this.getHandle(), index);
    }

    public boolean setSliceAltitude(double value, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_SetSliceAltitude(this.getHandle(), value, index);
    }

    public Colors getColorTable() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_colors == null && (l = DatasetGridNative.jni_GetColorTable(this.getHandle())) != 0L) {
            this.m_colors = Colors.createInstance(l, false);
        }
        return this.m_colors;
    }

    public void setColorTable(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorTable(Colors colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(colors);
        if (l == 0L) {
            String string = InternalResource.loadString("colors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = new Colors(colors);
        long l2 = InternalHandleDisposable.getHandle(colors2);
        DatasetVolumeNative.jni_SetColorTable(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive(colors2);
    }

    public PixelFormat getPixelFormat(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = DatasetVolumeNative.jni_GetPixelFormat(this.getHandle(), index);
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public boolean setGeoReference(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        return DatasetVolumeNative.jni_SetBounds(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    public boolean calculateExtremum(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_CalculateExtremumByIndex(this.getHandle(), index);
    }

    public boolean calculateExtremum() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_CalculateExtremum(this.getHandle());
    }

    public double getValue(int column, int row, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || column >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (row < 0 || row >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_GetValue(this.getHandle(), column, row, index);
    }

    public double setValue(int column, int row, double value, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetGrid_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || column >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (row < 0 || row >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_SetValue(this.getHandle(), column, row, value, index);
    }

    public HashMap<Integer, StatisticsResult> buildStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
        int n = this.getSliceCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        boolean bl = DatasetVolumeNative.jni_BuildStatistics(this.getHandle(), nArray, lArray);
        if (!bl) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            StatisticsResult statisticsResult = null;
            if (lArray[i] == 0L) continue;
            statisticsResult = new StatisticsResult(lArray[i]);
            hashMap.put(nArray[i], statisticsResult);
        }
        return hashMap;
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetVolumeNative.jni_NewSelfEventHandle(this);
            bl = DatasetVolumeNative.jni_BuildPyramid(this.getHandle(), this.m_selfEventHandle);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean updatePyramid(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridNative.jni_UpdatePyramid(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_RemovePyramid(this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSlice(String bandname, PixelFormat value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addBand(DatasetVolume dataset)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetVolumeNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetVolume dataset)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (bandname == null || bandname.trim().length() == 0) {
            String string = InternalResource.loadString("bandname", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (value == PixelFormat.RGB || value == PixelFormat.RGBA) {
            String string = InternalResource.loadString("PixelFormat", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new NullPointerException(string);
        }
        if (this.getSliceCount() > 0 && value != this.getPixelFormat(0)) {
            return -1;
        }
        Integer n = m_lock;
        synchronized (n) {
            DatasetVolumeNative.jni_addSlice(this.getHandle(), bandname, value.getUGCValue());
            int n2 = this.getSliceCount();
            return n2 - 1;
        }
    }

    public String get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_getItem(this.getHandle(), index);
    }

    public void set(int index, String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Set(int index, String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getSliceCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = DatasetVolumeNative.jni_isContain(this.getHandle(), value);
        if (bl) {
            String string = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVolumeNative.jni_setItem(this.getHandle(), index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSlice(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteBand(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetVolumeNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("deleteBand(int index)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n = m_lock;
        synchronized (n) {
            if (index < 0 || index >= this.getSliceCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            return DatasetVolumeNative.jni_deleteSlice(this.getHandle(), index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSlice(int startIndex, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteBand(int startIndex, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetVolumeNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("deleteBand(int startIndex, int count)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n = m_lock;
        synchronized (n) {
            if (startIndex < 0 || startIndex >= this.getSliceCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            if (startIndex + count < startIndex || startIndex + count > this.getSliceCount()) {
                String string = InternalResource.loadString("satrtIndex\ufffd\ufffdcount", "DatasetImage_InvalidCount", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            return DatasetVolumeNative.jni_deleteSlices(this.getHandle(), startIndex, count);
        }
    }

    public int indexOf(String bandName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bandName == null || bandName.trim().length() == 0) {
            String string = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeNative.jni_indexOf(this.getHandle(), bandName);
    }

    public boolean append(int DesIndex, DatasetVolume dataset, int SrcIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dataset.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (DesIndex < 0 || DesIndex >= this.getSliceCount()) {
            String string = InternalResource.loadString("DesIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (SrcIndex < 0 || SrcIndex >= dataset.getSliceCount()) {
            String string = InternalResource.loadString("DesIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_Append(this.getHandle(), DesIndex, dataset.getHandle(), SrcIndex);
    }

    public boolean append(int DesIndex, DatasetGrid dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dataset.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (DesIndex < 0 || DesIndex >= this.getSliceCount()) {
            String string = InternalResource.loadString("DesIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetVolumeNative.jni_Append(this.getHandle(), DesIndex, dataset.getHandle(), 0);
    }

    @Override
    protected void clearHandle() {
        if (this.m_clipRegion != null) {
            this.m_clipRegion.clearHandle();
            this.m_clipRegion = null;
        }
        if (this.m_colors != null) {
            this.m_colors.clearHandle();
            this.m_colors = null;
        }
        this.setHandle(0L);
    }
}

