/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetTopologyNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalResource;
import com.supermap.data.TopologyDatasetRelationItems;
import com.supermap.data.TopologyRule;
import com.supermap.data.TopologyValidatingItem;

public class DatasetTopology
extends Dataset {
    private TopologyDatasetRelationItems m_relationItems;
    private DatasetVector m_datasetErrorPoint;
    private DatasetVector m_datasetErrorLine;
    private DatasetVector m_datasetErrorRegion;

    DatasetTopology(long handle, Datasource datasource) {
        this.setHandle(handle);
        this.m_datasource = datasource;
    }

    protected DatasetTopology() {
    }

    public double getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetTopologyNative.jni_GetTolerance(this.getHandle());
    }

    public void setTolerance(double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Tolerance_NodeSnapShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetTopologyNative.jni_SetTolerance(this.getHandle(), tolerance);
    }

    public DatasetVector getErrorPointDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetErrorPoint == null && (l = DatasetTopologyNative.jni_GetErrorPointDataset(this.getHandle())) != 0L) {
            this.m_datasetErrorPoint = DatasetVector.createInstance(l, this.m_datasource);
        }
        return this.m_datasetErrorPoint;
    }

    public DatasetVector getErrorLineDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetErrorLine == null && (l = DatasetTopologyNative.jni_GetErrorLineDataset(this.getHandle())) != 0L) {
            this.m_datasetErrorLine = DatasetVector.createInstance(l, this.m_datasource);
        }
        return this.m_datasetErrorLine;
    }

    public DatasetVector getErrorRegionDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetErrorRegion == null && (l = DatasetTopologyNative.jni_GetErrorRegionDataset(this.getHandle())) != 0L) {
            this.m_datasetErrorRegion = DatasetVector.createInstance(l, this.m_datasource);
        }
        return this.m_datasetErrorRegion;
    }

    public GeoRegion getDirtyRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetTopologyNative.jni_GetDirtyRegion(this.getHandle());
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = (GeoRegion)Geometry.createInstance(l);
        }
        return geoRegion;
    }

    public int addValidatingItem(TopologyValidatingItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_datasource.equals(item.getSourceDataset().getDatasource()) || !this.getRelationItems().contain(item.getSourceDataset().getName())) {
            String string = InternalResource.loadString("item", "TopologyValidatingItem_SourceDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!(item.getValidatingDataset() == null || this.m_datasource.equals(item.getValidatingDataset().getDatasource()) && this.getRelationItems().contain(item.getValidatingDataset().getName()))) {
            String string = InternalResource.loadString("item", "TopologyValidatingItem_ValidatingDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (item.getValidatingDataset() != null) {
            l = item.getValidatingDataset().getHandle();
        }
        int n = DatasetTopologyNative.jni_AddValidatingItem(this.getHandle(), item.getSourceDataset().getHandle(), l, item.getRule().getUGCValue());
        return n;
    }

    public boolean removeValidatingItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getValidatingItemCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetTopologyNative.jni_RemoveValidatingItemAt(this.getHandle(), index);
    }

    public void clearValidatingItem() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetTopologyNative.jni_ClearValidatingItem(this.getHandle());
    }

    public TopologyValidatingItem getValidatingItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getValidatingItemCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = new String[2];
        int n = DatasetTopologyNative.jni_GetValidatingItem(this.getHandle(), index, stringArray);
        TopologyRule topologyRule = (TopologyRule)Enum.parse(TopologyRule.class, n);
        TopologyValidatingItem topologyValidatingItem = new TopologyValidatingItem((DatasetVector)this.m_datasource.getDatasets().get(stringArray[0]), (DatasetVector)this.m_datasource.getDatasets().get(stringArray[1]), topologyRule);
        return topologyValidatingItem;
    }

    public void setValidatingItem(int index, TopologyValidatingItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getValidatingItemCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("validatingItem", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_datasource.equals(item.getSourceDataset().getDatasource()) || !this.m_datasource.getDatasets().contains(item.getSourceDataset().getName())) {
            String string = InternalResource.loadString("validatingItem", "TopologyValidatingItem_SourceDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_datasource.equals(item.getValidatingDataset().getDatasource()) || !this.m_datasource.getDatasets().contains(item.getValidatingDataset().getName())) {
            String string = InternalResource.loadString("validatingItem", "TopologyValidatingItem_ValidatingDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (item.getValidatingDataset() != null) {
            l = item.getValidatingDataset().getHandle();
        }
        DatasetTopologyNative.jni_SetValidatingItem(this.getHandle(), index, item.getSourceDataset().getHandle(), l, item.getRule().getUGCValue());
    }

    public int getValidatingItemCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetTopologyNative.jni_GetValidatingItemCount(this.getHandle());
    }

    public TopologyDatasetRelationItems getRelationItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_relationItems == null) {
            this.m_relationItems = new TopologyDatasetRelationItems(this);
        }
        return this.m_relationItems;
    }
}

