/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTransRunnable;
import com.supermap.data.CoordSysTranslatorNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetNative;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoLineM;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;

public final class CoordSysTranslator {
    private CoordSysTranslator() {
    }

    public static boolean forward(Point2Ds points, PrjCoordSys prjCoordSys) {
        int n;
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = points.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
            if (!(dArray[n] > 180.0 || dArray[n] < -180.0 || dArray2[n] > 90.0) && !(dArray2[n] < -90.0)) continue;
            String string = InternalResource.loadString("points", "InvalidLongitudeLatitudeCoord", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = CoordSysTranslatorNative.jni_Forward(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            points.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return n != 0;
    }

    public static boolean inverse(Point2Ds points, PrjCoordSys prjCoordSys) {
        int n;
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = points.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
        }
        n = CoordSysTranslatorNative.jni_Inverse(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            points.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return n != 0;
    }

    public static boolean convert(Datasource srcDatasource, PrjCoordSys desPrjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (srcDatasource == null || srcDatasource.getHandle() == 0L) {
            String string = InternalResource.loadString("srcDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desPrjCoordSys == null || desPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("desPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertDataSource(srcDatasource.getHandle(), desPrjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        InternalHandleDisposable.makeSureNativeObjectLive(desPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static boolean convert(Datasource srcDatasource, Datasource desDatasource, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (srcDatasource == null || srcDatasource.getHandle() == 0L) {
            String string = InternalResource.loadString("srcDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desDatasource == null || desDatasource.getHandle() == 0L) {
            String string = InternalResource.loadString("desDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertDataSource2(srcDatasource.getHandle(), desDatasource.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static boolean convert(Geometry geometry, PrjCoordSys srcPrjCoordSys, PrjCoordSys desPrjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcPrjCoordSys == null || srcPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desPrjCoordSys == null || desPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("desPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertGeometry(geometry.getHandle(), srcPrjCoordSys.getHandle(), desPrjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        if (geometry.getType() == GeometryType.GEOREGION) {
            ((GeoRegion)geometry).refrashPartsList();
        } else if (geometry.getType() == GeometryType.GEOLINE) {
            ((GeoLine)geometry).refrashPartsList();
        } else if (geometry.getType() == GeometryType.GEOLINE3D) {
            ((GeoLine3D)geometry).refrashPartsList();
        } else if (geometry.getType() == GeometryType.GEOREGION3D) {
            ((GeoRegion3D)geometry).refrashPartsList();
        } else if (geometry.getType() == GeometryType.GEOLINEM) {
            ((GeoLineM)geometry).refrashPartsList();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(srcPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(desPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static boolean convert(Point2Ds points, PrjCoordSys srcPrjCoordSys, PrjCoordSys desPrjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        int n;
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = points.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcPrjCoordSys == null || srcPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desPrjCoordSys == null || desPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
        }
        n = CoordSysTranslatorNative.jni_ConvertPoints(dArray, dArray2, srcPrjCoordSys.getHandle(), desPrjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            points.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(srcPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(desPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return n != 0;
    }

    public static boolean convert(Dataset dataset, PrjCoordSys targetPrjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (dataset == null || InternalHandle.getHandle(dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetPrjCoordSys == null || targetPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        dataset.m_selfEventHandle = DatasetNative.jni_NewSelfEventHandle(dataset);
        boolean bl = CoordSysTranslatorNative.jni_ConvertDataset(dataset.getHandle(), targetPrjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), dataset.m_selfEventHandle);
        dataset.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(targetPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static Dataset convert(Dataset sourceDataset, PrjCoordSys targetPrjCoordSys, Datasource targetDatasource, String targetDatasetName, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        return CoordSysTranslator.convert(sourceDataset, targetPrjCoordSys, targetDatasource, targetDatasetName, coordSysTransParameter, coordSysTransMethod, null);
    }

    public static Dataset convert(Dataset sourceDataset, PrjCoordSys targetPrjCoordSys, Datasource targetDatasource, String targetDatasetName, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod, CoordSysTransRunnable runnable) {
        if (sourceDataset == null || InternalHandle.getHandle(sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetPrjCoordSys == null || targetPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasetName == null || targetDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("targetDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (runnable != null) {
            runnable.setSourcePrj(sourceDataset.getPrjCoordSys());
            runnable.setTargetPrj(targetPrjCoordSys);
            runnable.setTransMethod(coordSysTransMethod);
            runnable.setTransParameter(coordSysTransParameter);
        }
        Dataset dataset = null;
        sourceDataset.m_selfEventHandle = DatasetNative.jni_NewSelfEventHandle(sourceDataset);
        long l = CoordSysTranslatorNative.jni_ConvertDataset2(sourceDataset.getHandle(), targetPrjCoordSys.getHandle(), targetDatasource.getHandle(), targetDatasetName, coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), sourceDataset.m_selfEventHandle, runnable);
        sourceDataset.clearSelfEventHandle();
        if (l != 0L) {
            dataset = Dataset.createInstance(l, sourceDataset.getType(), targetDatasource);
            targetDatasource.getDatasets().add(dataset);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(targetPrjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return dataset;
    }

    public static boolean convert(String inputFile, String outFile, PrjCoordSys srcPrjCoordSys, PrjCoordSys targetPrjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod, double resolution) {
        boolean bl = false;
        if (targetPrjCoordSys == null || targetPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcPrjCoordSys == null || srcPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (inputFile == null || inputFile.trim().length() == 0) {
            String string = InternalResource.loadString("inputFile", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (outFile == null || outFile.trim().length() == 0) {
            String string = InternalResource.loadString("outFile", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        bl = CoordSysTranslatorNative.jni_ConvertCUDATif(inputFile, outFile, srcPrjCoordSys.getHandle(), targetPrjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), resolution);
        return bl;
    }

    public static boolean convertDatasetModel(Dataset sourceDataset, PrjCoordSys targetPrjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod, boolean bInstance) {
        if (sourceDataset == null || InternalHandle.getHandle(sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetPrjCoordSys == null || targetPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertDatasetModel(sourceDataset.getHandle(), targetPrjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), bInstance);
        return bl;
    }

    public static Dataset convertDatasetModel(Dataset sourceDataset, PrjCoordSys targetPrjCoordSys, Datasource targetDatasource, String targetDatasetName, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod, boolean bInstance) {
        if (sourceDataset == null || InternalHandle.getHandle(sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetPrjCoordSys == null || targetPrjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Dataset dataset = null;
        long l = CoordSysTranslatorNative.jni_ConvertDatasetModel2(sourceDataset.getHandle(), targetPrjCoordSys.getHandle(), targetDatasource.getHandle(), targetDatasetName, coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), bInstance);
        if (l != 0L) {
            dataset = Dataset.createInstance(l, sourceDataset.getType(), targetDatasource);
        }
        return dataset;
    }
}

