/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.annotation;

import com.supermap.analyst.spatialanalyst.BufferAnalystParameter;
import com.supermap.annotation.InputFieldDef;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Utils {
    private static Map<Class, Class> PRIMITIVE_MAP = new HashMap<Class, Class>();

    Utils() {
    }

    static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    static Field findField(String fieldDef, Class valueClass, Class ownerClass) {
        if (ownerClass == null || Utils.isNullOrEmpty(fieldDef)) {
            return null;
        }
        try {
            Field[] fieldArray;
            for (Field field2 : fieldArray = (Field[])Arrays.stream(ownerClass.getDeclaredFields()).filter(field -> !Modifier.isFinal(field.getModifiers())).toArray(Field[]::new)) {
                InputFieldDef inputFieldDef = field2.getAnnotation(InputFieldDef.class);
                if (inputFieldDef == null || !inputFieldDef.name().equals(fieldDef) || !Utils.isCompatible(valueClass, field2.getType())) continue;
                return field2;
            }
            Field field3 = Utils.findCorrectField(fieldDef, valueClass, ownerClass);
            if (field3 != null) {
                return field3;
            }
            return Utils.findCorrectField("m_" + fieldDef, valueClass, ownerClass);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isCompatible(Class source, Class target) {
        return (source = PRIMITIVE_MAP.getOrDefault(source, source)) == (target = PRIMITIVE_MAP.getOrDefault(target, target)) || target.isAssignableFrom(source);
    }

    private static Field findCorrectField(String fieldName, Class valueClass, Class ownerClass) {
        try {
            Field field = ownerClass.getDeclaredField(fieldName);
            if (field.getClass().isAssignableFrom(valueClass)) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        return null;
    }

    static boolean setFieldValue(Field field, Object value, Object owner) {
        if (owner == null || field == null) {
            return false;
        }
        try {
            Method[] methodArray;
            Class<?> clazz = owner.getClass();
            for (Method method2 : methodArray = (Method[])Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).toArray(Method[]::new)) {
                if (method2.getParameterCount() != 1 || method2.getParameters()[0].getType() != field.getType()) continue;
                String string = Utils.getExpectedSetterName(field);
                if (!method2.getName().equalsIgnoreCase(string)) continue;
                method2.invoke(owner, value);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static String getExpectedSetterName(Field field) {
        String string;
        if (field == null) {
            return null;
        }
        String string2 = string = field.getName().startsWith("m_") ? field.getName().substring(2) : field.getName();
        if ((field.getType() == Boolean.class || field.getType() == Boolean.TYPE) && string.startsWith("is")) {
            string = string.substring(2);
        }
        if (string.length() > 0) {
            return "set" + string;
        }
        return null;
    }

    public static void main(String[] args) {
        BufferAnalystParameter bufferAnalystParameter = new BufferAnalystParameter();
        System.out.println(bufferAnalystParameter.getEndType());
    }

    static {
        PRIMITIVE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class);
    }
}

