/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.annotation;

import com.supermap.analyst.spatialanalyst.BufferAnalystParameter;
import com.supermap.analyst.spatialanalyst.BufferEndType;
import com.supermap.analyst.spatialanalyst.BufferRadiusUnit;
import com.supermap.annotation.IParameterBuilder;
import java.util.Map;

public class BufferAnalystParameterBuilder
implements IParameterBuilder {
    @Override
    public Object build(Map<String, Object> map) {
        double d;
        BufferEndType bufferEndType = (BufferEndType)map.getOrDefault("bufferEndType", BufferEndType.FLAT);
        int n = (Integer)map.getOrDefault("semicircleLineSegment", 100);
        String string = (String)map.getOrDefault("leftDistance", 10);
        String string2 = (String)map.getOrDefault("rightDistance", 10);
        BufferRadiusUnit bufferRadiusUnit = (BufferRadiusUnit)map.getOrDefault("bufferRadiusUnit", BufferRadiusUnit.Meter);
        BufferAnalystParameter bufferAnalystParameter = new BufferAnalystParameter();
        bufferAnalystParameter.setEndType(bufferEndType);
        bufferAnalystParameter.setSemicircleLineSegment(n);
        bufferAnalystParameter.setRadiusUnit(bufferRadiusUnit);
        try {
            d = Double.parseDouble(string);
            bufferAnalystParameter.setLeftDistance(d);
        }
        catch (NumberFormatException numberFormatException) {
            bufferAnalystParameter.setLeftDistance(this.resolveDistance(string));
        }
        try {
            d = Double.parseDouble(string2);
            bufferAnalystParameter.setRightDistance(d);
        }
        catch (NumberFormatException numberFormatException) {
            bufferAnalystParameter.setRightDistance(this.resolveDistance(string2));
        }
        return bufferAnalystParameter;
    }

    private Object resolveDistance(String leftDistance) {
        try {
            return Double.valueOf(leftDistance);
        }
        catch (NumberFormatException numberFormatException) {
            return leftDistance;
        }
    }
}

