/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.BufferEndType;
import com.supermap.analyst.spatialanalyst.BufferRadiusUnit;
import com.supermap.analyst.spatialanalyst.InternalResource;

public class BufferAnalystParameter {
    public static final String FIELD_BUFFER_END_TYPE = "bufferEndType";
    public static final String FIELD_SEMICIRCLE_LINE_SEGMENT = "semicircleLineSegment";
    public static final String FIELD_LEFT_DISTANCE = "leftDistance";
    public static final String FIELD_RIGHT_DISTANCE = "rightDistance";
    public static final String FIELD_BUFFER_RADIUS_UNIT = "bufferRadiusUnit";
    private BufferEndType m_bufferEndType;
    private int m_semicircleLineSegment;
    private Object m_leftDistance;
    private Object m_rightDistance;
    private BufferRadiusUnit m_bufferRadiusUnit;

    public BufferAnalystParameter() {
        this.m_bufferEndType = BufferEndType.ROUND;
        this.m_semicircleLineSegment = 12;
        this.m_leftDistance = null;
        this.m_rightDistance = null;
        this.m_bufferRadiusUnit = BufferRadiusUnit.Meter;
    }

    public BufferAnalystParameter(BufferAnalystParameter bufferAnalystParameter) {
        this.m_bufferEndType = bufferAnalystParameter.getEndType();
        this.m_semicircleLineSegment = bufferAnalystParameter.getSemicircleLineSegment();
        this.m_leftDistance = bufferAnalystParameter.getLeftDistance();
        this.m_rightDistance = bufferAnalystParameter.getRightDistance();
        this.m_bufferRadiusUnit = bufferAnalystParameter.getRadiusUnit();
    }

    public BufferEndType getEndType() {
        return this.m_bufferEndType;
    }

    public void setEndType(BufferEndType bufferEndType) {
        if (bufferEndType == null) {
            String string = InternalResource.loadString(FIELD_BUFFER_END_TYPE, "Global_ArgumentNull", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_bufferEndType = bufferEndType;
    }

    public BufferRadiusUnit getRadiusUnit() {
        return this.m_bufferRadiusUnit;
    }

    public void setRadiusUnit(BufferRadiusUnit bufferRadiusUnit) {
        if (bufferRadiusUnit == null) {
            String string = InternalResource.loadString(FIELD_BUFFER_RADIUS_UNIT, "Global_ArgumentNull", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_bufferRadiusUnit = bufferRadiusUnit;
    }

    public int getSemicircleLineSegment() {
        return this.m_semicircleLineSegment;
    }

    public void setSemicircleLineSegment(int value) {
        if (value < 4 || value > 200) {
            String string = InternalResource.loadString(FIELD_LEFT_DISTANCE, "BufferAnalyst_SemicircleLineSegmentShouldEqualsOrGreaterThanFour", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_semicircleLineSegment = value;
    }

    public Object getLeftDistance() {
        return this.m_leftDistance;
    }

    public void setLeftDistance(Object leftDistance) {
        if (leftDistance == null) {
            this.m_leftDistance = null;
            return;
        }
        if (!this.isValidObject(leftDistance)) {
            String string = InternalResource.loadString(FIELD_LEFT_DISTANCE, "BufferAnalystParameter_InvalidObject", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_leftDistance = leftDistance;
    }

    public Object getRightDistance() {
        return this.m_rightDistance;
    }

    public void setRightDistance(Object rightDistance) {
        if (rightDistance == null) {
            this.m_rightDistance = null;
            return;
        }
        if (!this.isValidObject(rightDistance)) {
            String string = InternalResource.loadString(FIELD_RIGHT_DISTANCE, "BufferAnalystParameter_InvalidObject", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_rightDistance = rightDistance;
    }

    private boolean isValidObject(Object obj) {
        boolean bl = false;
        if (obj instanceof String || obj instanceof Double) {
            bl = true;
        } else {
            try {
                Double.parseDouble(obj.toString());
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }
}

