/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import com.supermap.License;
import com.supermap.LicenseConnectMode;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseService;
import com.supermap.ProductType;
import com.supermap.Tools;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LicenseFileServiceImpl
implements LicenseService {
    private static String VERSION = "700";
    static int SuperMap_License_Error_Code_Base = 5000;
    static int SuperMap_License_Error_LaterExpiredDate = SuperMap_License_Error_Code_Base + 1;
    static int SuperMap_License_Error_EarlyStartDate = SuperMap_License_Error_Code_Base + 2;
    static int SuperMap_License_Error_WrongLicenseData = SuperMap_License_Error_Code_Base + 3;
    static int SuperMap_License_Error_WrongProductVersion = SuperMap_License_Error_Code_Base + 4;
    static int SuperMap_License_Error_EncryptFailed = SuperMap_License_Error_Code_Base + 5;
    static int SuperMap_License_Error_ComputerNameError = SuperMap_License_Error_Code_Base + 6;
    static int SuperMap_License_Error_FeatrueNotFound = SuperMap_License_Error_Code_Base + 7;
    static int SuperMap_License_Error_SpecifyMACNotFound = SuperMap_License_Error_Code_Base + 8;
    static int SuperMap_License_Error_WrongFeatureInLicData = SuperMap_License_Error_Code_Base + 9;
    static int SuperMap_License_Error_IdentifyCodeNotFound = SuperMap_License_Error_Code_Base + 10;
    static int SuperMap_License_Error_LostLicenseFile = SuperMap_License_Error_Code_Base + 11;
    static int SuperMap_License_Error_MemModeLicenseError = SuperMap_License_Error_Code_Base + 12;
    private static String g_currentUsedLicFile;
    private static String g_inputLicFilePath;
    private static List<String> g_MACList;
    private static List<Long> g_MACNumList;
    private static String g_specifyLicenseXML;
    private static boolean g_useMemory;
    private LicenseFeatureInfo m_featureInfo = null;
    private String m_user = "";
    private String m_company = "";
    private boolean m_isCloudLicense = false;
    static String PROGRAM_PATH;
    static String OPT_PATH;

    public static boolean findAndReadLicFile() {
        File file;
        g_useMemory = false;
        if (License.g_debug) {
            System.out.println("g_specifyLicenseXML=" + g_specifyLicenseXML);
        }
        if (g_specifyLicenseXML != null && !g_specifyLicenseXML.isEmpty()) {
            g_useMemory = true;
            return true;
        }
        if (License.g_debug) {
            System.out.println("g_inputLicFilePath=" + g_inputLicFilePath);
        }
        if (g_inputLicFilePath != null && !g_inputLicFilePath.isEmpty() && (file = new File(g_inputLicFilePath)).exists() && file.isFile()) {
            g_currentUsedLicFile = g_inputLicFilePath;
            return true;
        }
        ArrayList<String> findPathes = new ArrayList<String>();
        findPathes.add(g_inputLicFilePath);
        findPathes.add(License.getUGOBasePath());
        findPathes.add(PROGRAM_PATH);
        findPathes.add(OPT_PATH);
        String javaHomePath = System.getProperty("java.home");
        findPathes.add(javaHomePath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".LIC9D");
            }
        };
        File dir = null;
        for (String string : findPathes) {
            File[] files;
            if (string == null || string.isEmpty() || !(dir = new File(string)).exists() || (files = dir.listFiles(filter)).length <= 0) continue;
            g_currentUsedLicFile = files[0].getAbsolutePath();
            break;
        }
        if (License.g_debug) {
            System.out.println("g_currentUsedLicFile=" + g_currentUsedLicFile);
        }
        return g_currentUsedLicFile != null && !g_currentUsedLicFile.isEmpty();
    }

    @Override
    public void dispose() {
    }

    @Override
    public int connect(ProductType product) {
        return this.connect(product.getUGCValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int connect(int featureID) {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return SuperMap_License_Error_WrongLicenseData;
        }
        ByteArrayInputStream inputStream = null;
        if (g_useMemory) {
            try {
                inputStream = new ByteArrayInputStream(g_specifyLicenseXML.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                return SuperMap_License_Error_WrongLicenseData;
            }
        }
        try {
            String cLine;
            File licFile = new File(g_currentUsedLicFile);
            if (!licFile.exists()) {
                return SuperMap_License_Error_LostLicenseFile;
            }
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(licFile), "UTF-8"));
            while ((cLine = br.readLine()) != null) {
                sb.append(cLine).append("\n");
            }
            inputStream = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return SuperMap_License_Error_WrongLicenseData;
        }
        catch (Throwable e) {
            return SuperMap_License_Error_WrongLicenseData;
        }
        try {
            doc = builder.parse(inputStream);
        }
        catch (SAXException e) {
            e.printStackTrace();
            int sb = SuperMap_License_Error_WrongLicenseData;
            return sb;
        }
        catch (IOException e) {
            e.printStackTrace();
            int sb = SuperMap_License_Error_WrongLicenseData;
            return sb;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        this.m_featureInfo = new LicenseFeatureInfo();
        this.m_featureInfo.m_id = featureID;
        Element tempNode = null;
        String temp = "";
        Element root = doc.getDocumentElement();
        String strFeatureID = new Integer(featureID).toString();
        NodeList featureNodes = root.getElementsByTagName("feature");
        Element featureNode = null;
        boolean isConnected = false;
        for (int i = 0; i < featureNodes.getLength(); ++i) {
            featureNode = (Element)featureNodes.item(i);
            tempNode = License.getFirstElementByName(featureNode, "id");
            temp = tempNode.getFirstChild().getNodeValue();
            if (!temp.equals(strFeatureID)) continue;
            isConnected = true;
            break;
        }
        this.m_isCloudLicense = false;
        if (isConnected) {
            tempNode = License.getFirstElementByName(root, "signature");
            String signature = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(featureNode, "licdata");
            temp = tempNode.getFirstChild().getNodeValue();
            byte[] decryptData = DatatypeConverter.parseBase64Binary((String)temp);
            String decryptString = new String(LicenseFileServiceImpl.decrypt(decryptData));
            int code = LicenseFileServiceImpl.verifyLicense(decryptString, this.m_featureInfo, signature, g_useMemory);
            if (code != 0 && code != SuperMap_License_Error_LaterExpiredDate && code != SuperMap_License_Error_EarlyStartDate) {
                this.m_featureInfo = null;
                return code;
            }
            this.m_featureInfo.m_licData = temp;
            tempNode = License.getFirstElementByName(featureNode, "name");
            this.m_featureInfo.m_name = temp = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(root, "user");
            this.m_user = temp = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(root, "company");
            this.m_company = temp = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(featureNode, "maxlogins");
            if (tempNode != null) {
                temp = tempNode.getFirstChild().getNodeValue();
                this.m_featureInfo.m_maxlogins = Integer.parseInt(temp);
            }
            if ((tempNode = License.getFirstElementByName(root, "access")) != null) {
                temp = tempNode.getFirstChild().getNodeValue();
                this.m_isCloudLicense = temp.equals("cloud");
            }
            this.m_featureInfo.m_keyType = "File License";
            if (featureID >= 65400 && featureID < 65420) {
                this.m_featureInfo.m_isTrial = true;
            }
            if (featureID < 10000) {
                this.m_featureInfo.m_version = "700";
            } else if (featureID > 9999 && featureID < 19999) {
                this.m_featureInfo.m_version = "900";
            }
            if (License.g_debug) {
                System.out.println("Trial:" + this.m_featureInfo.isTrial());
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String message = dateformat.format(this.m_featureInfo.getStartTime()) + " ~ " + dateformat.format(this.m_featureInfo.getExpiredTime());
                System.out.println("Time:" + message);
            }
            return code;
        }
        return SuperMap_License_Error_FeatrueNotFound;
    }

    @Override
    public int verify() {
        if (this.m_featureInfo != null) {
            return this.connect((int)this.m_featureInfo.getID());
        }
        return SuperMap_License_Error_WrongLicenseData;
    }

    @Override
    public void disconnect() {
        this.m_featureInfo = null;
    }

    @Override
    public String getUser() {
        return this.m_user;
    }

    @Override
    public String getCompany() {
        return this.m_company;
    }

    @Override
    public Boolean isCloudLicense() {
        return this.m_isCloudLicense;
    }

    public static String getSpecifyLicenseFilePath() {
        return g_inputLicFilePath;
    }

    public static void setSpecifyLicenseFilePath(String value) {
        g_inputLicFilePath = value;
        LicenseFileServiceImpl.findAndReadLicFile();
    }

    public static String getSpecifyLicenseXML() {
        return g_specifyLicenseXML;
    }

    public static void setSpecifyLicenseXML(String value) {
        g_specifyLicenseXML = value;
        LicenseFileServiceImpl.findAndReadLicFile();
    }

    public List<Integer> getAllFeatureID() {
        ArrayList<Integer> featureList = new ArrayList<Integer>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(g_currentUsedLicFile));
            doc = builder.parse(inputStream);
        }
        catch (SAXException e) {
            e.printStackTrace();
            try {
                inputStream.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element tempNode = null;
        String temp = "";
        Element root = doc.getDocumentElement();
        NodeList featureNodes = root.getElementsByTagName("feature");
        Element featureNode = null;
        for (int i = 0; i < featureNodes.getLength(); ++i) {
            featureNode = (Element)featureNodes.item(i);
            tempNode = License.getFirstElementByName(featureNode, "id");
            temp = tempNode.getFirstChild().getNodeValue();
            featureList.add(Integer.parseInt(temp));
        }
        return featureList;
    }

    @Override
    public LicenseFeatureInfo getFeatureInfo() {
        return this.m_featureInfo;
    }

    @Override
    public String getC2V() {
        return "";
    }

    @Override
    public String getErrorMessage(int code) {
        String errorMessage = "";
        switch (code) {
            case 0: {
                errorMessage = "";
                break;
            }
            case 4000: {
                errorMessage = "SuperMap_License_Error_Cannot_Find_LicenseInstance";
                break;
            }
            case 4001: {
                errorMessage = "SuperMap_License_Error_Hasp_Load_Library_Error";
                break;
            }
            case 5000: {
                errorMessage = "SuperMap_licensefile_7C_unknown_error";
                break;
            }
            case 5001: {
                errorMessage = "SuperMap_licensefile_7C_later_than_ExpiredDate";
                break;
            }
            case 5002: {
                errorMessage = "SuperMap_License_Error_early_than_StartDate";
                break;
            }
            case 5003: {
                errorMessage = "SuperMap_licensefile_7C_wrong_license_data";
                break;
            }
            case 5004: {
                errorMessage = "SuperMap_licensefile_7C_wrong_product_version";
                break;
            }
            case 5005: {
                errorMessage = "SuperMap_licensefile_7C_encrypt_failed";
                break;
            }
            case 5006: {
                errorMessage = "SuperMap_licensefile_7C_computer_name_error";
                break;
            }
            case 5007: {
                errorMessage = "SuperMap_licensefile_7C_featrue_not_found";
                break;
            }
            case 5008: {
                errorMessage = "SuperMap_licensefile_7C_specify_MAC_not_found";
                break;
            }
            case 5009: {
                errorMessage = "SuperMap_licensefile_7C_wrong_feature_in_license_data";
                break;
            }
            case 5010: {
                errorMessage = "SuperMap_licensefile_7C_lost_license_file";
                break;
            }
            default: {
                errorMessage = "unknown error code: " + code;
            }
        }
        return errorMessage;
    }

    @Override
    public String getImplName() {
        return "FILE";
    }

    private static byte[] decrypt(byte[] encrypted) {
        BigInteger modulus = new BigInteger("97940149900808251375534752128742394515589720894419487281414832262018030644275525014643445585879780364114176383835238013142689819073723152973127922693584355350878117626063464407872142659013727087204174268107953820379456111862924759697130141776327730513730393977765958470441797160670328283419007898268490444631");
        BigInteger exponent = new BigInteger("65537");
        BigInteger encryptedInt = new BigInteger(encrypted);
        BigInteger resultInt = encryptedInt.modPow(exponent, modulus);
        return resultInt.toByteArray();
    }

    private static int verifyLicense(String encryptData, LicenseFeatureInfo featureInfo, String signature, boolean useMemory) {
        String[] subStrings = encryptData.split("\\|");
        if (subStrings.length != 7) {
            return SuperMap_License_Error_EncryptFailed;
        }
        String featureID = subStrings[0];
        String version = subStrings[1];
        String licMode = subStrings[2];
        String identifyCode = subStrings[3];
        String startDate = subStrings[4];
        String endDate = subStrings[5];
        String maxLogins = subStrings[6];
        if (!version.equals(VERSION)) {
            return SuperMap_License_Error_WrongProductVersion;
        }
        String strFeatureID = new Integer((int)featureInfo.getID()).toString();
        if (!featureID.equals(strFeatureID)) {
            return SuperMap_License_Error_WrongFeatureInLicData;
        }
        int code = LicenseFileServiceImpl.verifyLicenseDate(startDate, true, featureInfo);
        if (code != 0) {
            return code;
        }
        code = LicenseFileServiceImpl.verifyLicenseDate(endDate, false, featureInfo);
        if (code != 0) {
            return code;
        }
        featureInfo.m_maxlogins = Integer.parseInt(maxLogins);
        featureInfo.m_connectmode = licMode;
        if (License.g_debug) {
            System.out.println("licMode:  " + licMode);
            System.out.println("identifyCode:  " + identifyCode);
        }
        int licModeCode = Integer.parseInt(licMode);
        switch (licModeCode) {
            case 4: {
                if (identifyCode.toUpperCase().equals(LicenseFileServiceImpl.getComputerName().toUpperCase())) break;
                return SuperMap_License_Error_ComputerNameError;
            }
            case 3: {
                if (LicenseFileServiceImpl.verifyMACAddress(identifyCode)) break;
                return SuperMap_License_Error_SpecifyMACNotFound;
            }
            case 2: {
                if (!identifyCode.toUpperCase().equals(signature.toUpperCase())) {
                    return SuperMap_License_Error_WrongLicenseData;
                }
                featureInfo.m_isTrial = true;
                break;
            }
            case 5: {
                if (identifyCode.toUpperCase().equals(signature.toUpperCase())) break;
                return SuperMap_License_Error_WrongLicenseData;
            }
            case 6: {
                if (LicenseFileServiceImpl.verifyConfusionMACAddress(identifyCode)) break;
                return SuperMap_License_Error_IdentifyCodeNotFound;
            }
            case 7: {
                if (useMemory && identifyCode.toUpperCase().equals(signature.toUpperCase())) break;
                return SuperMap_License_Error_MemModeLicenseError;
            }
        }
        return 0;
    }

    private static String getComputerName() {
        String computerName = "";
        try {
            computerName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (License.g_debug) {
            System.out.println("getComputerName:  " + computerName);
        }
        return computerName;
    }

    private static int verifyLicenseDate(String strDate, boolean isStartDate, LicenseFeatureInfo featureInfo) {
        Date today = new Date();
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6));
        Calendar cl = Calendar.getInstance();
        if (isStartDate) {
            cl.set(year, month, day, 0, 0, 0);
        } else {
            cl.set(year, month, day, 23, 59, 59);
        }
        Date date = cl.getTime();
        if (isStartDate) {
            featureInfo.m_startTime = date;
            if (today.before(date)) {
                return SuperMap_License_Error_EarlyStartDate;
            }
        } else {
            featureInfo.m_expiredTime = date;
            if (today.after(date)) {
                return SuperMap_License_Error_LaterExpiredDate;
            }
        }
        return 0;
    }

    private static boolean verifyMACAddress(String macAddress) {
        if (g_MACList == null) {
            LicenseFileServiceImpl.getAllMac();
        }
        for (String mac : g_MACList) {
            if (!mac.equals(macAddress)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyConfusionMACAddress(String signature) {
        if (g_MACNumList == null) {
            LicenseFileServiceImpl.getAllMac();
        }
        Long signNum = Long.parseLong(signature, 16);
        for (Long mac : g_MACNumList) {
            if (!signNum.equals(mac)) continue;
            return true;
        }
        return false;
    }

    public static void getAllMac() {
        g_MACList = new ArrayList<String>();
        g_MACNumList = new ArrayList<Long>();
        String conSym = "";
        conSym = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "-" : ":";
        if (License.g_debug) {
            System.out.println("os.name: " + System.getProperty("os.name"));
            System.out.println("conSym is " + conSym);
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface network = e.nextElement();
                if (network == null || network.getHardwareAddress() == null || network.isPointToPoint()) continue;
                byte[] addres = network.getHardwareAddress();
                StringBuffer sb = new StringBuffer();
                if (addres == null || addres.length <= 1) continue;
                sb.append(LicenseFileServiceImpl.hexByte(addres[0]));
                sb.append(conSym);
                sb.append(LicenseFileServiceImpl.hexByte(addres[1]));
                sb.append(conSym);
                sb.append(LicenseFileServiceImpl.hexByte(addres[2]));
                sb.append(conSym);
                sb.append(LicenseFileServiceImpl.hexByte(addres[3]));
                sb.append(conSym);
                sb.append(LicenseFileServiceImpl.hexByte(addres[4]));
                sb.append(conSym);
                sb.append(LicenseFileServiceImpl.hexByte(addres[5]));
                if (License.g_debug) {
                    System.out.println("getAllMac:  " + sb.toString().toUpperCase());
                }
                g_MACList.add(sb.toString().toUpperCase());
                Long num1 = Math.round((double)(0xFF & addres[0]) * Math.pow(2.0, 40.0));
                Long num2 = Math.round((double)(0xFF & addres[1]) * Math.pow(2.0, 32.0));
                Long num3 = Math.round((double)(0xFF & addres[2]) * Math.pow(2.0, 24.0));
                Long num4 = Math.round((double)(0xFF & addres[3]) * Math.pow(2.0, 16.0));
                Long num5 = Math.round((double)(0xFF & addres[4]) * Math.pow(2.0, 8.0));
                int num6 = 0xFF & addres[5];
                Long macNum = num1 + num2 + num3 + num4 + num5 + (long)num6;
                Long confusionNum = 281401388481450L;
                g_MACNumList.add(macNum + confusionNum);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getMacList() {
        if (g_MACList == null) {
            LicenseFileServiceImpl.getAllMac();
        }
        return g_MACList;
    }

    public static List<Long> getMACNumList() {
        if (g_MACList == null) {
            LicenseFileServiceImpl.getAllMac();
        }
        return g_MACNumList;
    }

    private static String hexByte(byte b) {
        String s = "000000" + Integer.toHexString(b);
        return s.substring(s.length() - 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SaveLicFile(String strlicfile) {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            String filename = "";
            fi = new FileInputStream(strlicfile);
            String newfile = "";
            File file = null;
            if (Tools.getOsName().indexOf("Windows") != -1) {
                filename = strlicfile.substring(strlicfile.lastIndexOf("\\"));
                newfile = License.PROGRAM_PATH + filename;
                file = new File(License.PROGRAM_PATH);
            } else {
                filename = strlicfile.substring(strlicfile.lastIndexOf("/"));
                newfile = License.OPT_PATH + filename;
                file = new File(License.OPT_PATH);
            }
            File afile = new File(newfile);
            if (afile.exists()) {
                String newfileback = newfile.replace("lic9d", "lic9d" + System.currentTimeMillis());
                File bakfile = new File(newfileback);
                afile.renameTo(bakfile);
            }
            Tools.makeDir(file);
            fo = new FileOutputStream(newfile);
            in = fi.getChannel();
            out = fo.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fi.close();
                in.close();
                fo.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getLicenseConnectServer() {
        return null;
    }

    @Override
    public void setLicenseConnectServer(String value) {
    }

    @Override
    public LicenseConnectMode getLicenseConnectMode() {
        return null;
    }

    @Override
    public void setLicenseConnectMode(LicenseConnectMode value) {
    }

    static {
        PROGRAM_PATH = "C:/Program Files/Common Files/SuperMap/License/";
        OPT_PATH = "/opt/SuperMap/License/";
    }
}

