/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import com.supermap.IRuner;
import com.supermap.License;
import com.supermap.LicenseFileServiceImpl;
import com.supermap.ProductType;
import com.supermap.Runner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

class ConsoleRuner {
    private static HashMap<String, IRuner> g_switchRuner;
    private static int Segment3Length;
    private static Runner g_HaspRunner;

    ConsoleRuner() {
    }

    public static void run(String task, String[] args) {
        IRuner runer = g_switchRuner.get(task);
        if (runer == null) {
            runer = g_switchRuner.get("-help");
        }
        runer.Run(args);
    }

    private static void showHelp(String[] args) {
        if (args.length > 0 && args[0].length() > 0) {
            System.out.println(String.format("the command does not support %s. ", args[0]));
            System.out.println("see also:");
        }
        System.out.println(ConsoleRuner.loadString("cmdtip"));
        System.out.println("-status(-s) \t\t\t Check current license status");
        System.out.println("-update(-u) updatefile \t\t Update/Attach License ");
        System.out.println("-report \t\t\t Create Report file to product license ");
        System.out.println("-create(-c) newc2vfile \t\t " + ConsoleRuner.loadString("createc2v"));
        System.out.println("-updatec2v newc2vfile \t\t Create UpdateC2V file to product license");
        System.out.println("-id idfile \t\t\t Create ID file to product license");
        System.out.println("-infofile infofile \t\t Create product license infofile");
        System.out.println("-canceldetach(-cd) KeyID canceldetachfile  \t\t Create r2h file to product license");
        System.out.println("-detach  daycount productid idfile h2rfile \t\t Create h2r file to product license");
        System.out.println("-debug featureID \t\t debug connect feature");
        System.out.println("-specifydebug specifyfile \t verify feature");
        System.out.println("-cardid \t\t\t get cardid");
        System.out.println("-debugall \t\t\t debug all features");
        System.out.println("-help(-?) \t\t\t " + ConsoleRuner.loadString("help"));
    }

    private static void detach(String[] args) {
        if (g_HaspRunner != null) {
            if (args.length == 5) {
                int dayCount = Integer.valueOf(args[1]);
                int duration = dayCount * 24 * 60 * 60;
                String productID = args[2];
                String recipient = ConsoleRuner.readfile(args[3]);
                String path = args[4];
                String[] result = g_HaspRunner.detach(duration, productID, recipient);
                if (!result[0].equals("0")) {
                    System.out.println("Export h2r file Failed! Error code:" + License.getErrorMessage(Integer.parseInt(result[0])));
                } else {
                    ConsoleRuner.writefile(path, result[1]);
                    System.out.println("Create h2r file successful! You can find it here: " + path);
                }
            } else {
                System.out.println("args.length=" + args.length + ",Create h2r file need dayCount\u3001ProductID\u3001idfile and h2rfile ! ");
            }
        }
    }

    private static void update(String[] args, boolean isDebug) {
        if (args.length > 1) {
            String path = args[1];
            if (path.toUpperCase().endsWith(".LIC9D")) {
                LicenseFileServiceImpl.SaveLicFile(path);
                System.out.println("Update LIC9D file successful!");
            } else if (g_HaspRunner != null) {
                String info = ConsoleRuner.readfile(args[1]);
                String[] result = g_HaspRunner.update(info);
                if (!result[0].equals("0")) {
                    System.out.println("Update Failed! Error code:" + License.getErrorMessage(Integer.parseInt(result[0])));
                } else {
                    System.out.println("Update Hasp file successful!");
                }
            } else {
                System.out.println("Update Hasp file fail!");
            }
        } else {
            System.out.println("Update need v2c\u3001h2r\u3001lic9d or lic file!");
        }
    }

    private static void productStatus(boolean isDebug) {
        if (g_HaspRunner != null) {
            g_HaspRunner.productStatus(isDebug);
        }
    }

    private static void licenseStatus(boolean isDebug) {
        if (g_HaspRunner != null) {
            g_HaspRunner.licenseStatus(isDebug);
        }
    }

    private static void creater2hfile(String[] args) {
        if (args.length == 3) {
            if (g_HaspRunner != null) {
                String[] result = g_HaspRunner.getR2H(args[1]);
                String path = args[1];
                if (!result[0].equals("0")) {
                    System.out.println("Export r2h file Failed! Error code:" + License.getErrorMessage(Integer.parseInt(result[0])));
                } else {
                    ConsoleRuner.writefile(path, result[1]);
                    System.out.println("Create r2h file successful! You can find it here: " + path);
                }
            }
        } else {
            System.out.println("Create r2h file need new file path and KeyID!");
        }
    }

    private static void createIDfile(String[] args) {
        if (g_HaspRunner != null) {
            if (args.length > 1) {
                String[] result = g_HaspRunner.getID();
                String path = args[1];
                if (!result[0].equals("0")) {
                    System.out.println("Export id file Failed! Error code:" + License.getErrorMessage(Integer.parseInt(result[0])));
                } else if (result[1].indexOf("SL-AdminMode") < 0) {
                    System.out.println("hasp service error,please restart hasp service!");
                } else {
                    ConsoleRuner.writefile(path, result[1]);
                    System.out.println("Create ID file successful! You can find it here: " + path);
                }
            } else {
                System.out.println("Create ID file need new file path!");
            }
        }
    }

    private static void createinfofile(String[] args) {
        if (g_HaspRunner != null) {
            g_HaspRunner.createinfofile(args);
        }
    }

    private static void updateC2VFile(String[] args, boolean isDebug) {
        if (g_HaspRunner != null) {
            g_HaspRunner.updateC2VFile(args, isDebug);
        }
    }

    private static void createC2VFile(String[] args, boolean isDebug) {
        if (args.length > 1) {
            if (g_HaspRunner != null) {
                String[] result = g_HaspRunner.getC2V();
                String path = args[1];
                if (!result[0].equals("0")) {
                    System.out.println("Export c2v file Failed! Error code:" + License.getErrorMessage(Integer.parseInt(result[0])));
                } else {
                    ConsoleRuner.writefile(path, result[1]);
                    System.out.println(ConsoleRuner.loadString("createc2vok") + path);
                }
            }
        } else {
            System.out.println(ConsoleRuner.loadString("createc2vfail"));
        }
    }

    private static String loadString(String key) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("license_resources");
            return bundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    private static void debug(String[] args) {
        if (args.length > 1) {
            String feature = args[1];
            int featureID = Integer.parseInt(feature);
            License.g_debug = true;
            License license = new License();
            int code = license.connect(featureID);
            System.out.println("Connect featureID: " + feature);
            System.out.println(code);
            System.out.println();
        }
    }

    private static void debugLic(String[] args) {
        if (args.length > 1) {
            String feature = args[1];
            int featureID = Integer.parseInt(feature);
            License.g_debug = true;
            License license = new License();
            int code = license.connectLic(featureID);
            System.out.println("Connect featureID: " + feature);
            System.out.println(code);
            System.out.println();
        }
    }

    private static void specifyDebug(String[] args) {
        if (args.length > 1) {
            String filePath = args[1];
            License.setSpecifyLicenseFilePath(filePath);
            License.g_debug = true;
            License license = new License();
            List<Integer> featureList = license.getAllFeatureID();
            for (int i = 0; i < featureList.size(); ++i) {
                if (i > 0) {
                    License.g_debug = false;
                }
                int result = license.connect(featureList.get(i));
                String product = ProductType.getNameByValue(ProductType.class, featureList.get(i));
                System.out.println("Connect featureName: " + product + " result is " + result);
            }
        } else {
            System.out.println("args.length=" + args.length + ", Verify feature need specifyfile!");
        }
    }

    private static void reportTrailInfo(String[] args, boolean isDebug) {
        block16: {
            String hostName;
            File file;
            block14: {
                file = null;
                hostName = "";
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    if (!isDebug) break block14;
                    e.printStackTrace();
                }
            }
            if (args.length == 2) {
                file = new File(args[1]);
                if (file.isDirectory()) {
                    file = new File(args[1] + "/" + hostName + ".report");
                }
            } else {
                file = new File(hostName + ".report");
            }
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                String context = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<admin_response>\r\n<license_manager>\r\n<version>15.0.1.36539</version>\r\n<servername>";
                outputStreamWriter.write(context);
                outputStreamWriter.write(hostName);
                context = "</servername>\r\n<vmtext></vmtext>\r\n<has_ipv4>1</has_ipv4>\r\n<has_ipv6>1</has_ipv6>\r\n<serverruntime>0 days 0 hours 0 minutes</serverruntime>\r\n<uptime>45351</uptime>\r\n<templatedirs>csv</templatedirs>\r\n<templatedirs>en</templatedirs>\r\n<templatedirs>sample</templatedirs>\r\n<logincount>0</logincount>\r\n<loginpeak>10</loginpeak>\r\n<sessioncount>0</sessioncount>\r\n<sessionpeak>0</sessionpeak>\r\n<loginrequestcount>779</loginrequestcount>\r\n<localrequestcount>2</localrequestcount>\r\n<remoterequestcount>11617</remoterequestcount>\r\n<requestcount>11619</requestcount>\r\n<readcount>23867458</readcount>\r\n<writecount>555305124</writecount>\r\n<keyerrors>0</keyerrors>\r\n<transporterrors>4</transporterrors>\r\n<clientthreads>1</clientthreads>\r\n<peakclientthreads>5</peakclientthreads>\r\n</license_manager>\r\n<admin_status>\r\n<code>0</code>\r\n<text>SNTL_ADMIN_STATUS_OK</text>\r\n</admin_status>\r\n<products>";
                outputStreamWriter.write(context);
                if (g_HaspRunner != null) {
                    outputStreamWriter.write(g_HaspRunner.reportTrailInfo(args, isDebug));
                }
                outputStreamWriter.write("</products>\r\n</admin_response>");
                outputStreamWriter.flush();
                outputStreamWriter.close();
                fileOutputStream.close();
                System.out.println("Create Report file successful! You can find it here: " + file.getAbsoluteFile());
            }
            catch (UnsatisfiedLinkError localUnsatisfiedLinkError) {
                block15: {
                    try {
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        String context = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<admin_response>\r\n<license_manager>\r\n<servername>";
                        outputStreamWriter.write(context);
                        outputStreamWriter.write(hostName);
                        outputStreamWriter.write("</servername>\r\n<license_manager>\r\n</admin_response>");
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                        fileOutputStream.close();
                        System.out.println("Create Report file successful. You can find it here: " + file.getAbsoluteFile());
                    }
                    catch (Exception e) {
                        if (!isDebug) break block15;
                        e.printStackTrace();
                    }
                }
                if (isDebug) {
                    localUnsatisfiedLinkError.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!isDebug) break block16;
                e.printStackTrace();
            }
        }
    }

    private static void debugAll(String[] args) {
        License.g_debug = true;
        int[] models = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010};
        for (int i = 0; i < models.length; ++i) {
            License license = new License();
            int result = license.connect(models[i]);
            license.dispose();
            System.out.println("Connect featureID: " + models[i] + " result is " + result);
        }
    }

    private static void cardid(String[] args) {
        List<String> maclist = License.getMacList();
        List<Long> macNumlist = License.getMACNumList();
        System.out.println(String.format("%s\t%s\t%s", ConsoleRuner.addSpaceToString("[ID]", 4), ConsoleRuner.addSpaceToString("[MAC]", 20), ConsoleRuner.addSpaceToString("[CardID]", Segment3Length)));
        for (int i = 0; i < maclist.size(); ++i) {
            System.out.println(String.format("%s\t%s\t%s", ConsoleRuner.addSpaceToString(String.valueOf(i), 4), ConsoleRuner.addSpaceToString(maclist.get(i), 20), ConsoleRuner.addSpaceToString(Long.toHexString(macNumlist.get(i)).toUpperCase(), Segment3Length)));
        }
    }

    private static String addSpaceToString(String value, int count) {
        while (value.getBytes().length <= count) {
            value = value + " ";
        }
        return value;
    }

    private static String readfile(String path) {
        String context = "";
        File file = new File(path);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String tempString = "";
        try {
            if (reader != null) {
                while ((tempString = reader.readLine()) != null) {
                    context = context + tempString;
                }
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return context;
    }

    private static void writefile(String path, String info) {
        try {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            RandomAccessFile f = new RandomAccessFile(path, "rw");
            f.write(info.getBytes());
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Segment3Length = 8;
        g_switchRuner = new HashMap();
        g_switchRuner.put("-update", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.update(args, false);
            }
        });
        g_switchRuner.put("-updatedebug", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.update(args, true);
            }
        });
        g_switchRuner.put("-u", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.update(args, false);
            }
        });
        g_switchRuner.put("-status", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.licenseStatus(false);
            }
        });
        g_switchRuner.put("-statusdebug", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.licenseStatus(true);
            }
        });
        g_switchRuner.put("-s", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.licenseStatus(false);
            }
        });
        g_switchRuner.put("-ps", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.productStatus(false);
            }
        });
        g_switchRuner.put("-create", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.createC2VFile(args, false);
            }
        });
        g_switchRuner.put("-updatec2v", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.updateC2VFile(args, false);
            }
        });
        g_switchRuner.put("-createdebug", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.createC2VFile(args, true);
            }
        });
        g_switchRuner.put("-c", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.createC2VFile(args, false);
            }
        });
        g_switchRuner.put("-help", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.showHelp(args);
            }
        });
        g_switchRuner.put("-?", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.showHelp(args);
            }
        });
        g_switchRuner.put("-debug", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.debug(args);
            }
        });
        g_switchRuner.put("-debuglic", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.debugLic(args);
            }
        });
        g_switchRuner.put("-specifydebug", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.specifyDebug(args);
            }
        });
        g_switchRuner.put("-report", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.reportTrailInfo(args, false);
            }
        });
        g_switchRuner.put("-reportdebug", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.reportTrailInfo(args, true);
            }
        });
        g_switchRuner.put("-r", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.reportTrailInfo(args, false);
            }
        });
        g_switchRuner.put("-debugall", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.debugAll(args);
            }
        });
        g_switchRuner.put("-id", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.createIDfile(args);
            }
        });
        g_switchRuner.put("-canceldetach", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.creater2hfile(args);
            }
        });
        g_switchRuner.put("-cd", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.creater2hfile(args);
            }
        });
        g_switchRuner.put("-infofile", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.createinfofile(args);
            }
        });
        g_switchRuner.put("-detach", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.detach(args);
            }
        });
        g_switchRuner.put("-cardid", new IRuner(){

            @Override
            public void Run(String[] args) {
                ConsoleRuner.cardid(args);
            }
        });
        ServiceLoader<Runner> serviceLoader = ServiceLoader.load(Runner.class);
        Iterator<Runner> it = serviceLoader.iterator();
        while (it != null && it.hasNext()) {
            String arch;
            Runner licenseInstance = it.next();
            String implName = licenseInstance.getImplName();
            if (!implName.equals("HASP") || !(arch = System.getProperty("os.arch")).equals("x86") && !arch.equals("x86_64") && !arch.equals("amd64")) continue;
            g_HaspRunner = licenseInstance;
        }
    }
}

