/*
 * Decompiled with CFR 0.152.
 */
package com.longcloud.platform.gateway.sign.util;

import java.util.Random;

public final class StringUtil {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || EMPTY.equals(str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String getFormatQueryParams(String fields) {
        if (fields == null || EMPTY.equals(fields.trim())) {
            return "''";
        }
        String sTemp = fields;
        if (sTemp.startsWith("'")) {
            sTemp = sTemp.substring(1);
        }
        if (sTemp.endsWith("'")) {
            sTemp = sTemp.substring(0, sTemp.length() - 1);
        }
        sTemp = sTemp.replaceAll("'{0,1},'{0,1}", ",");
        sTemp = sTemp.replaceAll("'", "''");
        sTemp = sTemp.replaceAll(",", "','");
        sTemp = "'" + sTemp + "'";
        return sTemp;
    }

    public static boolean isContainSpcifyStr(String str, String[] container) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        if (container == null) {
            return false;
        }
        for (int i = 0; i < container.length; ++i) {
            if (!str.equals(container[i])) continue;
            return true;
        }
        return false;
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtil.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtil.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String repeat(String str, String separator, int repeat) {
        if (str == null || separator == null) {
            return StringUtil.repeat(str, repeat);
        }
        String result = StringUtil.repeat(str + separator, repeat);
        return StringUtil.removeEnd(result, separator);
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String rightPad(String str, int size) {
        return StringUtil.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtil.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtil.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtil.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return StringUtil.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtil.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtil.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtil.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String strFormat(String srcStr, boolean isFillLeft, int count, String fillStr) {
        if (StringUtil.isEmpty(fillStr)) {
            return srcStr;
        }
        if (count <= 0) {
            return srcStr;
        }
        String sResult = EMPTY;
        String sTemp = StringUtil.buildFormatStr(count, fillStr);
        sResult = isFillLeft ? sTemp + srcStr : srcStr + sTemp;
        return sResult;
    }

    public static String fill(String srcStr, boolean isFillLeft, int length, String fillStr) {
        if (StringUtil.isEmpty(fillStr)) {
            return srcStr;
        }
        if (length <= 0) {
            return srcStr;
        }
        if (StringUtil.isEmpty(srcStr)) {
            return srcStr;
        }
        int iLen = length - srcStr.length();
        if (iLen <= 0) {
            return srcStr;
        }
        return StringUtil.strFormat(srcStr, isFillLeft, iLen, fillStr);
    }

    private static String buildFormatStr(int count, String fillStr) {
        if (count <= 0 || fillStr == null || EMPTY.equals(fillStr)) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(fillStr);
        }
        return sb.toString();
    }

    public static boolean isIn(String str, String[] scaleStr) {
        if (scaleStr == null) {
            return false;
        }
        if (str == null) {
            return false;
        }
        for (int i = 0; i < scaleStr.length; ++i) {
            if (!str.equals(scaleStr[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotIn(String str, String[] scaleStr) {
        return !StringUtil.isIn(str, scaleStr);
    }

    public static String getRandomStr(int pILen, String pStrBas) {
        Random rand = new Random();
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < pILen; ++i) {
            int iNumbr = rand.nextInt(pStrBas.length());
            sBuffer.append(pStrBas.charAt(iNumbr));
        }
        return sBuffer.toString();
    }
}

