/*
 * Decompiled with CFR 0.152.
 */
package com.longcloud.platform.gateway.sign.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class SimpleHttpSender {
    public static final String default_encoding = "utf-8";

    public static String request(String url, HttpMethod method, String params, Map<String, Object> headers, String encoding, int timeout) {
        try {
            byte[] paramTemp = params == null ? null : params.getBytes(encoding);
            byte[] b = SimpleHttpSender.request(url, method, paramTemp, headers, timeout);
            return new String(b, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Net exception:" + e.getMessage());
        }
    }

    public static byte[] request(String url, HttpMethod method, byte[] params, Map<String, Object> headers, int timeout) {
        byte[] byArray;
        OutputStream out = null;
        InputStream in = null;
        ByteArrayOutputStream bos = null;
        HttpURLConnection connection = null;
        try {
            int i;
            int code;
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            connection = (HttpURLConnection)uc;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod(method.name());
            connection.setConnectTimeout(timeout);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, Object> entry : headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
                }
            }
            if (HttpMethod.POST.name().equals(method.name())) {
                out = connection.getOutputStream();
                if (params != null && params.length > 0) {
                    out.write(params);
                }
                out.flush();
            }
            in = (code = connection.getResponseCode()) >= 400 ? connection.getErrorStream() : connection.getInputStream();
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((i = in.read(b)) != -1) {
                bos.write(b, 0, i);
            }
            byArray = bos.toByteArray();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException("Net exception:" + e.getMessage());
            }
            catch (Throwable throwable) {
                SimpleHttpSender.closeOutputStream(out);
                SimpleHttpSender.closeOutputStream(bos);
                SimpleHttpSender.closeInputStream(in);
                throw throwable;
            }
        }
        SimpleHttpSender.closeOutputStream(out);
        SimpleHttpSender.closeOutputStream(bos);
        SimpleHttpSender.closeInputStream(in);
        return byArray;
    }

    public static void closeReader(Reader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        System.setProperty("http.maxConnections", "100");
    }

    public class ContentType {
        public static final String application_x_www_form_urlencoded = "application/x-www-form-urlencoded";
        public static final String application_json = "application/json";
        public static final String application_xml = "application/xml ";
        public static final String text_plain = "text/plain";
        public static final String application_octet_stream = "application/octet-stream";
    }

    public static enum HttpMethod {
        POST,
        GET;

    }
}

