/*
 * Decompiled with CFR 0.152.
 */
package com.longcloud.platform.gateway.sign;

import com.alibaba.fastjson.JSON;
import com.longcloud.platform.gateway.sign.SignatureHelper;
import com.longcloud.platform.gateway.sign.http.SimpleHttpSender;
import com.longcloud.platform.gateway.sign.util.RtnData;
import com.longcloud.platform.gateway.sign.util.StringUtil;
import com.longcloud.platform.gateway.sign.util.TripleDESUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleApiCallUtil {
    private static Logger logger = LoggerFactory.getLogger(SimpleApiCallUtil.class);
    private static final int default_timeout = 2000;

    public static byte[] get(String url, String appKey, String secretKey, int timeout, Map<String, Object> headers) {
        logger.info(String.format("Invoke api %s", url));
        if (timeout <= 0) {
            timeout = 2000;
        }
        Map<String, Object> signHeaders = SignatureHelper.buildSignHeader(appKey, secretKey);
        if (headers != null && headers.size() > 0) {
            signHeaders.putAll(headers);
        }
        byte[] response = SimpleHttpSender.request(url, SimpleHttpSender.HttpMethod.GET, null, signHeaders, timeout);
        return response;
    }

    public static String get(String url, String appKey, String secretKey, String encoding, int timeout, Map<String, Object> headers) {
        try {
            if (StringUtil.isEmpty(encoding)) {
                encoding = "utf-8";
            }
            byte[] b = SimpleApiCallUtil.get(url, appKey, secretKey, timeout, headers);
            return new String(b, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] post(String url, String appKey, String secretKey, byte[] params, String encoding, int timeout, Map<String, Object> headers) throws Exception {
        logger.info(String.format("Invoke api %s", url));
        if (StringUtil.isEmpty(encoding)) {
            encoding = "utf-8";
        }
        if (timeout <= 0) {
            timeout = 2000;
        }
        Map<String, Object> signHeaders = SignatureHelper.buildSignHeader(appKey, secretKey);
        if (headers != null && headers.size() > 0) {
            signHeaders.putAll(headers);
        }
        byte[] response = SimpleHttpSender.request(url, SimpleHttpSender.HttpMethod.POST, params, signHeaders, timeout);
        return response;
    }

    public static String postForm(String url, String appKey, String secretKey, Map<String, Object> params, String encoding, int timeout, Map<String, Object> headers) {
        HashMap<String, Object> dataHeader = new HashMap<String, Object>();
        dataHeader.put("Content-Type", "application/x-www-form-urlencoded");
        SimpleApiCallUtil.copyHeader(headers, dataHeader);
        if (StringUtil.isEmpty(encoding)) {
            encoding = "utf-8";
        }
        try {
            String paramsResult = SimpleApiCallUtil.toFromParam(params);
            byte[] bResult = null;
            if (StringUtil.isNotEmpty(paramsResult)) {
                bResult = paramsResult.getBytes(encoding);
            }
            byte[] b = SimpleApiCallUtil.post(url, appKey, secretKey, bResult, encoding, timeout, dataHeader);
            return new String(b, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String postJson(String url, String appKey, String secretKey, String params, String encoding, int timeout, Map<String, Object> headers) {
        HashMap<String, Object> dataHeader = new HashMap<String, Object>();
        dataHeader.put("Content-Type", "application/json");
        SimpleApiCallUtil.copyHeader(headers, dataHeader);
        if (StringUtil.isEmpty(encoding)) {
            encoding = "utf-8";
        }
        try {
            byte[] bResult = null;
            if (StringUtil.isNotEmpty(params)) {
                bResult = params.getBytes(encoding);
            }
            byte[] b = SimpleApiCallUtil.post(url, appKey, secretKey, bResult, encoding, timeout, dataHeader);
            return new String(b, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private static Map<String, Object> copyHeader(Map<String, Object> src, Map<String, Object> dest) {
        if (SimpleApiCallUtil.isEmptyOfMap(src)) {
            return dest;
        }
        if (SimpleApiCallUtil.isEmptyOfMap(dest)) {
            return src;
        }
        dest.putAll(src);
        return dest;
    }

    private static boolean isEmptyOfMap(Map<String, Object> map) {
        return map == null || map.size() == 0;
    }

    private static String toFromParam(Map<String, Object> params) {
        if (SimpleApiCallUtil.isEmptyOfMap(params)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(), "utf-8")).append("&");
            }
            String result = sb.toString();
            if (StringUtil.isEmpty(result)) {
                return null;
            }
            return result.substring(0, result.length() - 1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String decryptResult(String secretkey, String response) {
        if (StringUtil.isEmpty(response)) {
            return response;
        }
        RtnData rtnData = (RtnData)JSON.parseObject((String)response, RtnData.class);
        return TripleDESUtil.decrypt3DES(secretkey, rtnData.getResult().toString());
    }
}

