/*
 * Decompiled with CFR 0.152.
 */
package com.longcloud.platform.gateway.sign;

import com.longcloud.platform.gateway.sign.Base64;
import com.longcloud.platform.gateway.sign.HMACSHA1;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureHelper {
    private static Logger logger = LoggerFactory.getLogger(SignatureHelper.class);
    public static final String SIGN_PREFIX = "lsdata";
    public static final String MSG_SPLITOR = "\n";

    public static Map<String, Object> buildSignHeader(String appkey, String secretkey) {
        HashMap<String, Object> header = new HashMap<String, Object>();
        String signDate = SignatureHelper.getSignDate();
        String userParams = Base64.encode(signDate);
        logger.debug(String.format("LsData-Date: %s", signDate));
        logger.debug(String.format("LsData-Params: %s", userParams));
        header.put("LsData-Date", signDate);
        header.put("LsData-Params", userParams);
        String signData = SignatureHelper.buildSignData(userParams, signDate);
        String sign = SignatureHelper.buildSignature(appkey, secretkey, signData);
        logger.debug(String.format("LsData-Authorization: %s", sign));
        logger.debug(String.format("LsData-Appkey: %s", appkey));
        header.put("LsData-Authorization", sign);
        header.put("LsData-Appkey", appkey);
        return header;
    }

    private static String getSignDate() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
    }

    private static String buildSignData(String userParams, String date) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append(userParams).append(MSG_SPLITOR).append(date).append(MSG_SPLITOR);
        return sbBuffer.toString();
    }

    private static String buildSignature(String appkey, String secretkey, String data) {
        String encodeData = Base64.encode(HMACSHA1.encode(data, secretkey));
        String sign = String.format("%s:%s:%s", SIGN_PREFIX, appkey, encodeData);
        return sign;
    }
}

