/*
 * Decompiled with CFR 0.152.
 */
package com.longcloud.platform.gateway.sign;

public class Base64 {
    static final String baseTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String encode(byte[] bytes) {
        byte pos;
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        for (i = 0; i < bytes.length - bytes.length % 3; i += 3) {
            pos = (byte)(bytes[i] >> 2 & 0x3F);
            tmp.append(baseTable.charAt(pos));
            pos = (byte)(((bytes[i] & 3) << 4) + (bytes[i + 1] >> 4 & 0xF));
            tmp.append(baseTable.charAt(pos));
            pos = (byte)(((bytes[i + 1] & 0xF) << 2) + (bytes[i + 2] >> 6 & 3));
            tmp.append(baseTable.charAt(pos));
            pos = (byte)(bytes[i + 2] & 0x3F);
            tmp.append(baseTable.charAt(pos));
        }
        if (bytes.length % 3 != 0) {
            if (bytes.length % 3 == 2) {
                pos = (byte)(bytes[i] >> 2 & 0x3F);
                tmp.append(baseTable.charAt(pos));
                pos = (byte)(((bytes[i] & 3) << 4) + (bytes[i + 1] >> 4 & 0xF));
                tmp.append(baseTable.charAt(pos));
                pos = (byte)((bytes[i + 1] & 0xF) << 2);
                tmp.append(baseTable.charAt(pos));
                tmp.append("=");
            } else if (bytes.length % 3 == 1) {
                pos = (byte)(bytes[i] >> 2 & 0x3F);
                tmp.append(baseTable.charAt(pos));
                pos = (byte)((bytes[i] & 3) << 4);
                tmp.append(baseTable.charAt(pos));
                tmp.append("==");
            }
        }
        return tmp.toString();
    }

    public static String encode(String src) {
        return Base64.encode(src.getBytes());
    }

    public static byte[] decode(String src) throws Exception {
        int i;
        byte[] bytes = null;
        StringBuffer buf = new StringBuffer(src);
        int c = 32;
        int oc = 32;
        for (i = 0; i < buf.length(); ++i) {
            oc = c;
            c = buf.charAt(i);
            if (oc == 13 && c == 10) {
                buf.deleteCharAt(i);
                buf.deleteCharAt(i - 1);
                i -= 2;
                continue;
            }
            if (c == 9) {
                buf.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != 32) continue;
            --i;
        }
        if (buf.length() % 4 != 0) {
            throw new Exception("Base64 decoding invalid length");
        }
        bytes = new byte[3 * (buf.length() / 4)];
        int index = 0;
        for (i = 0; i < buf.length(); i += 4) {
            byte data = 0;
            int nGroup = 0;
            for (int j = 0; j < 4; ++j) {
                char theChar = buf.charAt(i + j);
                data = theChar == '=' ? (byte)0 : Base64.getBaseTableIndex(theChar);
                if (data == -1) {
                    throw new Exception("Base64 decoding bad character");
                }
                nGroup = 64 * nGroup + data;
            }
            bytes[index] = (byte)(0xFF & nGroup >> 16);
            bytes[++index] = (byte)(0xFF & nGroup >> 8);
            bytes[++index] = (byte)(0xFF & nGroup);
            ++index;
        }
        byte[] newBytes = new byte[index];
        for (i = 0; i < index; ++i) {
            newBytes[i] = bytes[i];
        }
        return newBytes;
    }

    protected static byte getBaseTableIndex(char c) {
        int index = -1;
        for (int i = 0; i < baseTable.length(); i = (int)((byte)(i + 1))) {
            if (baseTable.charAt(i) != c) continue;
            index = i;
            break;
        }
        return (byte)index;
    }

    public static void main(String[] args) throws Exception {
        String encodedString = Base64.encode("\u5927\u5e45\u5ea6\u53cd\u5bf9\u6cd5\u5730\u65b9".getBytes());
        System.out.println(encodedString);
    }
}

