/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.domain.building.bo;

import cn.gtmap.realestate.domain.building.enums.ResultCodeEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class ResponseResult<T>
implements Serializable {
    private Integer code;
    private String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T data;
    private String stringCode;
    private boolean status = true;

    public static <T> ResponseResult<T> failure(String msg, T data) {
        ResponseResult<T> ResponseResult2 = new ResponseResult<T>();
        ResponseResult2.setCode(ResultCodeEnum.FAILURE.getCode());
        ResponseResult2.setMessage(ResultCodeEnum.FAILURE.getMessage());
        ResponseResult2.setData(data);
        return ResponseResult2;
    }

    public static <T> ResponseResult<T> failure(String msg) {
        ResponseResult<T> ResponseResult2 = new ResponseResult<T>();
        ResponseResult2.setCode(ResultCodeEnum.FAILURE.getCode());
        ResponseResult2.setMessage(StringUtils.isEmpty((CharSequence)msg) ? ResultCodeEnum.FAILURE.getMessage() : msg);
        return ResponseResult2;
    }

    public static <T> ResponseResult<T> success(String msg, T data) {
        ResponseResult<T> ResponseResult2 = new ResponseResult<T>();
        ResponseResult2.setCode(ResultCodeEnum.SUCCESS.getCode());
        ResponseResult2.setMessage(StringUtils.isEmpty((CharSequence)msg) ? ResultCodeEnum.SUCCESS.getMessage() : msg);
        ResponseResult2.setData(data);
        return ResponseResult2;
    }

    public static <T> ResponseResult<T> success(String msg) {
        ResponseResult<T> ResponseResult2 = new ResponseResult<T>();
        ResponseResult2.setCode(ResultCodeEnum.SUCCESS.getCode());
        ResponseResult2.setMessage(ResultCodeEnum.SUCCESS.getMessage());
        return ResponseResult2;
    }

    public ResponseResult() {
    }

    public ResponseResult(Integer code) {
        this.code = code;
    }

    public ResponseResult(String stringCode, String message) {
        this.code = Integer.valueOf(stringCode);
        this.stringCode = stringCode;
        this.message = message;
    }

    public ResponseResult(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public ResponseResult(boolean status, String message) {
        this.status = status;
        this.message = message;
    }

    public ResponseResult(boolean status, String message, T data) {
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public ResponseResult(Integer code, boolean status, String message, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public ResponseResult(Integer code, Throwable throwable) {
        this.code = code;
        this.message = throwable.getMessage();
    }

    public ResponseResult(Integer code, T data) {
        this.code = code;
        this.data = data;
    }

    public ResponseResult(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public ResponseResult(boolean status, T data) {
        this.status = status;
        this.data = data;
    }

    public ResponseResult(String stringCode, String message, T data) {
        this.code = Integer.valueOf(stringCode);
        this.stringCode = stringCode;
        this.message = message;
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseResult other = (ResponseResult)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getStringCode() {
        return this.stringCode;
    }

    public void setStringCode(String stringCode) {
        this.stringCode = stringCode;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return "ResponseResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", stringCode=" + this.getStringCode() + ", status=" + this.isStatus() + ")";
    }
}

