package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.server.service.impl.LogServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/27
 * @description 中心日志
 */
@Controller
@RequestMapping("/zxrz")
public class ZxrzController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZxrzController.class);

    @Autowired
    private LogServiceImpl logService;

    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private Repository repository;


    /**
     * 页面初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String index(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        List<Map<String, String>> czlxInfos = logService.queryCzlx();
        model.addAttribute("czlxInfos", czlxInfos);
        return "/join/zxrz";
    }

    /**
     * 中心日志查询方法入口
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "queryZxrz", method = RequestMethod.GET)
    public Object queryZxrz(Date kssj, Date jssj, String czlx, String yhmc,Pageable pageable) {
        Map<String, Object> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        if (czlx != null) {
            param.put("czlx", czlx);
        }

        if (yhmc != null) {
            param.put("yhmc", yhmc);
        }

        Page<List<Map<String, String>>> logInfos = repository.selectPaging("queryLogInfosByPage", param, pageable);
        return logInfos;
    }


    @ResponseBody
    @RequestMapping(value = "queryCznr", method = RequestMethod.POST)
    public Map<String, String> queryCznr(String cznrId) {
        Map<String, String> resdata = logService.queryCznrInfos(cznrId);
        return resdata;
    }


    /**
     * 数据加密更新
     */
    @ResponseBody
    @RequestMapping("/dataUpdate")
    public void dataHandle() {

        Object[] tablename = {BaDyaq.class, BaDyiq.class, BaFdcq1.class, BaFdcq2.class, BaQlr.class,BaSqr.class,BaYgdj.class};

        for (Object name : tablename) {
            try {
                Class attrObjClass = Class.forName(((Class) name).getName());
                ExampleUtil example = new ExampleUtil(attrObjClass, null);
                List<Object> objs = entityMapper.selectByExample(example);
                if (null != objs && !objs.isEmpty()) {
                    for (Object obj : objs) {
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            } catch (ClassNotFoundException e) {
                LOGGER.error("=转换异常SocketHandler.sendMessageToUsers.IOException error in!{}",e);
            }
        }
        LOGGER.info("=================转换成功！====================");
    }

}
