package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.ZlbgServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/27
 * @description 质量报告
 */
@Controller
@RequestMapping("/zlbg")
public class ZlbgController extends BaseController {


    @Autowired
    ZlbgServiceImpl zlbgService;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;


    @Autowired
    private Repository repository;

    /**
     * 初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String index(Model model) {
        String  serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String,Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if(CollectionUtils.isNotEmpty(cityList)){
            model.addAttribute("cityList", cityList);
            model.addAttribute("flag","city");//省级平台
        }else{
            List<Map<String, Object>> xzqhInfos = xzqhInfoService.getQxxxByFdm(qhdm);
            model.addAttribute("cityList", xzqhInfos);
            model.addAttribute("flag","county");//市级平台
        }
        return "/join/zlbg";
    }


    /**
     * 质量报告查询
     * @param kssj
     * @param jssj
     * @return
     */
    @RequestMapping("/queryZlbg")
    @ResponseBody
    public Object queryZlbg(String dsCode,String qxCode, Date kssj, Date jssj, Pageable pageable) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("dsCode", dsCode);
        map.put("qxCode", qxCode);
        if(null!=kssj){
            map.put("kssj", TimeUtils.dateToStr(kssj,"yyyyMMdd"));
        }
        if(null!=jssj){
            map.put("jssj", TimeUtils.dateToStr(jssj,"yyyyMMdd"));
        }
        Page<List<Map<String, String>>> resList = repository.selectPaging("getCountByJRDMByPage", map, pageable);
        return resList;
    }

    /**
     * 导出excel
     *
     * @param kssj
     * @param jssj
     * @param response
     */
    @RequestMapping(value = "/export", method = RequestMethod.GET)
    public void export(String dsCode,String qxCode, Date kssj, Date jssj, HttpServletResponse response,HttpServletRequest request) {
        Map<String, Object> map = new HashMap<String, Object>();
        if(StringUtils.isNotBlank(dsCode)){
            map.put("dsCode", dsCode);
        }
        if(StringUtils.isNotBlank(qxCode)){
            map.put("qxCode", qxCode);
        }
        if(null!=kssj){
            map.put("kssj", TimeUtils.dateToStr(kssj,"yyyyMMdd"));
        }
        if(null!=jssj){
            map.put("jssj", TimeUtils.dateToStr(jssj,"yyyyMMdd"));
        }

        UserAuthDTO userInfos = getCurrentUser(request);
        zlbgService.export(map, response, request,userInfos);

    }


}

