package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.server.model.RabbitMqNodeInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitMqOverView;
import cn.gtmap.realestate.supervise.server.model.RabbitmqQueueInfo;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitMqInfoContain;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 性能监控
 */

@Controller
@RequestMapping("/xnjk")
public class XnjkController {

    @Autowired
    RabbitMqInfoContain rabbitMqInfoContain;

    /**
     * 页面初始化
     *
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping("")
    public String getIndex(Model model) {

        getTotalInfos();
        getInfos();
        return "/join/xnjk";
    }

    /**
     * 整体状况参数
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getZtzkInfos")
    public List<Map<String, Object>> getTotalInfos() {
        RabbitMqOverView rabbitMqOverView = rabbitMqInfoContain.getRabbitMqOverView();

        RabbitMqNodeInfo rabbitMqNodeInfo = rabbitMqInfoContain.getRabbitMqNodeInfo();

        List<Map<String, Object>> resList = new ArrayList<>();
        Map<String, Object> resMap = Maps.newHashMap();



        if (null != rabbitMqOverView ) {
            RabbitMqOverView.Contents contents = rabbitMqOverView.getObject_totals();

            int connections = contents.getConnections();
            int channels = contents.getChannels();
            int exchanges = contents.getExchanges();
            int queues = contents.getQueues();
            int consumers = contents.getConsumers();
            resMap.put("connections", connections);
            resMap.put("channels", channels);
            resMap.put("exchanges", exchanges);
            resMap.put("queues", queues);
            resMap.put("consumers", consumers);

        }
        if(null!=rabbitMqNodeInfo ){
            DecimalFormat df = new DecimalFormat("####");
            resMap.put("disk_free", df.format(rabbitMqNodeInfo.getDisk_free() / 1024 / 1024 / 1024));
            resMap.put("mem_used", df.format(rabbitMqNodeInfo.getMem_used() / 1024 / 1024));
            resMap.put("running", rabbitMqNodeInfo.isRunning());
            resMap.put("name", rabbitMqNodeInfo.getName());
            resList.add(resMap);
        }

        return resList;
    }

    /**
     * 消息吞吐量
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getInfos")
    public List<Map<String, Object>> getInfos() {

        List<Map<String, Object>> resList = new ArrayList<>();
        Map<String, Object> resMap = Maps.newHashMap();
        RabbitmqQueueInfo rabbitmqQueueInfo = rabbitMqInfoContain.getRabbitmqQueueInfo();
        if(null!=rabbitmqQueueInfo ){
            RabbitmqQueueInfo.MessageStatus messageStatus = rabbitmqQueueInfo.getMessage_stats();
            String name = rabbitmqQueueInfo.getName();
            String vhost = rabbitmqQueueInfo.getVhost();
            if(null!=messageStatus){
                int ready = (null == messageStatus.getDisk_reads() ? 0 : messageStatus.getDisk_reads());
                int publish = (null == messageStatus.getPublish() ? 0 : messageStatus.getPublish());
                int deliver = (null == messageStatus.getDeliver_get() ? 0 : messageStatus.getDeliver_get());
                resMap.put("publish", publish);
                resMap.put("deliver", deliver);
                resMap.put("ready", ready);
            }else{
                resMap.put("publish", 0);
                resMap.put("deliver", 0);
                resMap.put("ready", 0);
            }

            resMap.put("queueName", name);
            resMap.put("vhost", vhost);

            resList.add(resMap);
        }

        return resList;
    }

}
