package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.server.service.impl.TszdkxlServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.ExportExcelUtils;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2018/12/20
 * @description 特殊字段空项率统计
 */
@Controller
@RequestMapping("tszdkxtj")
public class TszdkxlController extends BaseController {


    @Autowired
    private TszdkxlServiceImpl tszdkxlService;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    private String regionName;

    /**
     * 页面初始化
     *
     * @return
     */
    @RequestMapping("")
    public String init(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        regionName = getRegionName();
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            regionName = regionName + "省";
        }
        Date curDate = new Date();
        Date endDate = TimeUtils.getBeforeDate(curDate, -1);//昨天
        Date startDate = TimeUtils.getBeforeDate(curDate, -7);//往前推第七天
        String startTime = TimeUtils.dateToStr(startDate, "yyyy年MM月dd日");
        String endTime = TimeUtils.dateToStr(endDate, "yyyy年MM月dd日");
        model.addAttribute("cityName", regionName);
        model.addAttribute("startTime", startTime);
        model.addAttribute("endTime", endTime);
        return "join/tszdkxtj";
    }


    /**
     * 查询
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @RequestMapping("getCxxx")
    @ResponseBody
    public List<Map<String, Object>> getCxxx(Date startDate, Date endDate) {
        List<Map<String, Object>> resList = tszdkxlService.getCxxx(startDate, endDate, false);
        return resList;
    }


    /**
     * 特殊字段空项率统计导出
     *
     * @param startDate
     * @param endDate
     * @param response
     */
    @RequestMapping("exportInfos")
    public void exportInfos(Date startDate, Date endDate, HttpServletResponse response, HttpServletRequest request) {
        List<Map<String, Object>> resList = tszdkxlService.getCxxx(startDate, endDate, true);
        if (null == startDate && null == endDate) {
            Date curDate = new Date();
            endDate = TimeUtils.getBeforeDate(curDate, -1);//昨天
            startDate = TimeUtils.getBeforeDate(curDate, -7);//往前推第七天
        }
        String fileName = regionName + "不动产登记增量数据关键字段完整率统计(" + TimeUtils.dateToStr(startDate, "yyyy.MM.dd") +
                "-" + TimeUtils.dateToStr(endDate, "yyyy.MM.dd") + ")";
        OperationalLogUtil.log(request, "1", "不动产登记增量数据关键字段完整率统计导出", "接入系统");
        ExportExcelUtils.exportTszdkxtjInfos(resList, fileName, response);
    }

}
