package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.model.RabbitMqNodeInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitmqClientQueueInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitmqQueueInfo;
import cn.gtmap.realestate.supervise.server.quartz.rabbitmqinfo.RabbitMqInfoScheduledTasks;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitMqInfoContain;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitServerConfig;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitServerInfo;
import cn.gtmap.realestate.supervise.server.service.impl.ClientInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.DecimalFormat;
import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/9/1
 * @description websocket 控制器
 */
@Controller
@RequestMapping("/index")
public class SocketController extends BaseController implements ApplicationContextAware {


    private static final Logger LOGGER = LoggerFactory.getLogger(SocketController.class);

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    private ClientInfoServiceImpl clientInfoService;

    //    @Autowired
    private RabbitMqInfoScheduledTasks rabbitMqInfoScheduledTasks;

    @Autowired
    private RabbitServerInfo rabbitServerInfo;

    @Autowired
    private RabbitMqInfoContain rabbitMqInfoContain;


    //上下文变量
    private ApplicationContext applicationContext;

    @RequestMapping("")
    public String getIndex(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        String qhjb = getQhjb();
        String regionName = getRegionName();
        model.addAttribute("serverUrlStr", serverUrl.substring(4));
        String startTime =TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -14), "yyyy-MM-dd");
        String endTime=TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -1), "yyyy-MM-dd");
        model.addAttribute("startTime", startTime);
        model.addAttribute("endTime", endTime);
        if (StringUtils.isNotBlank(qhjb) && StringUtils.equals("省级", qhjb)) {
            model.addAttribute("regionName", regionName);
            model.addAttribute("regionNameStr", regionName + "省");
            return "/join/indexRocketmqPro";
        } else {
            model.addAttribute("regionName", regionName);
            model.addAttribute("regionNameStr", regionName);
            return "/join/indexRocketmqCity";
        }
    }


    /**
     * 获取首页信息
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getDataInfos")
    public List<Map<String, Object>> getDataInfos(String qhmc) {

        return xzqhInfoService.getHztjxx(qhmc);
    }


    /**
     * 获取首页信息
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getpronviceByqhdm")
    public  String   getpronviceByqhdm(){
        return   AppConfig.getProperty("region.qhdm").subSequence(0,1).toString();
    }


    /**
     * 陕西省接入首页部分重写----接入概况 接口重写
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getDataJrgkSx")
    public  Map<String,Object>  getjrgkxxSx(HttpServletRequest request,String paramqhdm){
        String qhdm = AppConfig.getProperty("region.qhdm");
        Map<String,Object> jrgkMapxx =new HashMap<>();
        String  qhdmIndex = qhdm.subSequence(0, 1).toString();
        UserAuthDTO userAuthDTO = getCurrentUser(request);
        String  qhjb = "";
        if(userAuthDTO!=null&&CollectionUtils.isNotEmpty(userAuthDTO.getRegions())) {
            qhjb = CommonUtil.formatEmptyValue(userAuthDTO.getRegions().get(0).get("level"));
        }
        jrgkMapxx =xzqhInfoService.getIndexSx(qhjb,paramqhdm);
        return  jrgkMapxx;
    }




    /**
     * 接入点概况统计
     *
     * @return
     */
    @RequestMapping("getJrdgk")
    @ResponseBody
    public Map<String, Object> getJrdgk(String qhmc) {
        Map<String, Object> resData = clientInfoService.getJrdgk(qhmc);
        return resData;
    }

    /**
     * 上报概况统计
     *
     * @return
     */
    @RequestMapping("getSbgk")
    @ResponseBody
    public Map<String, Object> getSbgk(String qhmc) {
        Map<String, Object> resData = xzqhInfoService.getSbqkData(qhmc);
        return resData;
    }


    /**
     * 获取首页地图坐标
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getZb")
    public Map<String, Object> getGeocoord() {
        Map<String, Object> resultMap = new HashMap<>();
        Map<String, Object> paramMap = new HashMap<>();
        String qhdm = AppConfig.getProperty("region.qhdm");
        paramMap.put("fdm", qhdm);
        List<Map<String, Object>> mapList = xzqhInfoService.getCityInfos(paramMap);
        if (CollectionUtils.isNotEmpty(mapList)) {
            for (Map map1 : mapList) {
                List<String> zbLst = new ArrayList<>();
                Map<String, Object> temp = Maps.newHashMap();
                if (map1.containsKey("GEOCORDX") && null != map1.get("GEOCORDX")) {
                    zbLst.add(map1.get("GEOCORDX").toString());
                    temp.put("XZB", map1.get("GEOCORDX").toString());
                } else {
                    zbLst.add("0");
                    temp.put("XZB", 0);
                }
                if (map1.containsKey("GEOCORDY") && null != map1.get("GEOCORDY")) {
                    zbLst.add(map1.get("GEOCORDY").toString());
                    temp.put("YZB", map1.get("GEOCORDY").toString());
                } else {
                    zbLst.add("0");
                    temp.put("YZB", 0);
                }
                temp.put("QHMC", map1.get("QHMC").toString());
                resultMap.put(map1.get("QHMC").toString(), zbLst);


            }
        }
        return resultMap;
    }


    /**
     * 获取首页地图坐标
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getZbName")
    public List<Map<String, Object>> getZbName() {
        Map<String, Object> paramMap = new HashMap<>();
        String qhdm = AppConfig.getProperty("region.qhdm");
        paramMap.put("fdm", qhdm);
        List<Map<String, Object>> resList = null;
        List<Map<String, Object>> mapList = xzqhInfoService.getCityInfos(paramMap);
        for (Map<String, Object> temp : mapList) {
            String qhdmStr = (String) temp.get("QHDM");
            if (!StringUtils.equals(qhdm, qhdmStr)) {
                String qhmc = (String) temp.get("QHMC");
                resList = xzqhInfoService.getHztjxx(qhmc);
            }

            //获取异常接入点数量
            if (qhdm.equals(qhdmStr)) {
                temp.put("JRDZT", 1);//已接入
            } else {
                List<Map<String, String>> jrdxxList = xzqhInfoService.getJrdxxByQhdm(qhdmStr);
                List<Map<String, String>> jrdxxqxxxList = xzqhInfoService.getJrdQxxxByQhdm(qhdmStr);
                if (CollectionUtils.isNotEmpty(jrdxxList) || CollectionUtils.isNotEmpty(jrdxxqxxxList)) {
                    temp.put("JRDZT", 0);//未接入
                } else {
                    temp.put("JRDZT", 1);//已接入
                }
            }
            if (CollectionUtils.isNotEmpty(resList)) {
                temp.put("ZJRL", resList.get(0).get("ALLZJRL"));
            } else if (!StringUtils.equals(qhdmStr, qhdm) && CollectionUtils.isEmpty(resList)) {
                temp.put("ZJRL", "0");
            }
        }
        List<Integer> sortList = new ArrayList<Integer>();
        for (int i = 0; i < mapList.size(); i++) {
            Map temp = mapList.get(i);
            if (temp.containsKey("ZJRL")) {
                sortList.add(Integer.parseInt((String) temp.get("ZJRL")));
            }
        }
        int maxVal = Collections.max(sortList);
        int minVal = Collections.min(sortList);
        int avgVal = (maxVal - minVal) / 5;
        Map<String, Object> firstMap = mapList.get(0);
        for (int i = 4; i > 1; i--) {
            int temp = minVal + avgVal;
            minVal = temp;
            temp = getFormatNum(temp);
            firstMap.put("NUM" + String.valueOf(i), temp);
        }
        firstMap.put("NUM1", getFormatNum(minVal + avgVal));
        return mapList;
    }

    public static int getFormatNum(int num) {
        int res = 10;
        if (String.valueOf(num).length() >= 5) {//万
            int temp = num / 10000;
            res = temp * 10000;
        }
        if (String.valueOf(num).length() == 4) {//千
            int temp = num / 1000;
            res = temp * 1000;
        }
        if (String.valueOf(num).length() == 3) {//百
            int temp = num / 100;
            res = temp * 100;
        }
        return res;
    }


    /**
     * 获取消息队列概况
     *
     * @return
     */
    @ResponseBody
    @RequestMapping("getXxdlgk")
    public Map<String, Object> getXxdlgk() {
        if (null == rabbitMqInfoScheduledTasks) {
            rabbitMqInfoScheduledTasks = getApplicationContext().getBean(RabbitMqInfoScheduledTasks.class);
        }
        RabbitServerConfig rabbitServerConfig = rabbitMqInfoScheduledTasks.getRabbitServerConfig();
        String queuesinfos = rabbitServerInfo.getQueues(rabbitServerConfig, rabbitServerConfig.getName(), rabbitServerConfig.getPassword());
        int dlzsl = 0;
        int dlhysl = 0;
        int dlkxsl = 0;
        RabbitMqNodeInfo rabbitMqNodeInfo = rabbitMqInfoContain.getRabbitMqNodeInfo();
        if (StringUtils.isNotBlank(queuesinfos)) {
            JSONArray jsonArray = JSONArray.parseArray(queuesinfos);
            dlzsl = jsonArray.size();
            for (int i = 0; i < dlzsl; i++) {
                Object obj = jsonArray.get(i);
                RabbitmqClientQueueInfo queueinfo = RabbitmqQueueInfo.getRabbitmqClientQueueInfo(obj.toString());
                String idleSince = queueinfo.getIdle_since();
                if (StringUtils.isNotBlank(idleSince)) {
                    dlkxsl++;
                } else {
                    dlhysl++;
                }
            }
        }

        Map<String, Object> resData = Maps.newHashMap();
        RabbitmqQueueInfo rabbitmqQueueInfo = rabbitMqInfoContain.getRabbitmqQueueInfo();
        if (null != rabbitmqQueueInfo) {
            RabbitmqQueueInfo.MessageStatus messageStatus = rabbitmqQueueInfo.getMessage_stats();
            if (null != messageStatus) {
                int publish = (null == messageStatus.getPublish() ? 0 : messageStatus.getPublish());
                resData.put("PUBLISH", publish);
            } else {
                resData.put("PUBLISH", 0);
            }

        }
        resData.put("DLZSL", dlzsl);
        resData.put("DLHYSL", dlhysl);
        resData.put("DLKXSL", dlkxsl);
        DecimalFormat df = new DecimalFormat("####");

        resData.put("DISK_FREE", df.format(rabbitMqNodeInfo.getDisk_free() / 1024 / 1024 / 1024));
        resData.put("MEM_USED", df.format(rabbitMqNodeInfo.getMem_used() / 1024 / 1024));
        return resData;
    }

    /**
     * 接入变化趋势折线图
     *
     * @return
     */
    @RequestMapping("getJrqkList")
    @ResponseBody
    public List<Map<String, Object>> getJrqkList(String qhmc, String dateTime) {
        List<Map<String, Object>> resList = xzqhInfoService.getJrqkList(qhmc, dateTime);
        return resList;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }


}