package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.server.dao.mapper.SlsqMapper;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;


/**
 * @author: <a href="mailto:huming@gtmap.cn">huming</a>
 * @version: 1.0, 2020/12/3
 * @Description: 修改受理申请表
 */
@Controller
@RequestMapping("/slsq")
public class SlsqSflwController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(SlsqSflwController.class);

    @Autowired
    private SlsqMapper slsqMapper;

    /**
     * 修改是否例外状态
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "sflw")
    public Map updateSlsqSflw(@RequestBody Map map) {
        Map resultMap = Maps.newHashMap();
        try {
            slsqMapper.updateSflw(map);
            resultMap.put("code", "1");
            resultMap.put("msg", "成功");
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            resultMap.put("code", "0");
            resultMap.put("msg", "数据更新失败," + e.getMessage());
        }
        return resultMap;
    }
}
