package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.service.LogService;
import cn.gtmap.realestate.supervise.server.service.impl.SbcxServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 上报查询
 */
@Controller
@RequestMapping("/sbcx")
public class SbcxController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(SbcxController.class);

    @Autowired
    private LogService logService;

    @Autowired
    private SearchService searchService;

    @Autowired
    private Repository repository;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    private SbcxServiceImpl sbcxServiceImpl;

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    /**
     * 上报文件备份路径
     */
    String sftpBizBakPath = AppConfig.getProperty("supervise.sftp.biz.bak.path");

    /**
     * 页面初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String logQuery(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        List<Map<String, String>> ywbmInfos = logService.getYwbmInfos();
        model.addAttribute("ywbmInfos", ywbmInfos);
        model.addAttribute("serverUrl", serverUrl);
        String qhdm = AppConfig.getProperty("region.qhdm");
        String qhmc = baXzqhMapper.getQhmcByqhdm(qhdm);
        List<Map<String, Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            model.addAttribute("cityList", cityList);
            model.addAttribute("flag", "city");//省级平台
        } else {
            List<Map<String,Object>> dsInfos = new ArrayList<>();
            Map<String,Object> dsmap = new HashMap<>();
            dsmap.put("QHMC",qhmc);
            dsmap.put("QHDM",qhdm);
            dsInfos.add(dsmap);
            model.addAttribute("cityList", dsInfos);
            model.addAttribute("flag", "county");//市级平台
        }
        if(qhdm.substring(0,2).equals("32")){
            return "/join/sbcx";
        }else {
            return "/join/sbcxSX";

        }
    }

    /**
     * 报文查询按钮操作
     *
     * @param inParam
     * @param pageable
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "queryBwInfos")
    public Object queryBwInfos(@RequestParam Map<String, Object> inParam, Pageable pageable) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern("yyyyMMdd");

        Map<String, Object> param = Maps.newHashMap();
        String bdcdyh = (String) inParam.get("bdcdyh");
        String kssj = (String) inParam.get("kssj");
        String jssj = (String) inParam.get("jssj");
        String ywbm = (String) inParam.get("ywbm");
        String dsCode = (String) inParam.get("dsCode");
        String qxCode = (String) inParam.get("qxCode");
        String xyjg = (String) inParam.get("xyjg");
        String bbjg = (String) inParam.get("bbjg");
        if (StringUtils.isNotBlank(bdcdyh)) {
            param.put("bdcdyh", bdcdyh);
        }
        if (StringUtils.isNotBlank(ywbm)) {
            param.put("ywbm", ywbm);
        }
        if (StringUtils.isNotBlank(dsCode)) {
            param.put("dsCode", dsCode);
        }
        if (StringUtils.isNotBlank(qxCode)) {
            param.put("qxCode", qxCode);
        }
        if (StringUtils.isNotBlank(bbjg)) {
            param.put("bbjg", bbjg);
        }
        //陕西特殊地区、特殊处理 begin
        if (StringUtils.equals(dsCode, Constant.YL) || StringUtils.equals(dsCode, Constant.HC)) {
            param.put("qxCode", dsCode);//区县
            param.put("dsCode", "");//大市
        }
        //陕西特殊地区、特殊处理 end

        if (StringUtils.isNotBlank(kssj)) {
            kssj = kssj.replaceAll("-", "");
            param.put("kssj", kssj);
        }
        if (StringUtils.isNotBlank(jssj)) {
            jssj = jssj.replaceAll("-", "");
            param.put("jssj", jssj);
        }
        if (StringUtils.isNotBlank(xyjg)) {
            if (StringUtils.equals(xyjg, "0")) {
                param.put("rkjg", Constant.CG);
            }
            if (StringUtils.equals(xyjg, "1")) {
                param.put("rkjg", Constant.SB);
            }
            if (StringUtils.equals(xyjg, "2")) {
                param.put("rkjg", Constant.EMPTY);
            }
            if (StringUtils.equals(xyjg, "3")) {
                param.put("rkjg", Constant.WSB);
            }
        }
        if (StringUtils.isBlank(kssj) && StringUtils.isBlank(jssj) && StringUtils.isBlank(bdcdyh) && StringUtils.isBlank(ywbm)
                && StringUtils.isBlank(dsCode) && StringUtils.isBlank(qxCode) && StringUtils.isBlank(xyjg)) {
            param.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-30), "yyyyMMdd"));
        }
        if (StringUtils.isBlank(jssj) && StringUtils.isBlank(kssj) && StringUtils.isBlank(bdcdyh) && StringUtils.isBlank(ywbm)
                && StringUtils.isBlank(dsCode) && StringUtils.isBlank(qxCode) && StringUtils.isBlank(xyjg)) {
            param.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(0), "yyyyMMdd"));
        }
        return repository.selectPaging("getSbBwInfosByPage", param, pageable);
    }

    /**
     * 查询业务报文
     *
     * @param bwlj
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "searchbw", method = RequestMethod.POST)
    public Map<String, String> searchBw(String bwlj, String ywbwid) {
        Map<String, String> data = new HashMap<>();
        try {
            String xmlFormat = searchService.mainGetData(bwlj, "", "", ywbwid, "");
            data.put("bw", xmlFormat);
        } catch (Exception e) {
            data.put("bw", Constant.EMPTY);
            LOGGER.error("查询上报业务报文信息异常！{}", e);
        }

        return data;
    }

    /**
     * 查询响应报文
     *
     * @param fhbwlj
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "searchfhbw", method = RequestMethod.POST)
    public Map<String, String> searchFhBw(String fhbwlj, String xybwid) {
        Map<String, String> data = new HashMap<>();
        try {
            if (StringUtils.isNotBlank(fhbwlj) && fhbwlj.indexOf("Rep")>-1) {
                String respPath = fhbwlj.substring(fhbwlj.indexOf("Rep"));
//                byte[] bytes = FileUtils.getBytes(new File(fhbwlj));
//                String xmlInfos = new String(bytes, "UTF-8");
//                if (StringUtils.isBlank(xmlInfos)) {
                String xmlFormat = searchService.mainGetData(respPath, "", Constant.BBXYBWBJ, "", xybwid);
                data.put("bw", xmlFormat);
//                }
//                if (StringUtils.isNotBlank(xmlInfos)) {
//                    String xmlFormat = XmlUtil.format(xmlInfos);
//                    data.put("bw", xmlFormat);
//                }
            } else {
                data.put("bw", Constant.EMPTY);
            }

        } catch (Exception e) {
            LOGGER.error("searchFhBw.Exception:{}", e);
            data.put("bw", Constant.EMPTY);
        }
        return data;
    }

    /**
     * 上报失败删除
     *
     * @param id
     * @param bwlj
     * @param ywbm
     * @param bdcdyh
     * @param fileName
     * @param sbcode
     * @param request
     * @return
     */
    @RequestMapping(value = "delBwInfos", method = RequestMethod.POST)
    @ResponseBody
    public Map<String, String> delBwInfos(String id, String bwlj, String ywbm, String bdcdyh, String fileName, String sbcode, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("bwlj", bwlj);
        paramMap.put("ywbm", ywbm);
        paramMap.put("bdcdyh", bdcdyh);
        paramMap.put("fileName", fileName);
        paramMap.put("sbcode", sbcode);
        Map<String, String> ret = new HashMap<>();
        try {
            logService.delBwInfos(paramMap, userInfos);
        } catch (Exception e) {
            LOGGER.error("Exception:{}", e);
            ret.put("returnMsg", "fail");
            return ret;
        }
        ret.put("returnMsg", "success");
        return ret;
    }

    /**
     * 手动上报
     *
     * @param bwljs
     * @return
     */
    @RequestMapping(value = "manualReport", method = RequestMethod.POST)
    @ResponseBody
    public Map<String, Object> manualReport(String bwljs, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        sbcxServiceImpl.manualReport(bwljs, userInfos, request, sftpBizBakPath);
        return Maps.newHashMap();
    }


    /**
     * 查看报部响应报文
     *
     * @param fhbwlj
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "ckbbxybw", method = RequestMethod.POST)
    public Map<String, String> ckbbxybw(String fhbwlj, String ejsbjgid) {
        Map<String, String> data = new HashMap<>();

        try {
            String respPath = fhbwlj.substring(fhbwlj.indexOf("Rep"));
            String xmlFormat = searchService.mainGetData(respPath, "", Constant.BBSBXYBWBJ, "", ejsbjgid);
            if (StringUtils.isNotBlank(xmlFormat)) {
                data.put("bw", xmlFormat);
            } else {
                data.put("bw", Constant.EMPTY);
            }
        } catch (Exception e) {
            data.put("bw", Constant.EMPTY);
            LOGGER.error("查看报部响应报文异常，Exception:{},filePath:{}", e, fhbwlj);
        }
        return data;
    }
}
