package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.entity.CheckRule;
import cn.gtmap.realestate.supervise.server.service.RuleFiterService;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 规则管理
 */
@Controller
@RequestMapping("/rule")
public class RuleController extends BaseController {

    @Autowired
    private RuleFiterService ruleInfoService;


    private UserAuthDTO userInfos;

    /**
     * 页面初始化
     * @param model
     * @return
     */
    @RequestMapping("")
    public String index(Model model,HttpServletRequest request)  {
        String  serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        userInfos = getCurrentUser(request);
        return "/join/rule";
    }


    /**
     * 页面初始化查询
     * @return
     */
    @ResponseBody
    @RequestMapping("/queryRule")
    public List<CheckRule> getData() {
        List<CheckRule> data = ruleInfoService.getRuleInfoList(null);
        if (data == null) {
            data = new ArrayList<>();
        }
        return data;
    }

    /**
     * 修改规则
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public Map<String, String> update(String id,String rulecode,String rulename, String ischeck, int weight) {
        CheckRule ruleInfo = new CheckRule();
        ruleInfo.setId(id);
        ruleInfo.setRulecode(rulecode);
        ruleInfo.setIscheck(ischeck);
        ruleInfo.setWeight(weight);
        ruleInfo.setRulename(rulename);
        ruleInfoService.update(ruleInfo,userInfos);
        Map<String, String> map = new HashMap<>();
        map.put("returnMsg", "success");
        return map;
    }


    /**
     * 编辑规则
     * @param id
     * @return
     */
    @RequestMapping(value = "/editor", method = RequestMethod.POST)
    @ResponseBody
    public CheckRule editorPost(String id) {
        if (null != id && !StringUtils.isBlank(id)) {
            Map<String, String> param = new HashMap<>();
            param.put("id", id);
            List<CheckRule> data = ruleInfoService.getRuleInfoList(param);
            if (null!=data && !data.isEmpty()) {
                return data.get(0);
            }
        }
        return new CheckRule();
    }


    /**
     * 编辑接入点
     * @param
     * @return
     */
    @RequestMapping(value = "/short", method = RequestMethod.POST)
    @ResponseBody
    public Map<String,String> shortPost(String shortString) {
        Map<String,String> response = new HashMap<>();
        ruleInfoService.shortWeight(shortString,userInfos);
        response.put("messae","ok");
        return response;
    }
}

