package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.server.service.LeaderDeskSupportService;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

/**
 * 领导桌面 controller
 */
@Controller
@RequestMapping("/leader-desk")
public class LeaderDeskSupportController {

    /**
     * 领导桌面 service
     */
    @Autowired
    private LeaderDeskSupportService leaderDeskSupportService;

    /**
     * 获取上报、接入计数统计
     * @param xzqhdm
     * @param endDate
     * @return
     */
    @ResponseBody
    @RequestMapping("/get-sbjr-count")
    public Map<String, Object> getSbJrCount(String xzqhdm, String endDate){
        Map<String, Object> data = Maps.newHashMap();
        Map<String, Object> result = Maps.newHashMap();
        if(StringUtils.isNotBlank(xzqhdm)){
            xzqhdm = xzqhdm.substring(0,4);
        }
        Map<String, Object> sbCountMap = leaderDeskSupportService.getSbCount(xzqhdm, endDate);
        Map<String, Object> jrCountMap = leaderDeskSupportService.getJrCount(xzqhdm, endDate);
        result.put("sbCount", sbCountMap);
        result.put("jrCount", jrCountMap);
        data.put("data", result);
        return data;
    }

}
