package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.server.common.ReadJsonUtil;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaTjfxMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.JrdbzlpjMapper;
import cn.gtmap.realestate.supervise.server.entity.Kxlzd;
import cn.gtmap.realestate.supervise.server.entity.Pjdfqk;
import cn.gtmap.realestate.supervise.server.service.JrdbzlpjService;
import cn.gtmap.realestate.supervise.server.service.KxlService;
import cn.gtmap.realestate.supervise.server.service.impl.JrdbzlpjServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.DecimalFormat;
import java.util.*;

import static cn.gtmap.realestate.supervise.server.utils.MapUtil.sortByValue;
import static cn.gtmap.realestate.supervise.server.utils.MapUtil.sortReverseByValue;

/**
 * Created by user on 2020/5/12.
 */

@Controller
@RequestMapping(value = "jrzlpjfx")
public class JrzlpjfxController extends BaseController {


    @Autowired
    private KxlService kxlService;

    @Autowired
    private JrdbzlpjService jrdbzlpjService;

    @Autowired
    private JrdbzlpjServiceImpl jrdbzlpjServiceImpl;

    @Autowired
    private BaTjfxMapper baTjfxMapper;

    @Autowired
    private JrdbzlpjMapper jrdbzlpjMapper;

    Map<String, String> zdnameMap;



    String region = AppConfig.getProperty("region.qhdm");

    @RequestMapping("/showIndex")
    public Object showIndex(Model model) {

        return "/join/jrzlpjfx";
    }

    /*
     接入成功率情况 echart
     */
    @ResponseBody
    @RequestMapping("/getJrcglqk")
    public Object getJrcglqk(String kssj,String jssj,String sqkssj,String sqjssj) {

        //第三个
        Map<String, String> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);


        Map<String, String> sqparam = Maps.newHashMap();
        sqparam.put("sqkssj", sqkssj);
        sqparam.put("sqjssj",sqjssj);
        sqparam.put("provinceDm", region);

        List<Pjdfqk>  jrcglList = new ArrayList<>();
        List<Map<String, String>> data = jrdbzlpjService.getJrzlpjData(param);
        List<Map<String, String>> sqdata = jrdbzlpjService.getJrzlpjData(sqparam);
        data.remove(0);
        sqdata.remove(0);
        for(int i=0;i<data.size();i++) {
           if(StringUtils.equals(data.get(i).get("QHJB").toString(),"市级")){;
               Pjdfqk pd =new Pjdfqk();
               pd.setXzqhmc(data.get(i).get("QHMC").toString());
               pd.setQhdm(data.get(i).get("QHDM").toString());
               pd.setQhjb(data.get(i).get("QHJB").toString());
               pd.setZb(Double.valueOf(data.get(i).get("WCGJRZB").toString().substring(0, data.get(i).get("WCGJRZB").toString().length() - 1)));
               pd.setSqzb(Double.valueOf(sqdata.get(i).get("WCGJRZB").toString().substring(0, sqdata.get(i).get("WCGJRZB").toString().length() - 1)));
               jrcglList.add(pd);
           }
        }



        for(int i=0;i<jrcglList.size();i++){
             List<Pjdfqk> childrenlist = new ArrayList<>();
            for(int j=0;j<data.size();j++){
                if(StringUtils.equals(jrcglList.get(i).getQhdm().toString(),data.get(j).get("FDM").toString())){
                    Pjdfqk  childrenpd =new Pjdfqk();
                    childrenpd.setQhdm(data.get(j).get("QHDM").toString());
                    childrenpd.setXzqhmc(data.get(j).get("QHMC").toString());
                    childrenpd.setFdm(data.get(j).get("FDM").toString());
                    childrenpd.setZb(Double.valueOf(data.get(j).get("WCGJRZB").toString().substring(0, data.get(j).get("WCGJRZB").toString().length() - 1)));
                    childrenpd.setSqzb(Double.valueOf(sqdata.get(j).get("WCGJRZB").toString().substring(0, sqdata.get(j).get("WCGJRZB").toString().length() - 1)));
                    childrenlist.add(childrenpd);
                }
            }
            jrcglList.get(i).setChildrens(childrenlist);
        }



        return  jrcglList;
    }

    /**
     * 接入成功率table
     * @param kssj
     * @param jssj
     * @param sqkssj
     * @param sqjssj
     * @return
     */

    @ResponseBody
    @RequestMapping("/getJrcglqkTable")
    public   Object getJrcglqkTable(String kssj,String jssj,String sqkssj,String sqjssj){

        Map<String, String> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);


        Map<String, String> sqparam = Maps.newHashMap();
        sqparam.put("sqkssj", sqkssj);
        sqparam.put("sqjssj", sqjssj);
        sqparam.put("provinceDm", region);


        List<Map<String, String>> data = jrdbzlpjService.getJrzlpjData(param);
        List<Map<String, String>> sqdata = jrdbzlpjService.getJrzlpjData(sqparam);
        List<Map<String, String>> citydataList =new ArrayList<>();
        List<Map<String, String>> qxdataList =new ArrayList<>();
        List<Pjdfqk> cityList =new ArrayList<>();
        List<Pjdfqk> qxList =new ArrayList<>();
        List<Map<String, String>> cityListfs = new ArrayList<>();
        List<Map<String, String>> qxListfs = new ArrayList<>();


        String bqdf ="";
        String sqdf ="";
        String  bjdf ="";
        String WCGJRZBCITY ="";
        String WCGJRZBQX ="";
        String WCGJRZBFSCITY ="";
        String WCGJRZBFSQX ="";


        for(int i=0;i<data.size();i++){
            if(StringUtils.equals(data.get(i).get("QHJB"),"省级")){
                bqdf =data.get(i).get("WCGJRZB").toString();
            }
        }

        for(int i=0;i<sqdata.size();i++){
            if(StringUtils.equals(sqdata.get(i).get("QHJB"),"省级")){
                sqdf =sqdata.get(i).get("WCGJRZB").toString();
            }
        }

        Double bqdfob = Double.parseDouble(bqdf.substring(0,bqdf.length()-2));
        Double sqdfob = Double.parseDouble(sqdf.substring(0, sqdf.length() - 2));
        DecimalFormat    dfde  = new DecimalFormat("######0.00");
        bjdf =String.valueOf(dfde.format(bqdfob-sqdfob));//相差得分
        for(int i=0;i<data.size();i++){
            if(StringUtils.equals(data.get(i).get("QHJB"),"市级")){
                citydataList.add(data.get(i));
            }
        }

        for(int i=0;i<data.size();i++){
            if(StringUtils.equals(data.get(i).get("QHJB"),"县级")){
                qxdataList.add(data.get(i));
            }
        }

        Collections.sort(citydataList, new Comparator<Map<String,String>>() {

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                Double v1 = Double.valueOf(o1.get("WCGJRZB").toString().substring(0,o1.get("WCGJRZB").toString().length()-1));
                Double v2 = Double.valueOf(o2.get("WCGJRZB").toString().substring(0, o2.get("WCGJRZB").toString().length() - 1));
                if(v2 -v1 >=0){
                    return  1;
                }else{
                    return  -1;
                }
            }
        });


        Collections.sort(qxdataList, new Comparator<Map<String,String>>() {

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                Double v1 = Double.valueOf(o1.get("WCGJRZB").toString().substring(0, o1.get("WCGJRZB").toString().length() - 1));
                Double v2 = Double.valueOf(o2.get("WCGJRZB").toString().substring(0, o2.get("WCGJRZB").toString().length() - 1));

                if(v1 == null && v2 == null) {
                    return 0;
                }
                if(v1 == null) {
                    return -1;
                }
                if(v2 == null) {
                    return 1;
                }
                return 0;

            }
        });

        for(int i=0;i<citydataList.size();i++){
            if(i==0){
                Pjdfqk pd =new Pjdfqk();
                pd.setXzqhmc(citydataList.get(i).get("QHMC").toString());
                pd.setZb(Double.valueOf(citydataList.get(i).get("WCGJRZB").toString().substring(0,citydataList.get(i).get("WCGJRZB").toString().length()-1)));
                cityList.add(pd);   //未成功接入等薄量占比最高
            }
        }



        for(int i=0;i<qxdataList.size();i++){
            if(i>=0&&i<=2){
                Pjdfqk pd =new Pjdfqk();
                pd.setXzqhmc( qxdataList.get(i).get("QHMC").toString());
                pd.setZb(Double.valueOf(qxdataList.get(i).get("WCGJRZB").toString().substring(0, qxdataList.get(i).get("WCGJRZB").toString().length() - 1)));
                qxList.add(pd);
            }
        }

        for(int i=0;i<data.size();i++){
            if(StringUtils.equals(data.get(i).get("QHJB"), "市级")){
                //计算是否为负数
                if(countjrcglv(Double.valueOf(data.get(i).get("WCGJRZB").toString().substring(0, data.get(i).get("WCGJRZB").toString().length() - 1)))){
                      Map<String,String> CityMap =new HashMap<>();
                      CityMap.put("QHMC",data.get(i).get("QHMC").toString());
                      CityMap.put("WCGJRZB",data.get(i).get("WCGJRZB").toString());
                      cityListfs.add(CityMap);
                }
            }

            if(StringUtils.equals(data.get(i).get("QHJB"), "县级")){
                //计算是否为负数
                if(countjrcglv(Double.valueOf(data.get(i).get("WCGJRZB").toString().substring(0, data.get(i).get("WCGJRZB").toString().length() - 1)))){
                    Map<String,String> QxMap =new HashMap<>();
                    QxMap.put("QHMC",data.get(i).get("QHMC").toString());
                    QxMap.put("WCGJRZB",data.get(i).get("WCGJRZB").toString());
                    qxListfs.add(QxMap);
                }
            }
        }





        //返回前台数据组合
        Map<String, Object> resultLayuiMap = new HashMap<>();
        Map<String, String> resultMap = new HashMap<>();//最终返回的map

        resultMap.put("BQJRCGLV",bqdf);
        resultMap.put("SQJRCGLV",sqdf);
        resultMap.put("BJDF",bjdf+"%");


        for(Pjdfqk pd:cityList){
            WCGJRZBCITY =pd.getXzqhmc()+"&nbsp&nbsp"+"占比:"+pd.getZb();
        }

        for(int i=0;i<qxList.size();i++){
            WCGJRZBQX =WCGJRZBQX+qxList.get(i).getXzqhmc()+"&nbsp&nbsp"+"占比:"+qxList.get(i).getZb()+"%"+"\n";
        }

        if(CollectionUtils.isEmpty(cityListfs)){
            WCGJRZBFSCITY ="无";
        }
        else{
            for(Map<String,String> citymap:cityListfs){
                WCGJRZBFSCITY =WCGJRZBFSCITY+citymap.get("QHMC").toString()+"&nbsp&nbsp"+"占比:"+citymap.get("WCGJRZB").toString()+"\n";
            }
            WCGJRZBFSCITY="为负数的行政区名称:"+cityListfs.size()+"个,"+"分别为:"+"\n"+WCGJRZBFSCITY;
        }


        if(CollectionUtils.isEmpty(qxListfs)){
            WCGJRZBFSQX ="无";
        }
        else{
            for(Map<String,String> qxmap:qxListfs){
                WCGJRZBFSQX =WCGJRZBFSQX+qxmap.get("QHMC").toString()+"&nbsp&nbsp"+"占比:"+qxmap.get("WCGJRZB").toString()+"\n";
            }
            WCGJRZBFSQX="为负数的县级名称:"+qxListfs.size()+"个,"+"分别为:"+"\n"+WCGJRZBFSQX;
        }



//        未成功接入登簿量占比最高的市级行政区划
        resultMap.put("WCGJRZBCITY",WCGJRZBCITY+"%");
        //  未成功接入登簿量占比最高区县
        resultMap.put("WCGJRZBQX",WCGJRZBQX);
//        未成功接入登簿量占为负数市级行政区划名称及数量 （展示所有）；
        resultMap.put("WCGJRZBFSCITY",WCGJRZBFSCITY.substring(0,WCGJRZBFSCITY.length()-1));
//        未成功接入登簿量占为负数县级级行政区划名称及数量 （展示所有）；
        resultMap.put("WCGJRZBFSQX",WCGJRZBFSQX.substring(0,WCGJRZBFSQX.length()-1));


        List<Map<String, String>> resultList = new ArrayList<>();
        resultList.add(resultMap);
        resultLayuiMap.put("data", resultList);
        resultLayuiMap.put("code", 0);
        resultLayuiMap.put("msg", "");
        resultLayuiMap.put("count", resultList.size());

        return  resultLayuiMap;
    }


    public  Boolean countjrcglv(Double zb){
        if(zb<0){
            return  true;
        }
        return  false;

    }


    /**
     * 获取登薄质量得分情况 表格
     * @return
     */

    @ResponseBody
    @RequestMapping("/getDbzldfTable")
    public Object getDbzldfTable(String kssj,String jssj,String sqkssj,String sqjssj) {

        List<Pjdfqk> resultlsit = new ArrayList<>();
        Map<String, Object> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);


        Map<String, Object> sqparam = Maps.newHashMap();
        sqparam.put("kssj", sqkssj);
        sqparam.put("jssj", sqjssj);
        sqparam.put("provinceDm", region);


        String dbzlzhcity = ""; // dbzldf最好的市级名称
        String dbzlzccity = ""; //dbzldf最差的市级名称
        String dbzlzhqx = "";  //dbzldf最好的县级名称
        String dbzlzcqx = "";  //dbzldf最差的县级名称
        String dbzlgroupzhcity = ""; //dbzl得分上升最快的市级名称
        String dbzlgroupzccity = "";  //dbzl得分下降最快的市级名称

        String dbzlgroupzhqx = ""; //dbzl得分上升最快的县级名称
        String dbzlgroupzcqx = "";  //dbzl得分下降最快的县级名称

        Map<String, Object> resultLayuiMap = new HashMap<>();
        Map<String, String> resultMap = new HashMap<>();//最终返回的map
        List<Map<String, Object>> AllQXList = new ArrayList<>();
        Map<String, String> dbzlzhCity = new HashMap<>();//登薄质量最好的市级名称
        Map<String, String> dbzlzcCity = new HashMap<>();//登薄质量最差的市级名称
        ;//登薄质量最好的市级名称
        Map<String, String> dbzlzhQx = new HashMap<>();//登薄质量最好的县级名称
        Map<String, String> dbzlzcQx = new HashMap<>();//登薄质量最差的县级名称
        Map<String, String> dbzlgroupzhCity = new HashMap<>();
        Map<String, String> dbzlgroupzcCity = new HashMap<>();
        Map<String, String> dbzlgroupzhQx = new HashMap<>();
        Map<String, String> dbzlgroupzcQx = new HashMap<>();
        List<Map<String, Object>> ALLqxdataList = new ArrayList<>();


        List<Map<String, Object>> dataList = kxlService.listCityAndCountyDataFinal(param, false); //本期得分
        List<Map<String, Object>> sqdataList = kxlService.listCityAndCountyDataFinal(sqparam, false);  //上期得分



        String bqdf = dataList.get(0).get("ZHPF").toString(); //省本期得分
        String sqdf = sqdataList.get(0).get("ZHPF").toString(); //省上期得分
        Double bqdfob = Double.parseDouble(String.valueOf(dataList.get(0).get("ZHPF")));
        Double sqdfob = Double.parseDouble(String.valueOf(sqdataList.get(0).get("ZHPF")));
        Double bjdfxsd = bqdfob - sqdfob; //比较上期和本期
        String bjdf = String.format("%.2f", bjdfxsd);

        //区县 得分上升最大的城市
        for (int i = 0; i < dataList.size(); i++) {

            if (i == 0) {
                continue;
            }
            String sqzhpf = sqdataList.get(i).get("ZHPF").toString();
            String zhpf = dataList.get(i).get("ZHPF").toString();
            dataList.get(i).put("SQZHPF", sqzhpf);
            double sqzhpfDouble = Double.valueOf(sqzhpf);
            double zhpfdfDouble = Double.valueOf(zhpf);
            double bh = zhpfdfDouble - sqzhpfDouble;
            String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
            dataList.get(i).put("BHQK", bhqk);
            List<Map<String, Object>> qxdataList = (List<Map<String, Object>>) dataList.get(i).get("children");
            List<Map<String, Object>> sqqxdataList = (List<Map<String, Object>>) sqdataList.get(i).get("children");

           if (qxdataList != null){
               for (int j = 0; j < qxdataList.size(); j++) {
                   String sqzhpf1 = sqqxdataList.get(j).get("ZHPF").toString();
                   String zhpf1 = qxdataList.get(j).get("ZHPF").toString();
                   qxdataList.get(j).put("SQZHPF", sqzhpf1);
                   double sqzhpfDouble1 = Double.valueOf(sqzhpf1);
                   double zhpfdfDouble1 = Double.valueOf(zhpf1);
                   double bh1 = zhpfdfDouble1 - sqzhpfDouble1;
                   String bhqk1 = String.valueOf((double) Math.round(bh1 * 100) / 100);
                   qxdataList.get(j).put("BHQK", bhqk1);
                   AllQXList.add(qxdataList.get(j));
               }
           }
        }

        Collections.sort(AllQXList, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Double va1 = Double.valueOf(o1.get("BHQK").toString());
                Double va2 = Double.valueOf(o2.get("BHQK").toString());
                return va2.compareTo(va1);
            }
        });

        for (int i = 0; i < AllQXList.size(); i++) {
            if (i >= 0 && i <= 2) {
                String qhmc = AllQXList.get(i).get("QHMC").toString();
                dbzlgroupzhQx.put(String.valueOf(i), qhmc); //县级分数上升最大的
            }
            if (i < AllQXList.size() && i >= AllQXList.size() - 3) {
                String qhmc = AllQXList.get(i).get("QHMC").toString();
                dbzlgroupzcQx.put(String.valueOf(i), qhmc); //县级分数下降最大的
            }
        }


        //登簿质量最好的市级名称： ，得分最高的区县名称： （展示前3名）；
        dataList.remove(0);
        sqdataList.remove(0);

        Collections.sort(dataList, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Double va1 = Double.valueOf(o1.get("ZHPF").toString());
                Double va2 = Double.valueOf(o2.get("ZHPF").toString());
                return va2.compareTo(va1);
            }
        });

        //登薄质量最好的市级名称和最差的 按照得分算
        for (int i = 0; i < dataList.size(); i++) {
            if (i >= 0 && i <= 2) {
                String qhmc = dataList.get(i).get("QHMC").toString();
                dbzlzhCity.put(String.valueOf(i), qhmc);
            }
            if (i < dataList.size() && i >= dataList.size() - 3) {
                String qhmc = dataList.get(i).get("QHMC").toString();
                dbzlzcCity.put(String.valueOf(i), qhmc);
            }

        }

        //登薄质量最好的县级名称  和最差的 按照得分算
        for (int i = 0; i < dataList.size(); i++) {
            List<Map<String, Object>> qxdataList = (List<Map<String, Object>>) dataList.get(i).get("children");
            if(qxdataList != null){
                for (Map<String, Object> qx : qxdataList) {
                    ALLqxdataList.add(qx);
                }
            }
        }
        //对区县进行排序
        Collections.sort(ALLqxdataList, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Double va1 = Double.valueOf(o1.get("ZHPF").toString());
                Double va2 = Double.valueOf(o2.get("ZHPF").toString());
                return va2.compareTo(va1);
            }
        });

        for (int i = 0; i < ALLqxdataList.size(); i++) {
            if (i >= 0 && i <= 2) {
                String qhmc = ALLqxdataList.get(i).get("QHMC").toString();
                dbzlzhQx.put(String.valueOf(i), qhmc); //县级登薄质量最好的
            }
            if (i < ALLqxdataList.size() && i >= ALLqxdataList.size() - 3) {
                String qhmc = ALLqxdataList.get(i).get("QHMC").toString();
                dbzlzcQx.put(String.valueOf(i), qhmc); //县级登薄质量最差的
            }
        }


        for (int i = 0; i < dataList.size(); i++) {
            String sqzhpf = sqdataList.get(i).get("ZHPF").toString();
            String zhpf = dataList.get(i).get("ZHPF").toString();
            dataList.get(i).put("SQZHPF", sqzhpf);
            double sqzhpfDouble = Double.valueOf(sqzhpf);
            double zhpfdfDouble = Double.valueOf(zhpf);
            double bh = zhpfdfDouble - sqzhpfDouble;
            String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
            dataList.get(i).put("BHQK", bhqk); //全省分数
        }

        Collections.sort(dataList, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Double va1 = Double.valueOf(o1.get("BHQK").toString());
                Double va2 = Double.valueOf(o2.get("BHQK").toString());
                return va2.compareTo(va1);
            }
        });

        for (int i = 0; i < dataList.size(); i++) {
            if (i >= 0 && i <= 2) {
                String qhmc = dataList.get(i).get("QHMC").toString();
                dbzlgroupzhCity.put(String.valueOf(i), qhmc); //市级得分上升最大的
            }
            if (i < dataList.size() && i >= dataList.size() - 3) {
                String qhmc = dataList.get(i).get("QHMC").toString();
                dbzlgroupzcCity.put(String.valueOf(i), qhmc); //市级得分下降最大的
            }
        }


        resultMap.put("QSBQDF", bqdf); //本期得分
        resultMap.put("QSSQDF", sqdf); //上期得分
        resultMap.put("BJDF", bjdf);   //相差得分


        for (String dbzlzhmc : dbzlzhCity.values()) {   //登薄质量最好的城市名称
            dbzlzhcity = dbzlzhcity + dbzlzhmc + ",";
        }

        for (String dbzlzcmc : dbzlzcCity.values()) {      //登薄质量最差的城市名称
            dbzlzccity = dbzlzccity + dbzlzcmc + ",";
        }


        for (String dbzlzhmcqx : dbzlzhQx.values()) {   //登薄质量最好的县级名称

            dbzlzhqx = dbzlzhqx + dbzlzhmcqx + ",";
        }

        for (String dbzlzcmcqx : dbzlzcQx.values()) {   //登薄质量最差的县级名称
            dbzlzcqx = dbzlzcqx + dbzlzcmcqx + ",";

        }

        for (String dbzlgroupzhmc : dbzlgroupzhCity.values()) { //市级上升最大的名称
            dbzlgroupzhcity = dbzlgroupzhcity + dbzlgroupzhmc + ",";
        }

        for (String dbzlgroupzcmc : dbzlgroupzcCity.values()) {  //市级下降最大的名称
            dbzlgroupzccity = dbzlgroupzccity + dbzlgroupzcmc + ",";
        }


        for (String dbzlgroupzhmcqx : dbzlgroupzhQx.values()) { //县级上升最大的名称
            dbzlgroupzhqx = dbzlgroupzhqx + dbzlgroupzhmcqx + ",";
        }

        for (String dbzlgroupzcmcqx : dbzlgroupzcQx.values()) {  //县级下降最大的名称
            dbzlgroupzcqx = dbzlgroupzcqx + dbzlgroupzcmcqx + ",";

        }
        resultMap.put("DBZLZHCITY", dbzlzhcity.substring(0, dbzlzhcity.length() - 1));//
        resultMap.put("DBZLZCCITY", dbzlzccity.substring(0, dbzlzccity.length() - 1));//
        resultMap.put("DBZLZHQX", dbzlzhqx.substring(0, dbzlzhqx.length() - 1));//
        resultMap.put("DBZLZCQX", dbzlzcqx.substring(0, dbzlzcqx.length() - 1));//

        resultMap.put("DBZLGROUPZHCITY", dbzlgroupzhcity.substring(0, dbzlgroupzhcity.length() - 1));//
        resultMap.put("DBZLGROUPZCCITY", dbzlgroupzccity.substring(0, dbzlgroupzccity.length() - 1));//
        resultMap.put("DBZLGROUPZHQX", dbzlgroupzhqx.substring(0, dbzlgroupzhqx.length() - 1));//
        resultMap.put("DBZLGROUPZCQX", dbzlgroupzcqx.substring(0, dbzlgroupzcqx.length() - 1));//

        List<Map<String, String>> resultList = new ArrayList<>();
        resultList.add(resultMap);
        resultLayuiMap.put("data", resultList);
        resultLayuiMap.put("code", 0);
        resultLayuiMap.put("msg", "");
        resultLayuiMap.put("count", resultList.size());
        return resultLayuiMap;
    }

    @ResponseBody
    @RequestMapping("/getDbzldf")
    public Object getDbzl(String kssj,String jssj,String sqkssj,String sqjssj) {
        List<Pjdfqk> resultlsit = new ArrayList<>();
        Map<String, Object> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);


        Map<String, Object> sqparam = Maps.newHashMap();
        sqparam.put("kssj", sqkssj);
        sqparam.put("jssj", sqjssj);
        sqparam.put("provinceDm", region);


        List<Map<String, Object>> dataList = kxlService.listCityAndCountyDataFinal(param, false); //本期得分
        List<Map<String, Object>> sqdataList = kxlService.listCityAndCountyDataFinal(sqparam, false);  //上期得分
        dataList.remove(0);
        sqdataList.remove(0);

        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> citydata = dataList.get(i);
            Pjdfqk pf = new Pjdfqk();
            String xzqhmc = citydata.get("QHMC").toString();
            Object bqdfobj = citydata.get("ZHPF");
            double bqdf = Double.parseDouble(bqdfobj.toString());
            pf.setQhdm( citydata.get("CITY_QHDM").toString());
            pf.setXzqhmc(xzqhmc);
            pf.setBqdf(bqdf);
             List<Pjdfqk> childrenpf= new ArrayList<>();
            List<Map<String, Object>> childrenbqlist= (List<Map<String, Object>>) dataList.get(i).get("children");
            List<Map<String, Object>> childrensqlist= (List<Map<String, Object>>) sqdataList.get(i).get("children");

             for(int j=0;j<childrenbqlist.size();j++){
                 if(StringUtils.equals(pf.getQhdm(),childrenbqlist.get(j).get("CITY_QHDM").toString())){
                     Pjdfqk pjdfqkcd =new Pjdfqk();
                     pjdfqkcd.setQhdm(childrenbqlist.get(j).get("COUNTY_QHDM").toString());
                     pjdfqkcd.setFdm(childrenbqlist.get(j).get("CITY_QHDM").toString());
                     pjdfqkcd.setXzqhmc(childrenbqlist.get(j).get("QHMC").toString());

                     Object bqdfobjcd = childrenbqlist.get(j).get("ZHPF");
                     double bqdfcd = Double.parseDouble(bqdfobjcd.toString());//区县本期得分

                     Object sqdfocd = childrensqlist.get(j).get("ZHPF");
                     double sqdfcd = Double.parseDouble(sqdfocd.toString());

                     pjdfqkcd.setBqdf(bqdfcd);
                     pjdfqkcd.setSqdf(sqdfcd);

                     childrenpf.add(pjdfqkcd);
                 }
             }

            pf.setChildrens(childrenpf);
            resultlsit.add(pf);

        }

        for (int j = 0; j < resultlsit.size(); j++) {
            Map<String, Object> citysqdata = sqdataList.get(j);
            Object qsdfobj = citysqdata.get("ZHPF");
            double sqdf = Double.parseDouble(qsdfobj.toString());
            resultlsit.get(j).setSqdf(sqdf);

        }

        return resultlsit;
    }


    @ResponseBody
    @RequestMapping("/getJrwdxqk")
    public Object getJrwdxqk() {
        return null;
    }


    /**
     * 接入及时性 echarts tab 第5个
     * 本期
     * @return
     */
    @ResponseBody
    @RequestMapping("/getJrjsxqk")
    public Object getJrjsxqk(String kssj,String jssj) {
      return  jrdbzlpjService.getJrjsxqk(kssj,jssj);
    }

    /**
     * 接入及时性 echarts tab 第5个
     * 上期(echart)
     * @return
     */
    @ResponseBody
    @RequestMapping("/getJrjsxqksq")
    public Object getJrjsxqksq(String sqkssj,String sqjssj) {
        return  jrdbzlpjService.getJrjsxqk(sqkssj,sqjssj);
    }





    @ResponseBody
    @RequestMapping("/getJrjsxqkTabel")
    public Object getJrjsxqkTabel(String kssj,String jssj){

        Map<String, String> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);

        List<Map<String, String>> data = jrdbzlpjService.getJrzlpjData(param);
        Map<String, String> resultMap = new HashMap<>();//最终返回的map
        Map<String, Object> resultLayuiMap = new HashMap<>();

        List<Map<String, String>>  cityList = new ArrayList<>();

        List<Map<String, String>>  qxList = new ArrayList<>();
        List<String> resultJRDBL1ZBList =new ArrayList<>();
        List<String> resultJRDBL2ZBcityList =new ArrayList<>();
        List<String> resultJRDBL3ZBcityList =new ArrayList<>();

        List<Pjdfqk> resultJRDBL1ZBQXList =new ArrayList<>();
        List<Pjdfqk> resultJRDBL2ZBQXcityList =new ArrayList<>();
        List<Pjdfqk> resultJRDBL3ZBQXList =new ArrayList<>();

        String   JRDBL1ZBListCity="";
        String   JRDBL2ZBListCity="";
        String   JRDBL3ZBListCity="";


        String   JRDBL1ZBListQx="";
        String   JRDBL2ZBListQx="";
        String   JRDBL3ZBListQx="";



        //算地级市
        data.remove(0);
        for(int i=0;i < data.size();i++){
            if (StringUtils.equals(data.get(i).get("QHJB").toString(),"市级")){
                cityList.add(data.get(i));
            }
            if(StringUtils.equals(data.get(i).get("QHJB").toString(),"县级")){
                qxList.add(data.get(i));
            }
        }

        for(int i=0;i<cityList.size();i++){

            Double JRDBL1ZB = Double.valueOf(cityList.get(i).get("JRDBL1ZB").substring(0, cityList.get(i).get("JRDBL1ZB").length() - 1));
            Double JRDBL2ZB = Double.valueOf(cityList.get(i).get("JRDBL2ZB").substring(0, cityList.get(i).get("JRDBL2ZB").length() - 1));
            Double JRDBL3ZB = Double.valueOf(cityList.get(i).get("JRDBL3ZB").substring(0, cityList.get(i).get("JRDBL3ZB").length() - 1));

            if(calculatezlpj(JRDBL1ZB,"JRDBL1ZB")){
                resultJRDBL1ZBList.add(cityList.get(i).get("QHMC"));
            }
            if(calculatezlpj(JRDBL2ZB,"JRDBL2ZB")){
                resultJRDBL2ZBcityList.add(cityList.get(i).get("QHMC"));
            }

            if(calculatezlpj(JRDBL3ZB, "JRDBL3ZB")){
                resultJRDBL3ZBcityList.add(cityList.get(i).get("QHMC"));
            }
        }



        for(int i=0;i<qxList.size();i++){

            Double JRDBL1ZB = Double.valueOf(qxList.get(i).get("JRDBL1ZB").substring(0, qxList.get(i).get("JRDBL1ZB").length() - 1));
            Double JRDBL2ZB = Double.valueOf(qxList.get(i).get("JRDBL2ZB").substring(0, qxList.get(i).get("JRDBL2ZB").length() - 1));
            Double JRDBL3ZB = Double.valueOf(qxList.get(i).get("JRDBL3ZB").substring(0, qxList.get(i).get("JRDBL3ZB").length() - 1));

            if(calculatezlpj(JRDBL1ZB,"JRDBL1ZB")){
                Pjdfqk pf =new Pjdfqk();
                pf.setFdm(qxList.get(i).get("FDM"));
                pf.setXzqhmc(qxList.get(i).get("QHMC"));
                resultJRDBL1ZBQXList.add(pf);
            }
            if(calculatezlpj(JRDBL2ZB,"JRDBL2ZB")){
                Pjdfqk pf =new Pjdfqk();
                pf.setFdm(qxList.get(i).get("FDM"));
                pf.setXzqhmc(qxList.get(i).get("QHMC"));
                resultJRDBL2ZBQXcityList.add(pf);
            }

            if(calculatezlpj(JRDBL3ZB, "JRDBL3ZB")){
                Pjdfqk pf =new Pjdfqk();
                pf.setFdm(qxList.get(i).get("FDM"));
                pf.setXzqhmc(qxList.get(i).get("QHMC"));
                resultJRDBL3ZBQXList.add(pf);
            }
        }
        //新增需求
        //获取西安所有行政区划
        List<Map<String,String>> AllxtRegion = jrdbzlpjMapper.getAllDJRegion();
        JRDBL1ZBListQx  = getqxresult(AllxtRegion,resultJRDBL1ZBQXList);
        JRDBL2ZBListQx  = getqxresult(AllxtRegion,resultJRDBL2ZBQXcityList);
        JRDBL3ZBListQx  = getqxresult(AllxtRegion,resultJRDBL3ZBQXList);





        List<Map<String, String>> resultList = new ArrayList<>();

        for(int i=0;i<resultJRDBL1ZBList.size();i++){
            JRDBL1ZBListCity =JRDBL1ZBListCity+resultJRDBL1ZBList.get(i)+",";

        }
        for(int i=0;i<resultJRDBL2ZBcityList.size();i++){
            JRDBL2ZBListCity =JRDBL2ZBListCity+resultJRDBL2ZBcityList.get(i)+",";

        }
        for(int i=0;i<resultJRDBL3ZBcityList.size();i++){
            JRDBL3ZBListCity =JRDBL3ZBListCity+resultJRDBL3ZBcityList.get(i)+",";

        }

//        for(int i=0;i<resultJRDBL1ZBQXList.size();i++){
//
//            JRDBL1ZBListQx = JRDBL1ZBListQx+resultJRDBL1ZBQXList.get(i)+",";
//        }
//        for(int i=0;i<resultJRDBL2ZBQXcityList.size();i++){
//
//            JRDBL2ZBListQx = JRDBL2ZBListQx+resultJRDBL2ZBQXcityList.get(i)+",";
//        }
//        for(int i=0;i<resultJRDBL3ZBQXList.size();i++){
//
//            JRDBL3ZBListQx = JRDBL3ZBListQx+resultJRDBL3ZBQXList.get(i)+",";
//        }

        if(StringUtils.isNotEmpty(JRDBL1ZBListCity)){
            resultMap.put("JRDBZL1ZBCITY",JRDBL1ZBListCity.substring(0,JRDBL1ZBListCity.length()-1));
        }else{
            resultMap.put("JRDBZL1ZBCITY","无");
        }


        if(StringUtils.isNotEmpty(JRDBL2ZBListCity)){
            resultMap.put("JRDBZL2ZBCITY",JRDBL2ZBListCity.substring(0,JRDBL2ZBListCity.length()-1));
        }else{
            resultMap.put("JRDBZL2ZBCITY","无");
        }

        if(StringUtils.isNotEmpty(JRDBL3ZBListCity)){
            resultMap.put("JRDBZL3ZBCITY",JRDBL3ZBListCity.substring(0,JRDBL3ZBListCity.length()-1));
        }else{
            resultMap.put("JRDBZL3ZBCITY","无");
        }

        /*展现区县的3列*/
        if(StringUtils.isNotEmpty(JRDBL1ZBListQx)){
            resultMap.put("JRDBZL1ZBQx",JRDBL1ZBListQx);
        }else{
            resultMap.put("JRDBZL1ZBQx","无");
        }

        if(StringUtils.isNotEmpty(JRDBL2ZBListQx)){
            resultMap.put("JRDBZL2ZBQx",JRDBL2ZBListQx);
        }else{
            resultMap.put("JRDBZL2ZBQx","无");
        }

        if(StringUtils.isNotEmpty(JRDBL3ZBListQx)){
            resultMap.put("JRDBZL3ZBQx",JRDBL3ZBListQx);
        }else{
            resultMap.put("JRDBZL3ZBQx","无");
        }

        resultList.add(resultMap);
        resultLayuiMap.put("data", resultList);
        resultLayuiMap.put("code", 0);
        resultLayuiMap.put("msg", "");
        resultLayuiMap.put("count", resultList.size());


        return  resultLayuiMap;
    }


    public  String   getqxresult(List<Map<String,String>> AllxtRegion, List<Pjdfqk>resultJRDBL1ZBQXList  ){
        List<Pjdfqk>  qxresult = new ArrayList<>();
        String  jrdbzl ="";
        for(int i=0;i<AllxtRegion.size();i++){
            Pjdfqk  pf =new Pjdfqk();
            String  qhmclist ="";
            pf.setFdm(AllxtRegion.get(i).get("QHMC"));
            for(int j=0;j<resultJRDBL1ZBQXList.size();j++){
                if(StringUtils.equals(AllxtRegion.get(i).get("QHDM").toString(),resultJRDBL1ZBQXList.get(j).getFdm().toString())){
                    qhmclist =qhmclist+resultJRDBL1ZBQXList.get(j).getXzqhmc().toString()+",";
                }
            }
            if(""!=qhmclist){
                pf.setXzqhmc(qhmclist);
                qxresult.add(pf);
            }
        }
        //重新组装输出到前台
        for(int i=0;i<qxresult.size();i++){
            jrdbzl = jrdbzl +qxresult.get(i).getFdm()+":"+qxresult.get(i).getXzqhmc()+"\n";
        }

        return  jrdbzl;
    }

    /**
     * 按条件计算接入量
     * @param JRDBLZB
     * @param JRDBLZBType
     * @return
     */
    public  Boolean calculatezlpj(Double JRDBLZB,String JRDBLZBType){
        if(JRDBLZB <90 &&StringUtils.equals(JRDBLZBType,"JRDBL1ZB")){
            return  true;
        }
        if(JRDBLZB >10 &&StringUtils.equals(JRDBLZBType,"JRDBL2ZB")){
            return  true;
        }
        if(JRDBLZB >5 &&StringUtils.equals(JRDBLZBType,"JRDBL3ZB")){
            return  true;
        }
        return  false;
    }

    @ResponseBody
    @RequestMapping("/getJrzldfqk")
    public Object getJrzldfqk(String kssj,String jssj,String sqkssj,String sqjssj) {
//        第6个
        List<Pjdfqk> resultList = new ArrayList<>();
        Map<String, String> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);


        Map<String, String> sqparam = Maps.newHashMap();
        sqparam.put("kssj", sqkssj);
        sqparam.put("jssj", sqjssj);
        sqparam.put("provinceDm", region);


        List<Map<String, String>> data = jrdbzlpjService.getJrzlpjData(param);
        List<Map<String, String>> sqdata = jrdbzlpjService.getJrzlpjData(sqparam);
        data.remove(0);
        sqdata.remove(0);

        Map<String, Object> dataMap = getData(region, data);
        Map<String, Object> datasqMap = getData(region, sqdata);

        List<Map<String, String>> resultDf = (List<Map<String, String>>) dataMap.get("children");//本期
        List<Map<String, String>> resultsqDf = (List<Map<String, String>>) datasqMap.get("children");//上期

        for (int i = 0; i < resultDf.size(); i++) {
            Map<String, String> resultmap = resultDf.get(i);
            Map<String, String> resultsqmap = resultsqDf.get(i);
            Pjdfqk pd = new Pjdfqk();
            pd.setXzqhmc(resultmap.get("QHMC"));
            pd.setQhdm(resultmap.get("QHDM"));
            pd.setBqdf(Double.valueOf(resultmap.get("DF")));
            pd.setSqdf(Double.valueOf(resultsqmap.get("DF")));


            Map<String, Object> childrenMap = getData(pd.getQhdm(), data);
            Map<String, Object> chilsqdrenMap = getData(pd.getQhdm(), sqdata);
            List<Pjdfqk> childrenList =new ArrayList<>(); //children 地级市下面的children属性
            List<Map<String,Object>> children = (List<Map<String, Object>>) childrenMap.get("children");//获得区县的数据
            List<Map<String,Object>> childsqren = (List<Map<String, Object>>) chilsqdrenMap.get("children");//获得区县的数据
            for(int j=0;j<children.size();j++){
                Pjdfqk pkchildren =new Pjdfqk();
                pkchildren.setXzqhmc(children.get(j).get("QHMC").toString());
                pkchildren.setQhdm(children.get(j).get("QHDM").toString());
                pkchildren.setBqdf(Double.valueOf( children.get(j).get("DF").toString()));
                pkchildren.setSqdf(Double.valueOf(childsqren.get(j).get("DF").toString()));
//                pkchildren.setSqdf(Double.valueOf(childsqren.get("DF")));

                childrenList.add(pkchildren);
            }
            pd.setChildrens(childrenList);
            resultList.add(pd);
        }
        return resultList;
    }


    @ResponseBody
    @RequestMapping("/getJrzldfqkTabel")
    public Object getJrzldfqkTabel(String kssj,String jssj,String sqkssj,String sqjssj) {

        Map<String, String> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);


        Map<String, String> sqparam = Maps.newHashMap();
        sqparam.put("kssj", sqkssj);
        sqparam.put("jssj", sqjssj);
        sqparam.put("provinceDm", region);

        String jrzldfzhCitystr ="";
        String jrzldfzcCitystr ="";
        String jrzldfzhQxstr ="";
        String jrzldfzcQxstr ="";
        String jrzldfzhgroupCitystr ="";
        String jrzldfzcgroupCitystr ="";
        String jrzldfzhgroupQxstr ="";
        String jrzldfzcgroupQxstr ="";

        Map<String, String>  jrzldfzhCity = new HashMap<>();
        Map<String, String>  jrzldfzcCity = new HashMap<>();
        Map<String, String>  jrzldfzhQx = new HashMap<>();
        Map<String, String>  jrzldfzcQx = new HashMap<>();

        Map<String, String>  jrzldfgroupzhCity = new HashMap<>();
        Map<String, String>  jrzldfgroupzcCity = new HashMap<>();
        Map<String, String>  jrzldfgroupzhQx = new HashMap<>();
        Map<String, String>  jrzldfgroupzcQx = new HashMap<>();





        List<Map<String, String>> data = jrdbzlpjService.getJrzlpjData(param);
        List<Map<String, String>> sqdata = jrdbzlpjService.getJrzlpjData(sqparam);

        String bqdf = data.get(0).get("DF").toString(); //省本期得分
        String sqdf = sqdata.get(0).get("DF").toString(); //省上期得分
        Double bqdfob = Double.parseDouble(String.valueOf(data.get(0).get("DF")));
        Double sqdfob = Double.parseDouble(String.valueOf(sqdata.get(0).get("DF")));
        DecimalFormat    dfde  = new DecimalFormat("######0.00");
        String bjdf = String.valueOf(dfde.format(bqdfob-sqdfob));//比较上期和本期
        List<Map<String,String>> citylist =new ArrayList<>();
        List<Map<String,String>> qxlist =new ArrayList<>();

        data.remove(0);
        sqdata.remove(0);

        for(int i=0;i<data.size();i++){
            String sqdfcity = sqdata.get(i).get("DF");
            String df = data.get(i).get("DF");

            data.get(i).put("SQDF",sqdfcity);
            double sqdfDouble = Double.valueOf(sqdfcity);
            double dfDouble = Double.valueOf(df);
            double bh = dfDouble - sqdfDouble;

            String bhqk = String.valueOf( (double) Math.round(bh * 100) / 100);
            data.get(i).put("BHQK",bhqk);//算出比较得分
        }


        for(int i=0;i < data.size();i++){
            if(StringUtils.equals(data.get(i).get("QHJB").toString(),"市级")){
                citylist.add(data.get(i));
            }
            if(StringUtils.equals(data.get(i).get("QHJB").toString(),"县级")){
                qxlist.add(data.get(i));
            }
        }



        //市级
        Collections.sort(citylist, new Comparator<Map<String,String>>() {
            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                Double v1 = Double.valueOf(o1.get("DF").toString());
                Double v2 = Double.valueOf(o2.get("DF").toString());
                if(v2 >v1){
                    return  1;
                }else{
                    return  -1;
                }
            }
        });


        //区县
        Collections.sort(qxlist, new Comparator<Map<String,String>>() {
            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {

                Double v1 = Double.valueOf(o1.get("DF").toString());
                Double v2 = Double.valueOf(o2.get("DF").toString());
                if(v2>v1){
                    return  1;
                }else{
                    return  -1;
                }
            }
        });

        for(int i =0;i<citylist.size();i++){
            if(i>=0 && i<=2){
                jrzldfzhCity.put(String.valueOf(i),citylist.get(i).get("QHMC")); //市级pjzldf最好的市级
            }

            if (i < citylist.size() && i >= citylist.size() - 3) {
                jrzldfzcCity.put(String.valueOf(i),citylist.get(i).get("QHMC"));//市级pjzldf最差的市级
            }

        }


        for(int i =0;i<qxlist.size();i++){
            if(i>=0 && i<=2){
                jrzldfzhQx.put(String.valueOf(i),qxlist.get(i).get("QHMC"));//县级pjzldf最好的市级
            }

            if (i < qxlist.size() && i >= qxlist.size() - 3) {
                jrzldfzcQx.put(String.valueOf(i),qxlist.get(i).get("QHMC"));//县级pjzldf最好的市级
            }
        }

        //市级质量评价得分进步最大 和退步最大的

        //市级 进步退步得分
        Collections.sort(citylist, new Comparator<Map<String,String>>() {
            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                Double v1 = Double.valueOf(o1.get("BHQK").toString());
                Double v2 = Double.valueOf(o2.get("BHQK").toString());
                if(v2 >v1){
                    return  1;
                }else{
                    return  -1;
                }
            }
        });


        //区县 进步 退步
        Collections.sort(qxlist, new Comparator<Map<String,String>>() {
            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {

                Double v1 = Double.valueOf(o1.get("BHQK").toString());
                Double v2 = Double.valueOf(o2.get("BHQK").toString());
                if(v2 >v1){
                    return  1;
                }else{
                    return  -1;
                }
            }
        });


        //市级进步退步得分
        for(int i =0;i<citylist.size();i++){
            if(i>=0 && i<=2){
                jrzldfgroupzhCity.put(String.valueOf(i),citylist.get(i).get("QHMC")); //市级pjzldf最好的市级
            }

            if (i < citylist.size() && i >= citylist.size() - 3) {
                jrzldfgroupzcCity.put(String.valueOf(i), citylist.get(i).get("QHMC"));//市级pjzldf最差的市级
            }

        }


        //县级进步退步得分
        for(int i =0;i<qxlist.size();i++){
            if(i>=0 && i<=2){
                jrzldfgroupzhQx.put(String.valueOf(i), qxlist.get(i).get("QHMC")); //市级pjzldf最好的市级
            }

            if (i < qxlist.size() && i >= qxlist.size() - 3) {
                jrzldfgroupzcQx.put(String.valueOf(i),qxlist.get(i).get("QHMC"));//市级pjzldf最差的市级
            }

        }
        List<Map<String, String>> resultList = new ArrayList<>();


        Map<String, String> resultMap = new HashMap<>();//最终返回的map
        resultMap.put("QSBQDF", bqdf); //本期得分
        resultMap.put("QSSQDF", sqdf); //上期得分
        resultMap.put("BJDF", bjdf);   //相差得分

        for (String jrzzhmc : jrzldfzhCity.values()) {   //jr质量最好的城市名称
            jrzldfzhCitystr = jrzldfzhCitystr + jrzzhmc + ",";
        }

        for (String jrzzcmc : jrzldfzcCity.values()) {      //jr质量最差的城市名称
            jrzldfzcCitystr = jrzldfzcCitystr + jrzzcmc + ",";
        }


        for (String jrzhmcqx : jrzldfzhQx.values()) {   //jr质量最好的县级名称

            jrzldfzhQxstr = jrzldfzhQxstr + jrzhmcqx + ",";
        }

        for (String jrzcmcqx : jrzldfzcQx.values()) {   //jr质量最差的县级名称
            jrzldfzcQxstr = jrzldfzcQxstr + jrzcmcqx + ",";

        }

        for (String jrgroupzhmc : jrzldfgroupzhCity.values()) { //市级上升最大的名称
            jrzldfzhgroupCitystr = jrzldfzhgroupCitystr + jrgroupzhmc + ",";
        }

        for (String jrgroupzcmc : jrzldfgroupzcCity.values()) {  //市级下降最大的名称
            jrzldfzcgroupCitystr = jrzldfzcgroupCitystr + jrgroupzcmc + ",";
        }


        for (String jrgroupzhmcqx : jrzldfgroupzhQx.values()) { //县级上升最大的名称
            jrzldfzhgroupQxstr = jrzldfzhgroupQxstr + jrgroupzhmcqx + ",";
        }

        for (String jrgroupzcmcqx : jrzldfgroupzcQx.values()) {  //县级下降最大的名称
            jrzldfzcgroupQxstr = jrzldfzcgroupQxstr + jrgroupzcmcqx + ",";

        }
        resultMap.put("JRDFZHCITY", jrzldfzhCitystr.substring(0, jrzldfzhCitystr.length() - 1));//
        resultMap.put("JRDFZCCITY", jrzldfzcCitystr.substring(0, jrzldfzcCitystr.length() - 1));//
        resultMap.put("JRDFZHQX", jrzldfzhQxstr.substring(0, jrzldfzhQxstr.length() - 1));//
        resultMap.put("JEDFZCQX", jrzldfzcQxstr.substring(0, jrzldfzcQxstr.length() - 1));//

        resultMap.put("JRDFGROUPZHCITY", jrzldfzhgroupCitystr.substring(0, jrzldfzhgroupCitystr.length() - 1));//
        resultMap.put("JRDFGROUPZCCITY", jrzldfzcgroupCitystr.substring(0, jrzldfzcgroupCitystr.length() - 1));//
        resultMap.put("JRDFGROUPZHQX", jrzldfzhgroupQxstr.substring(0, jrzldfzhgroupQxstr.length() - 1));//
        resultMap.put("JRDFGROUPZCQX", jrzldfzcgroupQxstr.substring(0, jrzldfzcgroupQxstr.length() - 1));//


        Map<String, Object> resultLayuiMap = new HashMap<>();

        resultList.add(resultMap);
        resultLayuiMap.put("data", resultList);
        resultLayuiMap.put("code", 0);
        resultLayuiMap.put("msg", "");
        resultLayuiMap.put("count", resultList.size());

        return  resultLayuiMap;
    }

    /**
     * 计算 登薄日志空项率 echart
     *
     * @return
     */

    @ResponseBody
    @RequestMapping("/getJrkxlqk")
    public Object getJrkxlqk(String kssj,String jssj) {

        return  jrdbzlpjService.getJrkxlqk(kssj,jssj);
      }


    /**
     * 计算 登薄日志空项率 echart
     *
     * @return
     */

    @ResponseBody
    @RequestMapping("/getJrkxlqksq")
    public Object getJrkxlqksq(String sqkssj,String sqjssj) {

        return  jrdbzlpjService.getJrkxlqk(sqkssj,sqjssj);
    }

    /**
     * 计算空项率table
     * @return
     */
    @ResponseBody
    @RequestMapping("getJrkxlTable")
    public Object getJrkxlTable(String kssj,String jssj) {
        Object  jsondata = ReadJsonUtil.getJsonObjFromResource("/kxlzd.json");
        JSONObject jsonObject1 = JSON.parseObject(jsondata.toString());
        zdnameMap = (Map)JSON.parse(jsonObject1.toString());
        Map<String, String> kxlzdMap = new HashMap<>();
         Map<String, String> kxlzdQXMap = new HashMap<>();
        Map<String, Object> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);
        List<Kxlzd> cityList = new ArrayList<>();
        List<Kxlzd>  qxList = new ArrayList<>();
        List<Map<String, Object>> ALLqxdataList = new ArrayList<>();
        List<Map<String, String>> resultList = new ArrayList<>();
        Map<String, Object> resultLayuiMap = new HashMap<>();

        Map<String, String> resultMap = new HashMap<>();



        List<Map<String, Object>> data = kxlService.listCityAndCountyData(param, false);

        //空项率 100的地级市
        for (int i = 0; i < data.size(); i++) {
            if (i == 0) {
                continue;
            }
            kxlzdMap.put("DB_KXL", String.valueOf(data.get(i).get("DB_KXL")));
            kxlzdMap.put("FWFWXZ_KXL", String.valueOf(data.get(i).get("FWFWXZ_KXL")));
            kxlzdMap.put("FWGYQK_KXL", String.valueOf(data.get(i).get("FWGYQK_KXL")));
            kxlzdMap.put("FWJG_KXL", String.valueOf(data.get(i).get("FWJG_KXL")));
            kxlzdMap.put("FWXZ_KXL", String.valueOf(data.get(i).get("FWXZ_KXL")));
            kxlzdMap.put("GHYT_KXL", String.valueOf(data.get(i).get("GHYT_KXL")));
            kxlzdMap.put("GYQK_KXL", String.valueOf(data.get(i).get("GYQK_KXL")));
            kxlzdMap.put("JFDBR_KXL", String.valueOf(data.get(i).get("JFDBR_KXL")));
            kxlzdMap.put("JFDJSJ_KXL", String.valueOf(data.get(i).get("JFDJSJ_KXL")));
            kxlzdMap.put("JFJG_KXL", String.valueOf(data.get(i).get("JFJG_KXL")));
            kxlzdMap.put("JGSJ_KXL", String.valueOf(data.get(i).get("JGSJ_KXL")));
            kxlzdMap.put("JFWJ_KXL", String.valueOf(data.get(i).get("JFWJ_KXL")));
            kxlzdMap.put("JFYWH_KXL", String.valueOf(data.get(i).get("JFYWH_KXL")));
            kxlzdMap.put("QLSDFS_KXL", String.valueOf(data.get(i).get("QLSDFS_KXL")));
            kxlzdMap.put("QLXZ_KXL", String.valueOf(data.get(i).get("QLXZ_KXL")));
            kxlzdMap.put("RJL_KXL", String.valueOf(data.get(i).get("RJL_KXL")));
            kxlzdMap.put("YBDY_ZJDYFW_KXL", String.valueOf(data.get(i).get("YBDY_ZJDYFW_KXL")));
            kxlzdMap.put("YBDY_ZJDYZL_KXL", String.valueOf(data.get(i).get("YBDY_ZJDYZL_KXL")));
            kxlzdMap.put("YT_KXL", String.valueOf(data.get(i).get("YT_KXL")));
            kxlzdMap.put("YWRZJH_KXL", String.valueOf(data.get(i).get("YWRZJH_KXL")));
            kxlzdMap.put("YWRZJZL_KXL", String.valueOf(data.get(i).get("YWRZJZL_KXL")));
            kxlzdMap.put("ZGDY_ZJDYFW_KXL", String.valueOf(data.get(i).get("ZGDY_ZJDYFW_KXL")));
            kxlzdMap.put("ZGDY_ZJDYZL_KXL", String.valueOf(data.get(i).get("ZGDY_ZJDYZL_KXL")));
            kxlzdMap.put("ZGQQDSSSE_KXL", String.valueOf(data.get(i).get("ZGQQDSSSE_KXL")));
            kxlzdMap.put("ZWLXQX_KXL", String.valueOf(data.get(i).get("ZWLXQX_KXL")));
            kxlzdMap.put("ZXDYYY_KXL", String.valueOf(data.get(i).get("ZXDYYY_KXL")));
            kxlzdMap.put("ZXSJ_KXL", String.valueOf(data.get(i).get("ZXSJ_KXL")));
            Set kxlset = kxlzdMap.keySet();
            Kxlzd zd =new Kxlzd();
            zd.setQhmc(data.get(i).get("QHMC").toString());
            List<String> zdlist =new ArrayList<>();
            for(Iterator iter = kxlset.iterator(); iter.hasNext();)
            {
                String kxlkey = (String)iter.next();
                String kxlvalue = kxlzdMap.get(kxlkey);
                if(StringUtils.equals(kxlvalue,"100.00%")){
                    String zwname =findname(kxlkey);
                    zdlist.add(zwname);
                }
            }
            zd.setZdmc(zdlist);
            cityList.add(zd);
        }

        data.remove(0);

        for (int i = 0; i < data.size(); i++) {
            List<Map<String, Object>> qxdataList = (List<Map<String, Object>>) data.get(i).get("children");
           if(qxdataList != null){
               for (Map<String, Object> qxcs : qxdataList) {
                   ALLqxdataList.add(qxcs);
               }
           }
        }

//        kxlzdQXMap

        for (int j = 0; j < ALLqxdataList.size(); j++) {
            kxlzdQXMap.put("DB_KXL", String.valueOf(ALLqxdataList.get(j).get("DB_KXL")));
            kxlzdQXMap.put("FWFWXZ_KXL", String.valueOf(ALLqxdataList.get(j).get("FWFWXZ_KXL")));
            kxlzdQXMap.put("FWGYQK_KXL", String.valueOf(ALLqxdataList.get(j).get("FWGYQK_KXL")));
            kxlzdQXMap.put("FWJG_KXL", String.valueOf(ALLqxdataList.get(j).get("FWJG_KXL")));
            kxlzdQXMap.put("FWXZ_KXL", String.valueOf(ALLqxdataList.get(j).get("FWXZ_KXL")));
            kxlzdQXMap.put("GHYT_KXL", String.valueOf(ALLqxdataList.get(j).get("GHYT_KXL")));
            kxlzdQXMap.put("GYQK_KXL", String.valueOf(ALLqxdataList.get(j).get("GYQK_KXL")));
            kxlzdQXMap.put("JFDBR_KXL", String.valueOf(ALLqxdataList.get(j).get("JFDBR_KXL")));
            kxlzdQXMap.put("JFDJSJ_KXL", String.valueOf(ALLqxdataList.get(j).get("JFDJSJ_KXL")));
            kxlzdQXMap.put("JFJG_KXL", String.valueOf(ALLqxdataList.get(j).get("JFJG_KXL")));
            kxlzdQXMap.put("JGSJ_KXL", String.valueOf(ALLqxdataList.get(j).get("JGSJ_KXL")));
            kxlzdQXMap.put("JFWJ_KXL", String.valueOf(ALLqxdataList.get(j).get("JFWJ_KXL")));
            kxlzdQXMap.put("JFYWH_KXL", String.valueOf(ALLqxdataList.get(j).get("JFYWH_KXL")));
            kxlzdQXMap.put("QLSDFS_KXL", String.valueOf(ALLqxdataList.get(j).get("QLSDFS_KXL")));
            kxlzdQXMap.put("QLXZ_KXL", String.valueOf(ALLqxdataList.get(j).get("QLXZ_KXL")));
            kxlzdQXMap.put("RJL_KXL", String.valueOf(ALLqxdataList.get(j).get("RJL_KXL")));
            kxlzdQXMap.put("YBDY_ZJDYFW_KXL", String.valueOf(ALLqxdataList.get(j).get("YBDY_ZJDYFW_KXL")));
            kxlzdQXMap.put("YBDY_ZJDYZL_KXL", String.valueOf(ALLqxdataList.get(j).get("YBDY_ZJDYZL_KXL")));
            kxlzdQXMap.put("YT_KXL", String.valueOf(ALLqxdataList.get(j).get("YT_KXL")));
            kxlzdQXMap.put("YWRZJH_KXL", String.valueOf(ALLqxdataList.get(j).get("YWRZJH_KXL")));
            kxlzdQXMap.put("YWRZJZL_KXL", String.valueOf(ALLqxdataList.get(j).get("YWRZJZL_KXL")));
            kxlzdQXMap.put("ZGDY_ZJDYFW_KXL", String.valueOf(ALLqxdataList.get(j).get("ZGDY_ZJDYFW_KXL")));
            kxlzdQXMap.put("ZGDY_ZJDYZL_KXL", String.valueOf(ALLqxdataList.get(j).get("ZGDY_ZJDYZL_KXL")));
            kxlzdQXMap.put("ZGQQDSSSE_KXL", String.valueOf(ALLqxdataList.get(j).get("ZGQQDSSSE_KXL")));
            kxlzdQXMap.put("ZWLXQX_KXL", String.valueOf(ALLqxdataList.get(j).get("ZWLXQX_KXL")));
            kxlzdQXMap.put("ZXDYYY_KXL", String.valueOf(ALLqxdataList.get(j).get("ZXDYYY_KXL")));
            kxlzdQXMap.put("ZXSJ_KXL", String.valueOf(ALLqxdataList.get(j).get("ZXSJ_KXL")));

            Set kxlset = kxlzdQXMap.keySet();
            Kxlzd zd =new Kxlzd();
            zd.setQhmc(ALLqxdataList.get(j).get("QHMC").toString());
            List<String> zdlist =new ArrayList<>();
            for(Iterator iter = kxlset.iterator(); iter.hasNext();)
            {
                String kxlkey = (String)iter.next();
                String kxlvalue = kxlzdQXMap.get(kxlkey);
                if(StringUtils.equals(kxlvalue,"100.00%")){
                    String zwname =findname(kxlkey);
                    zdlist.add(zwname);
                }

            }
            zd.setZdmc(zdlist);
            qxList.add(zd);

        }





        String resultcitykxl = "";
        List<Kxlzd> resultCity =new ArrayList<>();
        if (CollectionUtils.isNotEmpty(cityList)) {

            for (String value : zdnameMap.values()) {
                String citykxl = "";
                Kxlzd kd = new Kxlzd();
                kd.setResultzdmc(value);
                for (int j = 0; j < cityList.size(); j++) {
                    List<String> zdnames = cityList.get(j).getZdmc();
                    for (String ZD : zdnames) {
                        if (value.equals(ZD)) {
                            citykxl = citykxl + cityList.get(j).getQhmc() + ",";
                        }
                    }
                }
                kd.setQhmc(citykxl);
                resultCity.add(kd);

            }



            for (int i = 0; i < resultCity.size(); i++) {
                if (resultCity.get(i).getQhmc() != "") {
                    resultcitykxl = resultcitykxl + resultCity.get(i).getResultzdmc() + ":" + resultCity.get(i).getQhmc();
                }
            }
            if (resultcitykxl != "") {
                resultMap.put("KXLZDCITY", resultcitykxl.substring(0, resultcitykxl.length() - 1));
            } else {
                resultMap.put("KXLZDCITY", "");
            }

        }


//        } else {
//            resultMap.put("KXLZDCITY", "无");
//        }

         //区县空项率字段和行政区划名称
        String resultqxkxl = "";
        List<Kxlzd> resultQX =new ArrayList<>();
        if (CollectionUtils.isNotEmpty(qxList)) {



            for (String value : zdnameMap.values()) {
                String qxkxl = "";
                Kxlzd  kd = new Kxlzd();
                kd.setResultzdmc(value);
                for(int j=0;j<qxList.size();j++){
                    List<String> zdnames =qxList.get(j).getZdmc();
                    for(String ZD:zdnames){
                        if(value.equals(ZD)){
                            qxkxl =qxkxl+qxList.get(j).getQhmc()+",";
                        }
                    }
                }
                kd.setQhmc(qxkxl);
                resultQX.add(kd);
            }
            for(int i=0;i<resultQX.size();i++){
                if(resultQX.get(i).getQhmc()!=""){
                    resultqxkxl =resultqxkxl+resultQX.get(i).getResultzdmc()+":"+resultQX.get(i).getQhmc();
                }
            }
            if(resultqxkxl!=""){
                resultMap.put("KXLZDQX", resultqxkxl.substring(0, resultqxkxl.length() - 1));
            }
            else {
                resultMap.put("KXLZDQX", "");
            }

        }
        resultList.add(resultMap);
        resultLayuiMap.put("data", resultList);
        resultLayuiMap.put("code", 0);
        resultLayuiMap.put("msg", "");
        resultLayuiMap.put("count", resultList.size());

        return resultLayuiMap;
    }

    @ResponseBody
    @RequestMapping("/getJrsbqk")
    public Object getJrsbqk() {



        List<Map<String, String>> regioncityMap = baTjfxMapper.getresgionbyqhjb();
        List<Map<String, String>> jrsbqkMap = baTjfxMapper.getjrsb();


        List<Pjdfqk> resultMap = new ArrayList<>();
        Integer sumcg = 0;
        Integer sumsb = 0;
        String  resultqhmc = null;
        for (int i = 0; i < regioncityMap.size(); i++) {
            String qhdm = regioncityMap.get(i).get("QHDM").toString();
            for (int j = 0; j < jrsbqkMap.size(); j++) {
                if (qhdm.equals(jrsbqkMap.get(j).get("FDM").toString())) {
                    resultqhmc =regioncityMap.get(i).get("QHMC").toString();;
                    //求成成功的个数
                    Object objectSBjg = jrsbqkMap.get(j).get("SBJG");
                    if(""!=objectSBjg && null!=objectSBjg) {
                        if ("成功".equals(jrsbqkMap.get(j).get("SBJG").toString())) {
                            Object objectJg = jrsbqkMap.get(j).get("JG");
                            if (""!=jrsbqkMap.get(j).get("JG")) {
                                sumcg = sumcg + Integer.parseInt(String.valueOf(objectJg));
                            }
                        }
                        //失败个数
                        else {
                            Object objectJg = jrsbqkMap.get(j).get("JG");
                            if (""!=jrsbqkMap.get(j).get("JG")) {
                                sumsb = sumsb + Integer.parseInt(String.valueOf(objectJg));
                            }
                        }
                    }

                }

            }
            if(StringUtils.isNotEmpty(resultqhmc)){
                Pjdfqk Pd = new Pjdfqk();
                Pd.setXzqhmc(resultqhmc);
                Pd.setSqsbcg(sumcg);
                Pd.setBqsbsb(sumsb);
                resultMap.add(Pd);
            }
        }
        return resultMap;
    }





    public  String  findname(String ywname){
        String zwname ="";
        for(String key : zdnameMap.keySet()) {
            if(StringUtils.equals(key,ywname)){
                zwname = zdnameMap.get(key);
            }

//            String value = zdnameMap.get(key);
//            System.out.println(key + " " + value);
        }
        return  zwname;
    }


    /**
     * 计算kxl字段个数 按范围计算
     *
     * @param
     * @param
     * @return 计算分值个数 按范围
     */

    public Map<String, Integer> calculatekxl(Map<String, String> kxlMap) {
        Integer manfengs = 0;
        Integer sdgegs = 0;
        Integer zdgs = 0;
        Integer jigegs = 0;
        Integer linfengs = 0;
        Map<String, Integer> calculateresult = new HashMap<>();
        for (String reuslt : kxlMap.values()) {
            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) == 100) {
                manfengs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) >= 80 && Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) < 100) {
                sdgegs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) >= 50 && Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) < 80) {
                zdgs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) > 0 && Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) < 50) {
                jigegs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) == 0) {
                linfengs++;
            }

        }
        calculateresult.put("manfengs", manfengs);
        calculateresult.put("sdgegs", sdgegs);
        calculateresult.put("zdgs", zdgs);
        calculateresult.put("jigegs", jigegs);
        calculateresult.put("linfengs", linfengs);

        return calculateresult;
    }

    /**
     * 统计全省市县区划代码和区划名称对应
     * @return 计算分值个数 按范围
     */
    @ResponseBody
    @RequestMapping("/obtainAllRegion")
    public  List<Map<String,String>> obtainAllRegion(){
        List<Map<String,String>> mapList = jrdbzlpjMapper.getAllRegion();
        return mapList;
    }

    /**
     * 接入稳定性数据tab4
     * @param kssj,jssj,sqkssj,sqjssj
     * @return
     */
    @ResponseBody
    @RequestMapping("/jrwdxData")
    public Map<String ,Object> jrwdxData(String kssj,String jssj){
        List<Map<String,String>> mapList = jrdbzlpjMapper.getAllRegion();
        Map<String,String> qhmcMap = new HashMap<>();
        Map<String,String> dsMap = new HashMap<>();
        List<Map<String,String>> dsList = jrdbzlpjMapper.getDs(region);

        Map<String,String> qxMap = new HashMap<>();
        List<Map<String,String>> qxList = jrdbzlpjMapper.getQx();

        //区划代码对应区划名称  qhmc[qhdm]
        for(Map<String,String> map : mapList){
            qhmcMap.put(map.get("QHDM"),map.get("QHMC"));
        }
        for(Map<String,String> map : dsList){
            dsMap.put(map.get("QHDM"),map.get("QHMC"));
        }
        for(Map<String,String> map : qxList){
            qxMap.put(map.get("QHDM"),map.get("QHMC"));
        }
        Map<String,Object> resultList = new HashMap<>();
        Map<String,String> param = new HashMap<>();

        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        }else {
            param.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-30), "yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        }else {
            param.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(0), "yyyy-MM-dd"));
        }
//        param.put("kssj","20190501");
//        param.put("jssj","20191201");
        Map<String,Object> map = jrdbzlpjService.jrwdxData(param);

        //获取接入稳定性所有数据
        List<Map<String,String>> wjrdbrzQxData = (List<Map<String,String>>) map.get("wjrdbrzQxResultData");

        List<Map<String,String>> wjrbwQxData = (List<Map<String,String>>) map.get("wjrbwQxResultData");

        List<Map<String,String>> dblIsZeroQxData = (List<Map<String,String>>) map.get("dblIsZeroQxResultData");

        List<Map<String,String>> dsData = (List<Map<String,String>>) map.get("dsData");


        Map<String ,String> tableMap = new HashMap<>();

        //table数据
        String WJRDBRZSJ = "";
        String WJRBWSJ = "";
        String DBLWLSJ = "";
        String WJRDBRZQX = "";
        String WJRBWQX = "";
        String DBLWLQX = "";

        //装载table大市数据,去掉为零的地市
        for(Map map1 :dsData){
            String str1 = map1.get("QHMC") + ":" + map1.get("wjrdbrzTS") + "天  ";
            String str2 = map1.get("QHMC") + ":" + map1.get("wjrbwTS") + "天  ";
            String str3 = map1.get("QHMC") + ":" + map1.get("dblIsZeroTS") + "天  ";

            if(!"0".equals(map1.get("wjrdbrzTS").toString())){
                WJRDBRZSJ += str1;
            }

            if(!"0".equals(map1.get("wjrbwTS").toString())){
                WJRBWSJ += str2;
            }

            if(!"0".equals(map1.get("dblIsZeroTS").toString())){
                DBLWLSJ += str3;
            }
        }

        tableMap.put("WJRDBRZSJ",WJRDBRZSJ);
        tableMap.put("WJRBWSJ",WJRBWSJ);
        tableMap.put("DBLWLSJ",DBLWLSJ);

        //exharts数据
        Map<String,String> rzwjrData = new HashMap<>();
        Map<String,String> bwwjrData = new HashMap<>();
        Map<String,String> dbIsZeroData = new HashMap<>();

        Map<String,String> rzwjrQxData = new HashMap<>();
        Map<String,String> bwwjrQxData = new HashMap<>();
        Map<String,String> dbIsZeroQxData = new HashMap<>();

        //装载echarts大市数据
        for(Map map1 :dsData){
            rzwjrData.put(map1.get("QHDM").toString(),map1.get("wjrdbrzTS").toString());
            bwwjrData.put(map1.get("QHDM").toString(),map1.get("wjrbwTS").toString());
            dbIsZeroData.put(map1.get("QHDM").toString(),map1.get("dblIsZeroTS").toString());
        }

        //装载table区县数据 和echarts区县数据
        for(Map map1 : wjrdbrzQxData){
            String str = map1.get("QHMC") + ":" + map1.get("TS") + "天  ";
            if(!"0".equals(map1.get("TS").toString())){
                WJRDBRZQX += str;
            }
            rzwjrQxData.put(map1.get("QHDM").toString(),map1.get("TS").toString());
        }

        for(Map map1 : wjrbwQxData){
            String str = map1.get("QHMC") + ":" + map1.get("TS") + "天  ";
            if(!"0".equals(map1.get("TS").toString())){
                WJRBWQX += str;
            }
            bwwjrQxData.put(map1.get("QHDM").toString(),map1.get("TS").toString());
        }

        for(Map map1 : dblIsZeroQxData){
            String str = map1.get("QHMC") + ":" + map1.get("TS") + "天  ";
            if(!"0".equals(map1.get("TS").toString())){
                DBLWLQX += str;
            }
            dbIsZeroQxData.put(map1.get("QHDM").toString(),map1.get("TS").toString());
        }

        tableMap.put("WJRDBRZQX",WJRDBRZQX);
        tableMap.put("WJRBWQX",WJRBWQX);
        tableMap.put("DBLWLQX",DBLWLQX);

        resultList.put("rzwjrData",rzwjrData );
        resultList.put("bwwjrData",bwwjrData);
        resultList.put("dbIsZeroData",dbIsZeroData );

        resultList.put("rzwjrQxData",rzwjrQxData );
        resultList.put("bwwjrQxData",bwwjrQxData);
        resultList.put("dbIsZeroQxData",dbIsZeroQxData );

        resultList.put("tableMap",tableMap );
        resultList.put("dsList",dsMap);
        return resultList;
    }

    /**
     * 接入成功率 tab7
     * @param kssj,jssj,sqkssj,sqjssj
     * @return
     */
    @ResponseBody
    @RequestMapping("/obtainJrcgl")
    public Map<String ,Object> obtainJrcgl(String kssj,String jssj,String sqkssj,String sqjssj){
        Map<String,String> param = new HashMap<>(5);
        Map<String,String> sqparam = new HashMap<>(5);
        List<Map<String,String>> mapList = jrdbzlpjMapper.getAllRegion();
        Map<String,String> qhmcMap = new HashMap<>(5);
        for(Map<String,String> map : mapList){
            qhmcMap.put(map.get("QHDM"),map.get("QHMC"));
        }

        Map<String,String> dsMap = new HashMap<>(5);
        List<Map<String,String>> dsList = jrdbzlpjMapper.getDs(region);
        for(Map<String,String> map : dsList){
            dsMap.put(map.get("QHDM"),map.get("QHMC"));
        }

        Map<String,String> tableMap = new HashMap<>(5);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        }else {
            param.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-30), "yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        }else {
            param.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(0), "yyyy-MM-dd"));
        }

        if (StringUtils.isNotBlank(sqkssj)) {
            sqparam.put("kssj", sqkssj);
        }else {
            sqparam.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-60), "yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(sqjssj)) {
            sqparam.put("jssj", sqjssj);
        }else {
            sqparam.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-29), "yyyy-MM-dd"));
        }

        //获取报文接入数据,表格数据添%
        Map<String,Object> resultList  = jrdbzlpjService.getJrcgl(param);
        List<Map<String,String>> provinceData = baTjfxMapper.getProvinceJrcg(sqparam);
        Map<String,String> lastProvinceData = getJRCgl(provinceData);
        tableMap.put("QSSQJR",lastProvinceData.get("provinceData") + "%");

        List<Map<String,String>> bqProvinceData = ( List<Map<String,String>>)resultList.get("provinceData");
        Map<String,String> thisProvinceData = bqProvinceData.get(0);
        tableMap.put("QSBQJR",thisProvinceData.get("provinceData") + "%");
        Double d = (Double.parseDouble(thisProvinceData.get("provinceData"))-Double.parseDouble(lastProvinceData.get("provinceData")));
        tableMap.put("BH", (double)Math.round(d*100)/100 + "%");

        List<Map<String,Double>> resultListQs = new ArrayList<>();
        List<Map<String,Double>> resultListHs = new ArrayList<>();

        Object qxobj =resultList.get("qxData");
        Object dsobj =resultList.get("dsData");
        List<Map<String,Double>> qxlists = (List<Map<String,Double>>) qxobj;
        Map<String,Double> mapNumQX = new HashMap<>(5);

        List<Map<String,Double>> dslists = (List<Map<String,Double>>) dsobj;
        Map<String,Double> mapNumDs = new HashMap<>(5);

        for(Map map :qxlists){
            for (Object key : map.keySet()) {
                mapNumQX.put(key.toString(),Double.parseDouble(map.get(key).toString()));
            }
        }

        for(Map map :dslists){
            for (Object key : map.keySet()) {
                mapNumDs.put(key.toString(),Double.parseDouble(map.get(key).toString()));
            }
        }

        int flagNum = 0;
        //数据通过value排序,取区县前三后三数据,取大市第一最后数据
        Map<String,Double> mapNum1 = sortByValue(mapNumQX);
        for (Object key : mapNum1.keySet()) {
            Map<String,Double> ss = new HashMap<>(5);
            ss.put(key.toString(),Double.parseDouble(mapNumQX.get(key).toString()));
            resultListHs.add(ss);
            flagNum++;
            if(flagNum==3){
                break;
            }
        }

        Map<String,Double> mapNum2 = sortReverseByValue(mapNumQX);
        for (Object key : mapNum2.keySet()) {
            Map<String,Double> ss = new HashMap<>(5);
            ss.put(key.toString(),Double.parseDouble(mapNumQX.get(key).toString()));
            resultListQs.add(ss);
            flagNum++;
            if(flagNum==6){
                break;
            }
        }

        Map<String,Double> mapNum3 = sortByValue(mapNumDs);
        for (Object key : mapNum3.keySet()) {
            String str = qhmcMap.get(key) + ":" + mapNumDs.get(key);
            tableMap.put("BWJRZDDS",str + "%");

            break;
        }

        Map<String,Double> mapNum4 = sortReverseByValue(mapNumDs);
        for (Object key : mapNum4.keySet()) {
            String str = qhmcMap.get(key) + ":" + mapNumDs.get(key);
            tableMap.put("BWJRZGDS",str + "%");
            break;
        }
//        tableMap.put("BWJRZGDS",thisProvinceData.get("provinceData") + "%");
        String BWJRZGQX = "";
        for(Map<String,Double> map : resultListQs){
            for (Object key : map.keySet()) {
                BWJRZGQX += qhmcMap.get(key) + ":" + map.get(key) + "% ";
            }
        }
        tableMap.put("BWJRZGQX",BWJRZGQX );

        String BWJRZDQX = "";
        for(Map<String,Double> map : resultListHs){
            for (Object key : map.keySet()) {
                BWJRZDQX += qhmcMap.get(key) + ":" + map.get(key) + "%  ";
            }
        }
        tableMap.put("BWJRZDQX",BWJRZDQX);

        resultList.put("tableMap",tableMap);
        return resultList;
    }

    /**
     * 上报成功率 tab8
     * @param kssj,jssj,sqkssj,sqjssj
     * @return
     */
    @ResponseBody
    @RequestMapping("/obtainSbcgl")
    public Map<String ,Object> obtainSbcgl(String kssj,String jssj,String sqkssj,String sqjssj){
        Map<String,String> param = new HashMap<>(5);
        Map<String,String> sqparam = new HashMap<>(5);
        List<Map<String,String>> mapList = jrdbzlpjMapper.getAllRegion();
        Map<String,String> qhmcMap = new HashMap<>(5);
        for(Map<String,String> map : mapList){
            qhmcMap.put(map.get("QHDM"),map.get("QHMC"));
        }

        Map<String,String> dsMap = new HashMap<>(5);
        List<Map<String,String>> dsList = jrdbzlpjMapper.getDs(region);
        for(Map<String,String> map : dsList){
            dsMap.put(map.get("QHDM"),map.get("QHMC"));
        }

        Map<String,String> tableMap = new HashMap<>(5);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        }else {
            param.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-30), "yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        }else {
            param.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(0), "yyyy-MM-dd"));
        }

        if (StringUtils.isNotBlank(sqkssj)) {
            sqparam.put("kssj", sqkssj);
        }else {
            param.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-60), "yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(sqjssj)) {
            sqparam.put("jssj", sqjssj);
        }else {
            param.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-29), "yyyy-MM-dd"));
        }
//        param.put("kssj","20190501");
//        param.put("jssj","20191201");
//
//        sqparam.put("kssj","20190101");
//        sqparam.put("jssj","20190501");
        Map<String,Object> resultList  = jrdbzlpjService.getSbcgl(param);
        List<Map<String,String>> provinceData = baTjfxMapper.getProvinceJrsb(sqparam);
        Map<String,String> lastProvinceData = getSBCgl(provinceData);
        tableMap.put("QSSQSB",lastProvinceData.get("provinceData") + "%");

        List<Map<String,String>> bqProvinceData = ( List<Map<String,String>>)resultList.get("provinceData");
        Map<String,String> thisProvinceData = bqProvinceData.get(0);
        tableMap.put("QSBQSB",thisProvinceData.get("provinceData") + "%");
        Double d = (Double.parseDouble(thisProvinceData.get("provinceData"))-Double.parseDouble(lastProvinceData.get("provinceData")));
        tableMap.put("BH", (double)Math.round(d*100)/100 + "%");


        List<Map<String,Double>> resultListQs = new ArrayList<>();
        List<Map<String,Double>> resultListHs = new ArrayList<>();

        Object qxobj =resultList.get("qxData");
        Object dsobj =resultList.get("dsData");
        List<Map<String,Double>> qxlists = (List<Map<String,Double>>) qxobj;
        Map<String,Double> mapNumQX = new HashMap<>(5);

        List<Map<String,Double>> dslists = (List<Map<String,Double>>) dsobj;
        Map<String,Double> mapNumDs = new HashMap<>(5);

        for(Map map :qxlists){
            for (Object key : map.keySet()) {
                mapNumQX.put(key.toString(),Double.parseDouble(map.get(key).toString()));
            }
        }

        for(Map map :dslists){
            for (Object key : map.keySet()) {
                mapNumDs.put(key.toString(),Double.parseDouble(map.get(key).toString()));
            }
        }

        int flagNum = 0;
        Map<String,Double> mapNum1 = sortByValue(mapNumQX);
        for (Object key : mapNum1.keySet()) {
            Map<String,Double> ss = new HashMap<>(5);
            ss.put(key.toString(),Double.parseDouble(mapNumQX.get(key).toString()));
            resultListHs.add(ss);
            flagNum++;
            if(flagNum==3){
                break;
            }
        }

        Map<String,Double> mapNum2 = sortReverseByValue(mapNumQX);
        for (Object key : mapNum2.keySet()) {
            Map<String,Double> ss = new HashMap<>(5);
            ss.put(key.toString(),Double.parseDouble(mapNumQX.get(key).toString()));
            resultListQs.add(ss);
            flagNum++;
            if(flagNum==6){
                break;
            }
        }

        Map<String,Double> mapNum3 = sortByValue(mapNumDs);
        for (Object key : mapNum3.keySet()) {
            String str = qhmcMap.get(key) + ":" + mapNumDs.get(key);
            tableMap.put("BWSBZDDS",str + "%");
            break;
        }

        Map<String,Double> mapNum4 = sortReverseByValue(mapNumDs);
        for (Object key : mapNum4.keySet()) {
            String str = qhmcMap.get(key) + ":" + mapNumDs.get(key);
            tableMap.put("BWSBZGDS",str + "%");
            break;
        }
//        tableMap.put("BWSBZGDS",thisProvinceData.get("provinceData") + "%");
        String BWSBZGQX = "";
        for(Map<String,Double> map : resultListQs){
            for (Object key : map.keySet()) {
                BWSBZGQX += qhmcMap.get(key) + ":" + map.get(key) + "%  ";
            }
        }
        tableMap.put("BWSBZGQX",BWSBZGQX);

        String BWSBZDQX = "";
        for(Map<String,Double> map : resultListHs){
            for (Object key : map.keySet()) {
                BWSBZDQX += qhmcMap.get(key) + ":" + map.get(key) + "%  ";
            }
        }
        tableMap.put("BWSBZDQX",BWSBZDQX);
        resultList.put("tableMap",tableMap);
        return resultList;
    }

    /**
     * 导出word
     * @param type,name,content
     * @return
     */
    @RequestMapping("/exportWord")
    public void exportWord(HttpServletRequest request, HttpServletResponse response, String type, String name, String content){
        String[] filenames= {"登簿质量得分情况","登簿数据字段空项情况","接入成功率情况","接入稳定性报告","接入及时性情况","接入质量得分情况","报文接入成功率报告","报文上报成功率报告"};
        Map param = new HashMap();
        param.put("fileName",filenames[Integer.valueOf(type)-1]);
       content = content.replace("X","%");
        // 表头
        String[] names = name.split("--");

        // 数据内容
        String[] contents = content.split("--");
        for(int i = 0; i < names.length; i++){
            if(names[i] == null || "".equals(names[i])){
                break;
            }
            param.put(names[i],contents[i] == null ? "" : contents[i]);
        }
        jrdbzlpjServiceImpl.exportWord(request,response,param);
    }

       public  void exitskxzd(List<Kxlzd>Citylist,Set kxlset,Map<String,String> kxlMap,String qhmc){
//                  Kxlzd zd =new Kxlzd();
//                   zd.setQhmc(qhmc);
//              List<String> zdlist =new ArrayList<>();
//               for(Iterator iter = kxlset.iterator(); iter.hasNext();)
//                  {
//                String kxlkey = (String)iter.next();
//                String kxlvalue = kxlMap.get(kxlkey);
//                if(StringUtils.equals(kxlvalue,"0.00%")){
//                    zdlist.add(kxlkey);
//                  }
//
//               }
//              zd.setZdmc(zdlist);
//              Citylist.add(zd);

        }


//        for(int i=0;i<kxlzdMap.size();i++){
//            if(StringUtils.equals(kxlzdMap.get(i).toString(),"100.00%")){
//                Map<String,String> zdmap =new HashMap<>();
//                zdmap.put("QHMC",qhmc);
////                zdmap.put("",)
//
//            }
//
//
//        }
//        for(String kxl:kxlzdMap.values()){
//            if(kxl.equals("100.00%")){
//               Map<String,String> zdmap =new HashMap<>();
//                zdmap.put("QHMC",qhmc);
//                zdmap.put("ZD","123");
//
//            }
//        }


    //格式化上期省级数据
    public static Map<String,String> getJRCgl(List<Map<String,String>> list){
        int total;
        int success;
        //全省数据
        total = 0;
        success = 0;

        for(Map map1: list){
            String qhdm = "";
            String jg = "";
            String rkjg = "";
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    qhdm = map1.get("QHDM").toString();
                }
                if("JG".equals(key.toString())){
                    if(map1.get("JG") == null){
                        jg = "0";
                    }else {
                        jg = map1.get("JG").toString();
                    }
                }
                if("RKJG".equals(key.toString())){
                    if(map1.get("RKJG") == null){
                        rkjg = "失败";
                    }else {
                        rkjg = map1.get("RKJG").toString();
                    }
                }
            }

            total += Integer.parseInt(jg);
            if("成功".equals(rkjg)){
                success += Integer.parseInt(jg);
            }
        }
        txfloat(success,total);
        Map<String,String> provinceParam = new HashMap<>(5);
        provinceParam.put("provinceData", txfloat(success,total));
        return provinceParam;
    }



    /**
     * 组装数据
     *
     * @param xzqdm 行政区代码
     * @param data  数据
     * @return 组装的数据
     */
    private Map<String, Object> getData(String xzqdm, List<Map<String, String>> data) {
        Map<String, Object> resultMap = new HashMap<>(12);
        List<Map<String, Object>> result = new ArrayList<>();
        for (Map<String, String> map : data) {
            if (xzqdm.equals(map.get("QHDM"))) {
                resultMap.putAll(map);
            }
            if (xzqdm.equals(map.get("FDM"))) {
                Map<String, Object> temp = getData(map.get("QHDM"), data);
                result.add(temp);
            }
            if (!result.isEmpty()) {
                resultMap.put("children", result);
            }
        }
        return resultMap;
    }
    public static Map<String,String> getSBCgl(List<Map<String,String>> list){
        int total;
        int success;
        //全省数据
        total = 0;
        success = 0;

        for(Map map1: list){
            String qhdm = "";
            String jg = "";
            String sbjg = "";
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    qhdm = map1.get("QHDM").toString();
                }
                if("JG".equals(key.toString())){
                    if(map1.get("JG") == null){
                        jg = "0";
                    }else {
                        jg = map1.get("JG").toString();
                    }
                }
                if("SBJG".equals(key.toString())){
                    if(map1.get("SBJG") == null){
                        sbjg = "失败";
                    }else {
                        sbjg = map1.get("SBJG").toString();
                    }
                }
            }

            total += Integer.parseInt(jg);
            if("成功".equals(sbjg)){
                success += Integer.parseInt(jg);
            }
        }
        txfloat(success,total);
        Map<String,String> provinceParam = new HashMap<>(5);
        provinceParam.put("provinceData", txfloat(success,total));
        return provinceParam;
    }

    /**
     * TODO 除法运算，保留小数
     * @param a 被除数
     * @param b 除数
     * @return 商
     */
    public static String txfloat(int a,int b) {
        // TODO 自动生成的方法存根
        if(b==0){
            return 0 + "";
        }else {
            DecimalFormat df=new DecimalFormat("0.00");//设置保留位数
            return df.format((double) a*100/b);
        }
    }
}


