package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.service.impl.JrrzServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/11/9
 * @description 接入日志上报页面
 */
@Controller
@RequestMapping(value = "/jrrz")
public class JrrzController {


    @Autowired
    private Repository repository;

    @Autowired
    private BaRzjlMapper baRzjlMapper;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    private JrrzServiceImpl jrrzService;

    /**
     * 页面初始化
     *
     * @param model
     */
    @RequestMapping("")
    public String init(Model model) {
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            model.addAttribute("cityList", cityList);
            model.addAttribute("flag", "city");//省级平台
        } else {
            List<Map<String, Object>> xzqhInfos = xzqhInfoService.getQxxxByFdm(qhdm);
            model.addAttribute("cityList", xzqhInfos);
            model.addAttribute("flag", "county");//市级平台
        }
        if(qhdm.substring(0,2).equals("32")){
            return "/join/jrrz";
        }else {
            return "/join/jrrzSX";
        }
    }


    /**
     * 查询
     *
     * @param kssj
     * @param jssj
     * @return
     */
    @RequestMapping("/cxjrrz")
    @ResponseBody
    public Object getJrrzInfos(String dsCode, String qxCode, Date kssj, Date jssj,String sbzt, Pageable pageable) {

        Map<String, Object> param = Maps.newHashMap();

        if (!StringUtils.isBlank(dsCode)) {
            param.put("dsCode", dsCode);
        }
        if (!StringUtils.isBlank(qxCode)) {
            param.put("qxCode", qxCode);
        }
        if (null != kssj) {
            param.put("kssj", kssj);
        }
        if (null != jssj) {
            param.put("jssj", jssj);
        }
        if(StringUtils.isNotBlank(sbzt)){
            param.put("sbzt", sbzt);
        }
        Page<List<Map<String, String>>> resList = repository.selectPaging("getJrrzInfosByPage", param, pageable);
        return resList;
    }

    /**
     * @param fdm
     * @return
     * @author <a href="mailto:chentao@gtmap.cn">chentao</a>
     * @description 根据fdm查询对应地级市所辖的县区列表
     */
    @ResponseBody
    @RequestMapping("/area")
    public List<Map<String, String>> getAreaList(String fdm) {
        List<Map<String, String>> areaList = baRzjlMapper.getAreaList(fdm);
        return areaList;
    }

    /**
     * 手动上报操作
     *
     * @param param
     * @return
     */
    @ResponseBody
    @RequestMapping("/sdsb")
    public Object sdsb(String param) {
        String res = jrrzService.uploadData(param,true);
        Map<String, String> resMap = Maps.newHashMap();
        resMap.put("res", res);
        return resMap;
    }

}
