package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.server.service.impl.JrqktjServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.ExportExcelUtils;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/8/6
 * @description 接入情况统计
 */
@Controller
@RequestMapping("jrqktj")
public class JrqktjController extends BaseController {


    @Autowired
    JrqktjServiceImpl jrqktjService;

    String qhdm = AppConfig.getProperty("region.qhdm");

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    private String cityName;

    /**
     * 初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String init(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        Date nowDate = new Date();
        String regionName = getRegionName();
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            regionName = regionName + "省";
        }
        Date kssj = TimeUtils.getThisWeekMonday(nowDate);
        String startTime = TimeUtils.dateToStr(kssj, "yyyy年MM月dd日");
        String endTime = TimeUtils.dateToStr(nowDate, "yyyy年MM月dd日");
        cityName = regionName;
        model.addAttribute("cityName", regionName);
        model.addAttribute("startTime", startTime);
        model.addAttribute("endTime", endTime);
        return "join/jrqktj";
    }


    /**
     * 查询接入情况统计信息
     *
     * @param kssj
     * @param jssj
     * @return
     */
    @RequestMapping("getJrqktjxx")
    @ResponseBody
    public Object getJrqktjxx(Date kssj, Date jssj) {
        List<Map<String, Object>> resList = jrqktjService.getJrqktjxx(qhdm, kssj, jssj);
        return resList;
    }


    /**
     * 导出数据
     *
     * @param kssj
     * @param jssj
     */
    @RequestMapping("exportData")
    public void exportData(Date kssj, Date jssj, HttpServletResponse response, HttpServletRequest request) {
        List<Map<String, Object>> resList = jrqktjService.getJrqktjxx(qhdm, kssj, jssj);
        if (null == kssj && null == jssj) {
            Date nowDate = new Date();
            kssj = TimeUtils.getThisWeekMonday(nowDate);
            jssj = nowDate;
        }
        String kssjStr = TimeUtils.dateToStr(kssj, "yyyy年MM月dd日");
        String jssjStr = TimeUtils.dateToStr(jssj, "yyyy年MM月dd日");
        Map<String, String> param = Maps.newHashMap();
        param.put("startTime", kssjStr);
        param.put("endTime", jssjStr);
        param.put("cityName", cityName);
        OperationalLogUtil.log(request, "1", "接入情况统计信息导出", "接入系统");
        ExportExcelUtils.exportSummary(resList, "接入情况统计信息", response, param);
    }

    /**
     * 查询接入情况统计信息
     *
     * @return
     */
    @RequestMapping("getRocketMqJrqktjxx")
    @ResponseBody
    public Object getRocketMqJrqktjxx() {
        Date nowDate = new Date();
        String startTime = TimeUtils.getLastSaturday("yyyyMMdd");
        String endTime = TimeUtils.dateToStr(nowDate,"yyyyMMdd");
        Date kssj = TimeUtils.strToDateFormatter(startTime,"yyyyMMdd");
        Date jssj = TimeUtils.strToDateFormatter(endTime,"yyyyMMdd");
        List<Map<String, Object>> resList = jrqktjService.getRocketMqJrqktjxx(qhdm, kssj, jssj);
        return resList;
    }


    /**
     * 新首页接口
     * @return
     */
      @RequestMapping("getNewRocketMqJrqktjxx")
      @ResponseBody
    public  Map<String, Object> getNewRocketMqJrqktjxx(){
          Map<String, String> param = Maps.newHashMap();
          String kssj =TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -14), "yyyy-MM-dd");
          String jssj=TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -1), "yyyy-MM-dd");
           param.put("startTime",kssj);
          param.put("endTime",jssj);
          List<Map<String, Object>> resultList=  jrqktjService.getRocketNewMqJrqktjxx(kssj, jssj, qhdm);
          Map<String, Object> resultLayuiMap = new HashMap<>();
          resultLayuiMap.put("data", resultList);
          resultLayuiMap.put("code", "0");
          resultLayuiMap.put("msg", "");
          resultLayuiMap.put("count", resultList.size());
          return  resultLayuiMap;
      }


}
