package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.server.service.impl.JrdbzlpjServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping(value = "jrzlpjtjfx")
public class JrpjtjfxController {

    private static Logger logger = LoggerFactory.getLogger(JrpjtjfxController.class);

    @Autowired
    private JrdbzlpjServiceImpl jrdbzlpjServiceImpl;

    @Autowired
    private JrzlpjfxController jrzlpjfxController;

    private static JrpjtjfxController jrpjtjfxController;    //转接对象

    @PostConstruct
    public void init() {
        jrpjtjfxController = this;
        jrpjtjfxController.jrzlpjfxController = this.jrzlpjfxController;
    }

    @RequestMapping("/showIndex")
    public Object showIndex(Model model) {
        return "/join/tjfx";
    }

    /**
     * 导出word
     * @param type
     * @param kssj
     * @param jssj
     * @param sqkssj
     * @param sqjssj
     * @return
     */
    @ResponseBody
    @RequestMapping("/exportWord")
    public void exportWord(HttpServletRequest request, HttpServletResponse response , String type , String kssj ,String jssj, String sqkssj, String sqjssj){
        //空格  换行
        String space = "&#160;";
        String enter = "<w:p></w:p>";
        Map<String,String> param = new HashMap();
        List list = new ArrayList();
        param.put("fileName","全省不动产登记增量数据登簿和接入质量情况");
        String [] typeStr = type.split("--");
        for(int i=0; i<typeStr.length; i++){
            list.add(typeStr[i]);
        }

        String [] kssjStr = kssj.split("-");
        String [] jssjStr = jssj.split("-");
        String str = kssjStr[0] + "年" + kssjStr[1] + "月" + kssjStr[2] + "日" + "至" + jssjStr[0] + "年" + jssjStr[1] + "月" + jssjStr[2] + "日";
        param.put("dqsj",str);

        if(list.contains("1")){
            Map<String,String> map =  writeTableData1(kssj,jssj,sqkssj,sqjssj);
            param.putAll(map);
        }else {
            //一、	接入质量得分情况 11
            param.put("qsbqdf1","无");
            param.put("qssqdf1","无");
            param.put("bjdf1","无");

            param.put("jrdfzhcity","无");
            param.put("jrdfzhqx","无");
            param.put("jrdfzccity","无");
            param.put("jedfzcqx","无");

            param.put("jrdfgroupzhcity","无");
            param.put("jrdfgroupzhqx","无");
            param.put("jrdfgroupzccity","无");
            param.put("jrdfgroupzcqx","无");
        };

        if(list.contains("2")){
            Map<String,String> map = writeTableData2(kssj,jssj,sqkssj,sqjssj);
            param.putAll(map);
        }else {
            //二、	登簿质量得分情况11
            param.put("qsbqdf2",space);
            param.put("qssqdf2",space);
            param.put("bjdf2",space);

            param.put("dbzlzhcity",space);
            param.put("dbzlzhqx",space);
            param.put("dbzlzccity",space);
            param.put("dbzlzcqx",space);

            param.put("dbzlgroupzhcity",space);
            param.put("dbzlgroupzhqx",space);
            param.put("dbzlgroupzccity",space);
            param.put("dbzlgroupzcqx",space);
        };

        if(list.contains("3")){
            Map<String,String> map = writeTableData3(kssj,jssj,sqkssj,sqjssj);
            param.putAll(map);
        }else {
            //	三、	未接入成功率情况7
            param.put("bqjrcglv",space);
            param.put("sqjrcglv",space);
            param.put("bjdf3",space);

            param.put("wcgjrzbcity",space);
            param.put("wcgjrzbqx",space);
            param.put("wcgjrzbfscity",space);
            param.put("wcgjrzbfsqx",space);

        };

        if(list.contains("4")){
            Map<String,String> map = writeTableData4(kssj, jssj);
            param.putAll(map);
        }else {
            //	四、	接入稳定性情况 6
            param.put("wjrdbrzsj",space);
            param.put("wjrdbrzqx",space);

            param.put("wjrbwsj",space);
            param.put("wjrbwqx",space);
            param.put("dblwlsj",space);
            param.put("dblwlqx",space);
        };

        if(list.contains("5")){
            Map<String,String> map = writeTableData5(kssj,jssj);
            param.putAll(map);
        }else {
            //	五、	接入及时性情况6
            param.put("jrdbzl1zbcity",space);
            param.put("jrdbzl1zbqx",space);

            param.put("jrdbzl2zbcity",space);
            param.put("jrdbzl2zbqx",space);
            param.put("jrdbzl3zbcity",space);
            param.put("jrdbzl3zbqx",space);
        };

        if(list.contains("6")){
            Map<String,String> map = writeTableData6(kssj, jssj);
            param.putAll(map);
        }else {
            //	六、	登簿数据字段空项情况2
            param.put("kxlzdcity",space);
            param.put("kxlzdqx",space);
        };

        if(list.contains("7")){
            Map<String,String> map = writeTableData7(kssj, jssj, sqkssj, sqjssj);
            param.putAll(map);
        }else {
            //	七、	报文接入成功率7
            param.put("qsbqjr",space);
            param.put("qssqjr",space);
            param.put("bhjr",space);

            param.put("bwjrzgds",space);
            param.put("bwjrzgqx",space);
            param.put("bwjrzdds",space);
            param.put("bwjrzdqx",space);
        };

        if(list.contains("8")){
            Map<String,String> map = writeTableData8(kssj, jssj, sqkssj, sqjssj);
            param.putAll(map);
        }else {
            //	八、	报文上报成功率7
            param.put("qsbqsb",space);
            param.put("qssqsb",space);
            param.put("bhsb",space);

            param.put("bwsbzgds",space);
            param.put("bwsbzgqx",space);
            param.put("bwsbzdds",space);
            param.put("bwsbzdqx",space);
        };

        jrdbzlpjServiceImpl.exportWord(request,response,param);
    }

    //组装第一个tabledata
    public static Map<String,String> writeTableData1(String kssj, String jssj, String sqkssj, String sqjssj){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = ( Map<String, Object>)jrpjtjfxController.jrzlpjfxController.getJrzldfqkTabel(kssj,jssj,sqkssj,sqjssj);
        List<Map<String, String>>  resultList = (List<Map<String, String>> )object.get("data");
        Map<String, String> resultMap = resultList.get(0);
        String qsbqdf = resultMap.get("QSBQDF");
        String qssqdf = resultMap.get("QSSQDF");
        String bjdf = resultMap.get("BJDF");

        String jrdfzhcity = resultMap.get("JRDFZHCITY");
        String jrdfzhqx = resultMap.get("JRDFZHQX");
        String jrdfzccity = resultMap.get("JRDFZCCITY");
        String jedfzcqx = resultMap.get("JEDFZCQX");

        String jrdfgroupzhcity = resultMap.get("JRDFGROUPZHCITY");
        String jrdfgroupzhqx = resultMap.get("JRDFGROUPZHQX");
        String jrdfgroupzccity = resultMap.get("JRDFGROUPZCCITY");
        String jrdfgroupzcqx = resultMap.get("JRDFGROUPZCQX");

        //一、	接入质量得分情况 11
        param.put("qsbqdf1",qsbqdf);
        param.put("qssqdf1",qssqdf);
        param.put("bjdf1",bjdf);

        param.put("jrdfzhcity",jrdfzhcity);
        param.put("jrdfzhqx",jrdfzhqx);
        param.put("jrdfzccity",jrdfzccity);
        param.put("jedfzcqx",jedfzcqx);

        param.put("jrdfgroupzhcity",jrdfgroupzhcity);
        param.put("jrdfgroupzhqx",jrdfgroupzhqx);
        param.put("jrdfgroupzccity",jrdfgroupzccity);
        param.put("jrdfgroupzcqx",jrdfgroupzcqx);
        return param;
    }

    //组装第二个tabledata
    public static Map<String,String> writeTableData2(String kssj, String jssj, String sqkssj, String sqjssj){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = ( Map<String, Object>)jrpjtjfxController.jrzlpjfxController.getDbzldfTable(kssj,jssj,sqkssj,sqjssj);
        List<Map<String, String>>  resultList = (List<Map<String, String>> )object.get("data");
        Map<String, String> resultMap = resultList.get(0);
        String qsbqdf = resultMap.get("QSBQDF");
        String qssqdf = resultMap.get("QSSQDF");
        String bjdf = resultMap.get("BJDF");

        String dbzlzhcity = resultMap.get("DBZLZHCITY");
        String dbzlzhqx = resultMap.get("DBZLZHQX");
        String dbzlzccity = resultMap.get("DBZLZCCITY");
        String dbzlzcqx = resultMap.get("DBZLZCQX");

        String dbzlgroupzhcity = resultMap.get("DBZLGROUPZHCITY");
        String dbzlgroupzccity = resultMap.get("DBZLGROUPZCCITY");
        String dbzlgroupzhqx = resultMap.get("DBZLGROUPZHQX");
        String dbzlgroupzcqx = resultMap.get("DBZLGROUPZCQX");

        //二、	登簿质量得分情况 11
        param.put("qsbqdf2",qsbqdf);
        param.put("qssqdf2",qssqdf);
        param.put("bjdf2",bjdf);

        param.put("dbzlzhcity",dbzlzhcity);
        param.put("dbzlzhqx",dbzlzhqx);
        param.put("dbzlzccity",dbzlzccity);
        param.put("dbzlzcqx",dbzlzcqx);

        param.put("dbzlgroupzhcity",dbzlgroupzhcity);
        param.put("dbzlgroupzccity",dbzlgroupzccity);
        param.put("dbzlgroupzhqx",dbzlgroupzhqx);
        param.put("dbzlgroupzcqx",dbzlgroupzcqx);
        return param;
    }

    //组装第三个tabledata
    public static Map<String,String> writeTableData3(String kssj, String jssj, String sqkssj, String sqjssj){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = ( Map<String, Object>)jrpjtjfxController.jrzlpjfxController.getJrcglqkTable(kssj,jssj,sqkssj,sqjssj);
        List<Map<String, String>>  resultList = (List<Map<String, String>> )object.get("data");
        Map<String, String> resultMap = resultList.get(0);
        String sqjrcglv = resultMap.get("SQJRCGLV");
        String bqjrcglv = resultMap.get("BQJRCGLV");
        String bjdf3 = resultMap.get("BJDF");

        String wcgjrzbcity = resultMap.get("WCGJRZBCITY");
        String wcgjrzbqx = resultMap.get("WCGJRZBQX");
        String wcgjrzbfscity = resultMap.get("WCGJRZBFSCITY");
        String wcgjrzbfsqx = resultMap.get("WCGJRZBFSQX");

        //	三、	未接入成功率情况7
        param.put("sqjrcglv",sqjrcglv);
        param.put("bqjrcglv",bqjrcglv);
        param.put("bjdf3",bjdf3);

        param.put("wcgjrzbcity",wcgjrzbcity);
        param.put("wcgjrzbqx",wcgjrzbqx);
        param.put("wcgjrzbfscity",wcgjrzbfscity);
        param.put("wcgjrzbfsqx",wcgjrzbfsqx);
        return param;
    }

    //组装第四个tabledata
    public static Map<String,String> writeTableData4(String kssj, String jssj  ){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = jrpjtjfxController.jrzlpjfxController.jrwdxData(kssj,jssj);
        Map<String ,String>  resultMap = (Map<String, String>)object.get("tableMap");

        String wjrdbrzsj = resultMap.get("WJRDBRZSJ");
        String wjrdbrzqx = resultMap.get("WJRDBRZQX");
        String wjrbwsj = resultMap.get("WJRBWSJ");

        String wjrbwqx = resultMap.get("WJRBWQX");
        String dblwlsj = resultMap.get("DBLWLSJ");
        String dblwlqx = resultMap.get("DBLWLQX");

        //	四、	接入稳定性情况 6
        param.put("wjrdbrzsj",wjrdbrzsj);
        param.put("wjrdbrzqx",wjrdbrzqx);
        param.put("wjrbwsj",wjrbwsj);

        param.put("wjrbwqx",wjrbwqx);
        param.put("dblwlsj",dblwlsj);
        param.put("dblwlqx",dblwlqx);
        return param;
    }

    //组装第五个tabledata
    public static Map<String,String> writeTableData5(String kssj, String jssj){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = ( Map<String, Object>)jrpjtjfxController.jrzlpjfxController.getJrjsxqkTabel(kssj,jssj);
        List<Map<String, String>>  resultList = (List<Map<String, String>> )object.get("data");
        Map<String, String> resultMap = resultList.get(0);
        String jrdbzl1zbcity = resultMap.get("JRDBZL1ZBCITY");
        String jrdbzl1zbqx = resultMap.get("JRDBZL1ZBQx");
        String jrdbzl2zbcity = resultMap.get("JRDBZL2ZBCITY");

        String jrdbzl2zbqx = resultMap.get("JRDBZL2ZBQx");
        String jrdbzl3zbcity = resultMap.get("JRDBZL3ZBCITY");
        String jrdbzl3zbqx = resultMap.get("JRDBZL3ZBQx");

        //	五、	接入及时性情况6
        param.put("jrdbzl1zbcity",jrdbzl1zbcity);
        param.put("jrdbzl1zbqx",jrdbzl1zbqx);
        param.put("jrdbzl2zbcity",jrdbzl2zbcity);

        param.put("jrdbzl2zbqx",jrdbzl2zbqx);
        param.put("jrdbzl3zbcity",jrdbzl3zbcity);
        param.put("jrdbzl3zbqx",jrdbzl3zbqx);
        return param;
    }

    //组装第六个tabledata
    public static Map<String,String> writeTableData6(String kssj, String jssj){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = ( Map<String, Object>)jrpjtjfxController.jrzlpjfxController.getJrkxlTable(kssj,jssj);
        List<Map<String, String>>  resultList = (List<Map<String, String>> )object.get("data");
        Map<String, String> resultMap = resultList.get(0);
        String kxlzdcity = resultMap.get("KXLZDCITY");
        String kxlzdqx = resultMap.get("KXLZDQX");

        //	六、	登簿数据字段空项情况2
        param.put("kxlzdcity",kxlzdcity);
        param.put("kxlzdqx",kxlzdqx);

        return param;
    }

    //组装第七个tabledata
    public static Map<String,String> writeTableData7(String kssj, String jssj ,String sqkssj, String sqjssj ){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = jrpjtjfxController.jrzlpjfxController.obtainJrcgl(kssj,jssj,sqkssj,sqjssj);
        Map<String ,String>  resultMap = (Map<String, String>)object.get("tableMap");

        String qsbqjr = resultMap.get("QSBQJR");
        String qssqjr = resultMap.get("QSSQJR");
        String bhjr = resultMap.get("BH");

        String bwjrzgds = resultMap.get("BWJRZGDS");
        String bwjrzgqx = resultMap.get("BWJRZGQX");
        String bwjrzdds = resultMap.get("BWJRZDDS");
        String bwjrzdqx = resultMap.get("BWJRZDQX");

        //	七、	报文接入成功率7
        param.put("qsbqjr",qsbqjr);
        param.put("qssqjr",qssqjr);
        param.put("bhjr",bhjr);

        param.put("bwjrzgds",bwjrzgds);
        param.put("bwjrzgqx",bwjrzgqx);
        param.put("bwjrzdds",bwjrzdds);
        param.put("bwjrzdqx",bwjrzdqx);
        return param;
    }

    //组装第八个tabledata
    public static Map<String,String> writeTableData8(String kssj, String jssj ,String sqkssj, String sqjssj ){
        Map<String,String> param = new HashMap();
        Map<String, Object> object = jrpjtjfxController.jrzlpjfxController.obtainSbcgl(kssj,jssj,sqkssj,sqjssj);
        Map<String ,String>  resultMap = (Map<String, String>)object.get("tableMap");

        String qsbqsb = resultMap.get("QSBQSB");
        String qssqsb = resultMap.get("QSSQSB");
        String bhsb = resultMap.get("BH");

        String bwsbzgds = resultMap.get("BWSBZGDS");
        String bwsbzgqx = resultMap.get("BWSBZGQX");
        String bwsbzdds = resultMap.get("BWSBZDDS");
        String bwsbzdqx = resultMap.get("BWSBZDQX");

        //	八、	报文上报成功率7
        param.put("qsbqsb",qsbqsb);
        param.put("qssqsb",qssqsb);
        param.put("bhsb",bhsb);

        param.put("bwsbzgds",bwsbzgds);
        param.put("bwsbzgqx",bwsbzgqx);
        param.put("bwsbzdds",bwsbzdds);
        param.put("bwsbzdqx",bwsbzdqx);
        return param;
    }

}
