package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.service.KxlService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 不动产登记日常登簿质量评价表
 * Created by user on 2019/7/12.
 */

@Controller
@RequestMapping("/dbzl")
public class JrpjrcdbController extends BaseController {

    /**
     * 日志打印对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(JrpjrcdbController.class);

    private static final String PROVINCE_DM = AppConfig.getProperty("region.qhdm");

    @Autowired
    private KxlService kxlService;

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    @RequestMapping("view")
    public String toDbzlView(Model model, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionName;
        if (null != regions && !regions.isEmpty()) {
            model.addAttribute("qhdm", regions.get(0).get("qhdm").toString());
            model.addAttribute("XTJB", regions.get(0).get("level").toString());
            region = regions.get(0).get("qhdm").toString();
            regionName = MapUtils.getString(regions.get(0), "qhmc");
        } else {
            model.addAttribute("qhdm", AppConfig.getProperty("region.qhdm"));
            model.addAttribute("XTJB", "省级");
            region = AppConfig.getProperty("region.qhdm");
            regionName = AppConfig.getProperty("supervise.des.name");
        }
        List<Map<String, Object>> regionList = kxlService.listXzqh(region);
        model.addAttribute("qhList", regionList);
        model.addAttribute("XTZYMC", "rcdbzlpj");
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        model.addAttribute("kssj", kxlService.getlastJssj());
        model.addAttribute("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));

        model.addAttribute("provinceName", regionName);
        if ("32".equals(region.substring(0, 2))) {
            return "/join/jrpjrcdb";
        } else {
            return "/join/jrpjrcdbSX";
        }
    }

    /**
     * @param kssj
     * @param jssj
     * @param qhdm
     * @return
     * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
     * @description 江苏的表单
     * @Date 2020/6/15
     */
    @ResponseBody
    @RequestMapping("fetch-data")
    public Map<String, Object> fetchData(String kssj, String jssj, String qhdm, HttpServletRequest request) {
        //判断市级部署还是省级部署
        Boolean isCity = true;
        if ("00".equals(PROVINCE_DM.substring(2, 4))) {
            isCity = false;
        }
        List<Map<String, Object>> cityData = new ArrayList<>();
        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionLevel;
        if (null != regions && !regions.isEmpty()) {
            region = regions.get(0).get("qhdm").toString();
            regionLevel = regions.get(0).get("level").toString();
        } else {
            region = AppConfig.getProperty("region.qhdm");
            regionLevel = "省级";
        }

        Map<String, Object> param = Maps.newHashMap();
        if (isCity) {
            param.put("provinceDm", baXzqhMapper.getFDMByqhdm(PROVINCE_DM));
        } else {
            param.put("provinceDm", PROVINCE_DM);
        }
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(qhdm)) {
            if (qhdm.endsWith("00")) {
                param.put("qhdm", qhdm.substring(0, 4));
            } else {
                param.put("qhdm", qhdm);
            }
        } else {
            if (!StringUtils.equals(regionLevel, "省级")) {
                if (region.endsWith("00")) {
                    param.put("qhdm", region.substring(0, 4));
                } else {
                    param.put("qhdm", region);
                }
            }
        }
        Map<String, Object> data = Maps.newHashMap();
        List<Map<String, Object>> provinceData = kxlService.listCityAndCountyDataFinal(param, false);
        for (int i = 0; i < provinceData.size(); i++) {
            if (provinceData.get(i).get("CITY_QHDM").toString().equals(PROVINCE_DM)) {
                cityData.add(provinceData.get(i));
            }
        }
        if (isCity) {
            data.put("data", cityData);
        } else {
            data.put("data", provinceData);
        }
        return data;
    }

    ;

    /**
     * @param kssj
     * @param sqkssj
     * @param jssj
     * @param sqjssj
     * @param qhdm
     * @return
     * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
     * @description 陕西的表单
     * @Date 2020/6/15
     */
    @ResponseBody
    @RequestMapping("fetch-data-SX")
    public Map<String, Object> fetchDataSx(String kssj, String jssj, String sqkssj, String sqjssj, String qhdm, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        boolean isCity = true;
        if(PROVINCE_DM.substring(2,4).equals("00")){
            isCity = false;
        }
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionLevel;
        if (null != regions && !regions.isEmpty()) {
            region = regions.get(0).get("qhdm").toString();
            regionLevel = regions.get(0).get("level").toString();
        } else {
            region = AppConfig.getProperty("region.qhdm");
            regionLevel = "省级";
        }

        Map<String, Object> param = Maps.newHashMap();
        Map<String, Object> sqparam = Maps.newHashMap();
        param.put("provinceDm", PROVINCE_DM);
        sqparam.put("provinceDm", PROVINCE_DM);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }

        //默认上期时间为本期时间的上两周
        if (StringUtils.isNotBlank(sqkssj)) {
            sqparam.put("kssj", sqkssj);
        } else {
            // 默认时间
            sqparam.put("kssj", TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -28), "yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(sqjssj)) {
            sqparam.put("jssj", sqjssj);
        } else {
            // 默认当前时间
            sqparam.put("jssj", TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -15), "yyyy-MM-dd"));
        }

        if (StringUtils.isNotBlank(qhdm)) {
            if (qhdm.endsWith("00")) {
                param.put("qhdm", qhdm.substring(0, 4));
                sqparam.put("qhdm", qhdm.substring(0, 4));
            } else {
                param.put("qhdm", qhdm);
                sqparam.put("qhdm", qhdm);
            }
        } else {
            if (!StringUtils.equals(regionLevel, "省级")) {
                if (region.endsWith("00")) {
                    param.put("qhdm", region.substring(0, 4));
                    sqparam.put("qhdm", region.substring(0, 4));
                } else {
                    param.put("qhdm", region);
                    sqparam.put("qhdm", region);
                }
            }

        }
        Map<String, Object> data = Maps.newHashMap();
        Map<String, Object> sqdata = Maps.newHashMap();
        List<Map<String, Object>> cityData = new ArrayList<>();
        if (isCity) {
            param.put("provinceDm", baXzqhMapper.getFDMByqhdm(PROVINCE_DM));
            sqparam.put("provinceDm", baXzqhMapper.getFDMByqhdm(PROVINCE_DM));
            data.put("data", kxlService.listCityAndCountyDataFinal(param, false));
            sqdata.put("data", kxlService.listCityAndCountyDataFinal(sqparam, false));
        } else {
            data.put("data", kxlService.listCityAndCountyDataFinal(param, false));
            sqdata.put("data", kxlService.listCityAndCountyDataFinal(sqparam, false));
        }


        //增加上期综合评分和变化情况
        List<Map<String, Object>> dataList = (List<Map<String, Object>>) data.get("data");
        List<Map<String, Object>> sqdataList = (List<Map<String, Object>>) sqdata.get("data");
        if ("省级".equals(regionLevel)) {
            for (int i = 0; i < dataList.size(); i++) {
                //省数据
                if (i == 0) {
                    String sqzhpf = sqdataList.get(i).get("ZHPF").toString();
                    String zhpf = dataList.get(i).get("ZHPF").toString();
                    dataList.get(i).put("SQZHPF", sqzhpf);
                    double sqzhpfDouble = Double.valueOf(sqzhpf);
                    double zhpfdfDouble = Double.valueOf(zhpf);
                    double bh = zhpfdfDouble - sqzhpfDouble;
                    String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
                    dataList.get(i).put("BHQK", bhqk);
                } else {
                    //市数据
                    String sqzhpf = sqdataList.get(i).get("ZHPF").toString();
                    String zhpf = dataList.get(i).get("ZHPF").toString();
                    dataList.get(i).put("SQZHPF", sqzhpf);
                    double sqzhpfDouble = Double.valueOf(sqzhpf);
                    double zhpfdfDouble = Double.valueOf(zhpf);
                    double bh = zhpfdfDouble - sqzhpfDouble;
                    String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
                    dataList.get(i).put("BHQK", bhqk);

                    //区县数据
                    List<Map<String, Object>> qxdataList = (List<Map<String, Object>>) dataList.get(i).get("children");
                    List<Map<String, Object>> sqqxdataList = (List<Map<String, Object>>) sqdataList.get(i).get("children");

                    if (CollectionUtils.isNotEmpty(qxdataList) && CollectionUtils.isNotEmpty(sqqxdataList)) {
                        for (int j = 0; j < qxdataList.size(); j++) {
                            String sqzhpf1 = sqqxdataList.get(j).get("ZHPF").toString();
                            String zhpf1 = qxdataList.get(j).get("ZHPF").toString();
                            qxdataList.get(j).put("SQZHPF", sqzhpf1);
                            double sqzhpfDouble1 = Double.valueOf(sqzhpf1);
                            double zhpfdfDouble1 = Double.valueOf(zhpf1);
                            double bh1 = zhpfdfDouble1 - sqzhpfDouble1;
                            String bhqk1 = String.valueOf((double) Math.round(bh1 * 100) / 100);
                            qxdataList.get(j).put("BHQK", bhqk1);
                        }
                    }

                    if (dataList.get(i).get("CITY_QHDM").toString().equals(PROVINCE_DM)) {
                        cityData.add(dataList.get(i));
                    }
                }
            }
        } else if ("市级".equals(regionLevel)) {
            for (int i = 0; i < dataList.size(); i++) {
                //市数据
                String sqzhpf = sqdataList.get(i).get("ZHPF").toString();
                String zhpf = dataList.get(i).get("ZHPF").toString();
                dataList.get(i).put("SQZHPF", sqzhpf);
                double sqzhpfDouble = Double.valueOf(sqzhpf);
                double zhpfdfDouble = Double.valueOf(zhpf);
                double bh = zhpfdfDouble - sqzhpfDouble;
                String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
                dataList.get(i).put("BHQK", bhqk);

                //区县数据
                List<Map<String, Object>> qxdataList = (List<Map<String, Object>>) dataList.get(i).get("children");
                List<Map<String, Object>> sqqxdataList = (List<Map<String, Object>>) sqdataList.get(i).get("children");

                if (CollectionUtils.isNotEmpty(qxdataList) && CollectionUtils.isNotEmpty(sqqxdataList)) {
                    for (int j = 0; j < qxdataList.size(); j++) {
                        String sqzhpf1 = sqqxdataList.get(j).get("ZHPF").toString();
                        String zhpf1 = qxdataList.get(j).get("ZHPF").toString();
                        qxdataList.get(j).put("SQZHPF", sqzhpf1);
                        double sqzhpfDouble1 = Double.valueOf(sqzhpf1);
                        double zhpfdfDouble1 = Double.valueOf(zhpf1);
                        double bh1 = zhpfdfDouble1 - sqzhpfDouble1;
                        String bhqk1 = String.valueOf((double) Math.round(bh1 * 100) / 100);
                        qxdataList.get(j).put("BHQK", bhqk1);
                    }
                }

                if (dataList.get(i).get("CITY_QHDM").toString().equals(PROVINCE_DM)) {
                    cityData.add(dataList.get(i));
                }
            }
        }
        if (isCity) {
            data.put("data", cityData);
        }
        return data;
    }


    @ResponseBody
    @RequestMapping("save-data")
    public Map<String, Object> saveData(String kssj, String jssj) {
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }
        kxlService.saveCityAndCountyData(param);

        param.put("bblx", "2");
        param.put("czsj", new Date());
        param.put("kssjDate", DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toDate());
        param.put("jssjDate", DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toDate());
        kxlService.saveDataCz(param);
        Map<String, Object> data = Maps.newHashMap();
        data.put("code", "success");
        return data;
    }

    /**
     * @param kssj
     * @param jssj
     * @param qhdm
     * @return
     * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
     * @description 江苏的导出
     * @Date 2020/6/15
     */
    @RequestMapping("export-excel")
    public void exportExcel(String kssj, String jssj, String sqkssj, String sqjssj, String qhdm
            , HttpServletRequest request, HttpServletResponse response) {

        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionName;
        String regionLevel;
        if (null != regions && !regions.isEmpty()) {
            region = regions.get(0).get("qhdm").toString();
            regionName = MapUtils.getString(regions.get(0), "qhmc");
            regionLevel = regions.get(0).get("level").toString();
        } else {
            region = AppConfig.getProperty("region.qhdm");
            regionName = AppConfig.getProperty("supervise.des.name");
            regionLevel = "省级";
        }

        Map<String, Object> param = Maps.newHashMap();
        param.put("provinceDm", PROVINCE_DM);
        param.put("provinceName", regionName);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }

        if (StringUtils.isNotBlank(qhdm)) {
            if (qhdm.endsWith("00")) {
                param.put("qhdm", qhdm.substring(0, 4));
            } else {
                param.put("qhdm", qhdm);
            }
        } else {
            if (!StringUtils.equals(regionLevel, "省级")) {
                if (region.endsWith("00")) {
                    param.put("qhdm", region.substring(0, 4));
                } else {
                    param.put("qhdm", region);
                }
            }
        }

        String regionQhdm = AppConfig.getProperty("region.qhdm");
        /**
         * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
         * @description 省级用户使用新版本，市级用户使用原来的老模板（江苏模板）。
         */
        if (StringUtils.isNotBlank(regionQhdm) && "32".equals(regionQhdm.substring(0, 2)) || !StringUtils.equals(regionLevel, "省级")) {
            kxlService.exportExcelDbzlJS(param, response, request);
        } else {
            Map<String, Object> sqparam = Maps.newHashMap();
            sqparam.put("provinceDm", PROVINCE_DM);
            sqparam.put("provinceName", regionName);
            if (StringUtils.isNotBlank(sqkssj)) {
                sqparam.put("kssj", sqkssj);
            } else {
                sqparam.put("kssj", TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -28), "yyyy-MM-dd"));
            }
            if (StringUtils.isNotBlank(sqjssj)) {
                sqparam.put("jssj", sqjssj);
            } else {
                sqparam.put("jssj", TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(), -15), "yyyy-MM-dd"));
            }
            if (StringUtils.isNotBlank(qhdm)) {
                if (qhdm.endsWith("00")) {
                    sqparam.put("qhdm", qhdm.substring(0, 4));
                } else {
                    sqparam.put("qhdm", qhdm);
                }
            } else {
                if (!StringUtils.equals(regionLevel, "省级")) {
                    if (region.endsWith("00")) {
                        sqparam.put("qhdm", region.substring(0, 4));
                    } else {
                        sqparam.put("qhdm", region);
                    }
                }
            }

            //省级用户市级导出
            if (CommonUtil.formatEmptyValue(param.get("qhdm")) != "") {
                kxlService.exportExcelDbzlJS(param, response, request);
            } else {
                kxlService.exportExcelDbzlSX(param, sqparam, response, request);
            }

        }

    }

}
