package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.service.KxlService;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 不动产登记数据库特定字段空项率统计
 * Created by user on 2019/7/12.
 */

@Controller
@RequestMapping("kxl")
public class JrpjBdckxlController extends BaseController {

    /**
     * 日志打印对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(JrpjBdckxlController.class);

    private static final String provinceDm = AppConfig.getProperty("region.qhdm");

    @Autowired
    private KxlService kxlService;

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    @RequestMapping("view")
    public String toKxlView(Model model, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionName;
        if (null != regions && !regions.isEmpty()) {
            model.addAttribute("qhdm", regions.get(0).get("qhdm").toString());
            model.addAttribute("XTJB", regions.get(0).get("level").toString());
            region = regions.get(0).get("qhdm").toString();
            regionName = MapUtils.getString(regions.get(0), "qhmc");
        } else {
            model.addAttribute("qhdm", AppConfig.getProperty("region.qhdm"));
            model.addAttribute("XTJB", "省级");
            region = AppConfig.getProperty("region.qhdm");
            regionName = AppConfig.getProperty("supervise.des.name");
        }
        List<Map<String, Object>> regionList = kxlService.listXzqh(region);
        model.addAttribute("qhList", regionList);
        model.addAttribute("XTZYMC", "kxl");
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        model.addAttribute("kssj", kxlService.getlastJssj());
        model.addAttribute("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));

        model.addAttribute("provinceName", regionName);

        return "/join/jrpjbdckxl";
    }

    @ResponseBody
    @RequestMapping("fetch-data")
    public Map<String, Object> fetchData(String kssj, String jssj, String qhdm, HttpServletRequest request) {
        //判断市级部署还是省级部署
        Boolean isCity = true;
        if(provinceDm.substring(2,4).equals("00")){
            isCity = false;
        }
        List<Map<String, Object>> cityData = new ArrayList<>();
        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionLevel;

        if ((null != regions) && (!regions.isEmpty()))
        {
            regionLevel = ((Map)regions.get(0)).get("level").toString();
            region = ((Map)regions.get(0)).get("qhdm").toString();
        }
        else
        {
            regionLevel = "省级";
            region = AppConfig.getProperty("region.qhdm");
        }
        Map<String, Object> param = Maps.newHashMap();
        if(isCity){
            param.put("provinceDm", baXzqhMapper.getFDMByqhdm(provinceDm));
        }else {
            param.put("provinceDm", provinceDm);
        }
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", this.kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(qhdm))
        {
            if (qhdm.endsWith("00")) {
                param.put("qhdm", qhdm.substring(0, 4));
            } else {
                param.put("qhdm", qhdm);
            }
        }
        else if (!StringUtils.equals(regionLevel, "省级")) {
            if (region.endsWith("00")) {
                param.put("qhdm", region.substring(0, 4));
            } else {
                param.put("qhdm", region);
            }
        }
        Map<String, Object> data = Maps.newHashMap();
        List<Map<String, Object>> provinceData = kxlService.listCityAndCountyData(param, false);
        for(int i= 0;i<provinceData.size();i++){
            if(provinceData.get(i).get("CITY_QHDM").toString().equals(provinceDm)){
                cityData.add(provinceData.get(i));
            }
        }
        if(isCity){
            data.put("data",cityData );
        }else {
            data.put("data",provinceData );
        }

        return data;
    }

    @ResponseBody
    @RequestMapping("save-data")
    public Map<String, Object> saveData(String kssj, String jssj) {
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }
        kxlService.saveCityAndCountyData(param);

        param.put("bblx", "2");
        param.put("czsj", new Date());
        param.put("kssjDate", DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toDate());
        param.put("jssjDate", DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toDate());
        kxlService.saveDataCz(param);
        Map<String, Object> data = Maps.newHashMap();
        data.put("code", "success");
        return data;
    }

    @RequestMapping("export-excel")
    public void exportExcel(String kssj, String jssj, String qhdm
        , HttpServletRequest request, HttpServletResponse response) {

        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String region;
        String regionName;
        String regionLevel;
        if (null != regions && !regions.isEmpty()) {
            region = regions.get(0).get("qhdm").toString();
            regionName = MapUtils.getString(regions.get(0), "qhmc");
            regionLevel = regions.get(0).get("level").toString();
        } else {
            region = AppConfig.getProperty("region.qhdm");
            regionName = AppConfig.getProperty("supervise.des.name");
            regionLevel = "省级";
        }

        Map<String, Object> param = Maps.newHashMap();
        param.put("provinceDm", provinceDm);
        param.put("provinceName", regionName);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }

        if (StringUtils.isNotBlank(qhdm)) {
            if (qhdm.endsWith("00")) {
                param.put("qhdm", qhdm.substring(0, 4));
            }else{
                param.put("qhdm", qhdm);
            }
        } else {
            if(!StringUtils.equals(regionLevel, "省级")){
                if (region.endsWith("00")) {
                    param.put("qhdm", region.substring(0, 4));
                } else {
                    param.put("qhdm", region);
                }
            }
        }

        param.put("regionLevel",regionLevel);
        kxlService.exportExcelKxl(param, response, request);
    }

    @RequestMapping("export-excel-all")
    public void exportExcelAll(String kssj, String jssj, String qhdm
        , HttpServletRequest request, HttpServletResponse response) {

        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String regionName;
        if (null != regions && !regions.isEmpty()) {
            regionName = MapUtils.getString(regions.get(0), "qhmc");
        } else {
            regionName = AppConfig.getProperty("supervise.des.name");
        }

        Map<String, Object> param = Maps.newHashMap();
        param.put("provinceDm", provinceDm);
        param.put("provinceName", regionName);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", kxlService.getlastJssj());
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }

        if (StringUtils.isNotBlank(qhdm)) {
            if (qhdm.endsWith("00")) {
                param.put("qhdm", qhdm.substring(0, 4));
            }else{
                param.put("qhdm", qhdm);
            }
        }
        kxlService.exportExcelKxlAll(param, response, request);
    }

}
