package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.service.JrjcfkqkService;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 不动产登记接入监测反馈情况
 * Created by user on 2019/7/12.
 */

@Controller
@RequestMapping("/jrjcfkqk")
public class JrjcfkqkController extends BaseController {

    /**
     * 日志打印对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(JrjcfkqkController.class);

    private static final String provinceDm = AppConfig.getProperty("region.qhdm");

    @Autowired
    private JrjcfkqkService jrjcfkqkService;

    @RequestMapping("view")
    public String toDbzlView(Model model, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String regionName;
        if (null != regions && !regions.isEmpty()) {
            regionName = MapUtils.getString(regions.get(0), "qhmc");
        } else {
            regionName = AppConfig.getProperty("supervise.des.name");
        }
        model.addAttribute("XTZYMC", "jrjcfkqk");
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        model.addAttribute("kssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        model.addAttribute("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));

        model.addAttribute("provinceName", regionName);

        return "/join/jrjcfkqk";
    }

    @ResponseBody
    @RequestMapping("fetch-data")
    public Map<String, Object> fetchData(String kssj, String jssj) {
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }

        Map<String, Object> data = Maps.newHashMap();
        data.put("data", jrjcfkqkService.listCityData(param));
        return data;
    }

    @RequestMapping("export-excel")
    public void exportExcel(String kssj, String jssj
        , HttpServletRequest request, HttpServletResponse response) {

        UserAuthDTO userInfos = getCurrentUser(request);
        List<Map<String, Object>> regions = userInfos.getRegions();
        String regionName;
        if (null != regions && !regions.isEmpty()) {
            regionName = MapUtils.getString(regions.get(0), "qhmc");
        } else {
            regionName = AppConfig.getProperty("supervise.des.name");
        }

        Map<String, Object> param = Maps.newHashMap();
        param.put("provinceDm", provinceDm);
        param.put("provinceName", regionName);
        if (StringUtils.isNotBlank(kssj)) {
            param.put("kssj", kssj);
        } else {
            param.put("kssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            param.put("jssj", jssj);
        } else {
            param.put("jssj", new DateTime().minusDays(1).toString("yyyy-MM-dd"));
        }

        jrjcfkqkService.exportExcelJrjcfkqk(param, response, request);
    }
}
