package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.aes.AESUtil;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.entity.Bajrdxzqh;
import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.service.ClientInfoService;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 接入管理
 */
@Controller
@RequestMapping("/jrgl")
public class JrglController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(JrglController.class);

    @Autowired
    private ClientInfoService userInfoService;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    AESUtil aesUtil;

    @Autowired
    BaRzjlMapper baRzjlMapper;

    @Autowired
    private Repository repository;

    @Autowired
    private DataInsertDbService dataInsertDbService;

    @Autowired
    private EntityMapper entityMapper;


    /**
     * 页面初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String index(Model model) {

        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        String regionQhdm = AppConfig.getProperty("region.qhdm");
        Map<String, String> param = Maps.newHashMap();
        param.put("fdm", regionQhdm);
        List<Map<String, String>> xzqhInfos = xzqhInfoService.getXzqhDatas(param);//xzqhInfoService.getXtregion();//
        List<Map<String, String>> jrdxx = xzqhInfoService.getJrdxx();
        model.addAttribute("jrdxx", jrdxx);
        model.addAttribute("xzqhInfos", xzqhInfos);
        boolean envFlag = dataInsertDbService.getEnv();
        if (!envFlag) {
            model.addAttribute("envFlag", "true");
        } else {
            model.addAttribute("envFlag", "false");
        }
        return "/join/jrgl";
    }

    /**
     * 查询
     *
     * @param fzr
     * @param qxinfo
     * @return
     */
    @ResponseBody
    @RequestMapping("/querySyxx")
    public Object getData(String fzr, String qxinfo, Pageable pageable) {
        HashMap<String, Object> param = new HashMap<>();
        if (!StringUtils.isBlank(fzr)) {
            param.put("fzr", fzr);
        }
        if (!StringUtils.isBlank(qxinfo)) {
            param.put("qxdm", qxinfo);
        }
        Page<List<Map<String, String>>> resList = repository.selectPaging("getJrdxxByPage", param, pageable);
        return resList;
    }


    /**
     * 删除
     *
     * @param khdbm
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public Map<String, String> delete(String khdbm, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        Map<String, Object> param = new HashMap<>();
        String[] details = khdbm.split(",");
        for (String s : details) {
            if (StringUtils.isNotBlank(s)) {
                param.put("khdbm", s);
                userInfoService.delete(param, userInfos);
            }
        }
        Map<String, String> ret = new HashMap<>();
        ret.put("returnMsg", "success");
        return ret;
    }


    /**
     * 新增接入点
     *
     * @param clientInfo
     * @return
     */
    @RequestMapping(value = "/action", method = RequestMethod.POST)
    @ResponseBody
    public Object addByPost(ClientInfo clientInfo, HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        try {
            UserAuthDTO userInfos = getCurrentUser(request);
            String khdmm = clientInfo.getKhdmm();
            clientInfo.setKhdmm(aesUtil.encryptXml(khdmm));
            userInfoService.save(clientInfo, userInfos);
            map.put("state", "true");
        } catch (Exception e) {
            LOGGER.error("新增接入点信息异常{}", e);
            map.put("state", "false");
        }
        return map;
    }

    /**
     * 修改接入点信息
     *
     * @param clientInfoParam
     * @param request
     * @param jrsjStr
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public Map<String, String> update(ClientInfo clientInfoParam, HttpServletRequest request, String jrsjStr) {

        UserAuthDTO userInfos = getCurrentUser(request);
        clientInfoParam.setKhdmm(aesUtil.encryptXml(clientInfoParam.getKhdmm()));
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern("yyyy-MM-dd");
        DateTime dateTime = dateTimeFormatter.parseDateTime(jrsjStr);
        clientInfoParam.setJrsj(dateTime.toDate());
        boolean flag = userInfoService.update(clientInfoParam, userInfos);
        if (flag) {
            Map<String, String> map = new HashMap<>();
            map.put("returnMsg", "success");
            return map;
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("returnMsg", "error");
            return map;
        }

    }


    /**
     * 编辑接入点
     *
     * @param khdbm
     * @return
     */
    @RequestMapping(value = "/editor", method = RequestMethod.POST)
    @ResponseBody
    public ClientInfo editorPost(String khdbm) {
        ClientInfo value;
        if (StringUtils.isNotBlank(khdbm)) {
            value = getModelByID(khdbm);
            String passWord = value.getKhdmm();
            String passWordStr = aesUtil.decryptXML(passWord);
            value.setKhdmm(passWordStr);
            return value;
        }
        return new ClientInfo();
    }


    private ClientInfo getModelByID(String id) {
        Map<String, String> param = new HashMap<>();
        if (!StringUtils.isBlank(id)) {
            param.put("khdbm", id);
            List<ClientInfo> data = userInfoService.getUserInfoList(param);
            if (null != data && !data.isEmpty()) {
                return data.get(0);
            }
        }
        return new ClientInfo();
    }


    /**
     * 新增区县信息
     *
     * @param jrddm
     * @param xzqhdm
     * @param jrdmc
     */
    @RequestMapping("addQx")
    @ResponseBody
    public Object addQx(String jrddm, @RequestParam(value = "jrdmcHidden") String jrdmc, String xzqhdm, HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        try {
            UserAuthDTO userInfos = getCurrentUser(request);
            Bajrdxzqh bajrdxzqh = new Bajrdxzqh();
            bajrdxzqh.setId(UUIDGenerator.generate18());
            bajrdxzqh.setCjsj(new Date());
            bajrdxzqh.setJrddm(jrddm);
            bajrdxzqh.setQhdm(xzqhdm);
            bajrdxzqh.setJrdmc(jrdmc);
            userInfoService.saveJrdqx(bajrdxzqh, userInfos);
            map.put("state", "true");
        } catch (Exception e) {
            LOGGER.error("新增区县信息异常:{}", e);
            map.put("state", "false");
        }
        return map;
    }

    /**
     * 查询区县信息
     *
     * @param jrddm
     * @param pageable
     * @return
     */
    @ResponseBody
    @RequestMapping("/queryQx")
    public Object queryQx(String jrddm, Pageable pageable) {
        HashMap<String, Object> param = new HashMap<>();
        if (!StringUtils.isBlank(jrddm)) {
            param.put("jrddm", jrddm);
        }
        Page<List<Map<String, String>>> resList = repository.selectPaging("getQxxxByPage", param, pageable);
        return resList;
    }


    /**
     * 删除区县信息
     *
     * @param id
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/deleteQxData", method = RequestMethod.POST)
    public Map<String, String> delQx(String id, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        Map<String, Object> param = new HashMap<>();
        String[] details = id.split(",");
        for (String str : details) {
            if (StringUtils.isNotBlank(str)) {
                param.put("id", str);

                ExampleUtil example = new ExampleUtil(Bajrdxzqh.class, param);
                List<Bajrdxzqh> bajrdxzqh = entityMapper.selectByExample(example);
                String qhdm = "";
                String jrddm = "";
                if (CollectionUtils.isNotEmpty(bajrdxzqh)) {
                    qhdm = bajrdxzqh.get(0).getQhdm();
                    jrddm = bajrdxzqh.get(0).getJrddm();
                }
                param.put("qhdm", qhdm);
                param.put("jrddm", jrddm);
                userInfoService.deleteQxData(param, userInfos);
            }
        }
        Map<String, String> ret = new HashMap<>();
        ret.put("returnMsg", "success");
        return ret;
    }


}

