package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.common.BaseInfoController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.service.JrdbzlpjService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 接入登簿质量评价
 * @author szh
 */
@Controller
@RequestMapping("/jrdbzlpj")
public class JrdbzlpjController extends  BaseInfoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JrdbzlpjController.class);

     @Autowired
     private JrdbzlpjService jrdbzlpjService;


     String region = AppConfig.getProperty("region.qhdm");

    @RequestMapping("")
     public String jrzlpj(HttpServletRequest request, Model model) {
        UserAuthDTO userAuthDTO = getCurrentUser(request);
        if (userAuthDTO !=null) {
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if (CollectionUtils.isNotEmpty(regionList)) {
                model.addAttribute("XTJB", regionList.get(0).get("level"));
            }
        }
        model.addAttribute("serverUrl", AppConfig.getProperty("server.url"));
        model.addAttribute("XTZYMC", "zlsjjrpj");
        if("32".equals(region.substring(0, 2))){
            return "/join/jrpj";
        }else {
            return "/join/jrpjSX";
        }

     }

    /**
     * 获得行政区名称
     * @return
     */
       @RequestMapping("getAllRegion")
       @ResponseBody
      public  List<Map<String,String>>   getAllRegion(){
        List<Map<String,String>> allxzqh=jrdbzlpjService.getCity(region);
        return  allxzqh;
    }

    /**
     * 获取接入质量评价数据
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param qhdm 区划代码
     * @return 接入质量评价数据
     */
    @RequestMapping("getJrzlpjData")
    @ResponseBody
    public Map<String, Object> getJrzlpjData(HttpServletRequest request,String kssj, String jssj, String qhdm){
        Map<String, Object> resultMap = new HashMap<>(5);
        Map<String, String> map = new HashMap<>(7);
        UserAuthDTO userAuthDTO = getCurrentUser(request);
        String useXzq = "";
        if (userAuthDTO !=null) {
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if (CollectionUtils.isNotEmpty(regionList)) {
                if ("市级".equals(regionList.get(0).get("level"))) {
                    useXzq = regionList.get(0).get("qhdm").toString();
                    map.put("xzq",useXzq);
                }
            }
        }

        if (StringUtils.isNotBlank(kssj)) {
            map.put("kssj",kssj);
        } else {
            // 默认时间
            map.put("kssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-14),"yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            map.put("jssj",jssj);
        } else {
            // 默认当前时间
            map.put("jssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-1),"yyyy-MM-dd"));
        }
        String xzqdm;
        if (StringUtils.isNotBlank(qhdm)) {
            map.put("qhdm",qhdm);
            xzqdm = qhdm;
        } else {
            if (StringUtils.isNotBlank(useXzq)) {
                xzqdm = useXzq;
            } else {
                xzqdm = region;
            }
        }
        try {
            List<Map<String,String>> data =  jrdbzlpjService.getJrzlpjData(map);
            Map<String, Object> dataMap = getData(xzqdm, data);
            List resultData = new ArrayList<>();
            if ("省级".equals(dataMap.get("QHJB"))) {
                List<Map<String,String>> children = (List<Map<String,String>>)dataMap.get("children");
                dataMap.remove("children");
                resultData.add(dataMap);
                resultData.addAll(children);
            } else {
                resultData.add(dataMap);
            }
            resultMap.put("code","success");
            resultMap.put("data",resultData);
        } catch (Exception e) {
            resultMap.put("code","fail");
            resultMap.put("msg",e.getMessage());
            LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
        return resultMap;
    }


    /**
     * 获取接入质量评价数据(陕西)
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param sqkssj 上期开始时间
     * @param sqjssj 上期结束时间
     * @param qhdm 区划代码
     * @return 接入质量评价数据
     */
    @RequestMapping("getJrzlpjDataSX")
    @ResponseBody
    public Map<String, Object> getJrzlpjDataSx(HttpServletRequest request,String kssj, String jssj, String sqkssj, String sqjssj,String qhdm){
        Map<String, Object> resultMap = new HashMap<>(5);
        Map<String, String> map = new HashMap<>(7);
        Map<String, String> sqmap = new HashMap<>(7);
        UserAuthDTO userAuthDTO = getCurrentUser(request);
        String useXzq = "";
        if (userAuthDTO !=null) {
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if (CollectionUtils.isNotEmpty(regionList)) {
                if ("市级".equals(regionList.get(0).get("level"))) {
                    useXzq = regionList.get(0).get("qhdm").toString();
                    map.put("xzq",useXzq);
                    sqmap.put("xzq",useXzq);
                }
            }
        }

        //默认本期时间为当前时间的前十四天到前一天
        if (StringUtils.isNotBlank(kssj)) {
            map.put("kssj",kssj);
        } else {
            // 默认时间
            map.put("kssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-14),"yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            map.put("jssj",jssj);
        } else {
            // 默认当前时间
            map.put("jssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-1),"yyyy-MM-dd"));
        }

        //默认上期时间为本期时间的上两周
        if (StringUtils.isNotBlank(sqkssj)) {
            sqmap.put("kssj",sqkssj);
        } else {
            // 默认时间
            sqmap.put("kssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-28),"yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(sqjssj)) {
            sqmap.put("jssj",sqjssj);
        } else {
            // 默认当前时间
            sqmap.put("jssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-15),"yyyy-MM-dd"));
        }

        String xzqdm;
        if (StringUtils.isNotBlank(qhdm)) {
            map.put("qhdm",qhdm);
            sqmap.put("qhdm",qhdm);
            xzqdm = qhdm;
        } else {
            if (StringUtils.isNotBlank(useXzq)) {
                xzqdm = useXzq;
            } else {
                xzqdm = region;
            }
        }
        try {
            List<Map<String,String>> data =  jrdbzlpjService.getJrzlpjData(map);
            List<Map<String,String>> sqdata =  jrdbzlpjService.getJrzlpjData(sqmap);

            //增加上期综合评分和变化情况
            for(int i=0;i<data.size();i++){
                String sqdf = sqdata.get(i).get("DF");
                String df = data.get(i).get("DF");

                data.get(i).put("SQDF",sqdf);
                double sqdfDouble = Double.valueOf(sqdf);
                double dfDouble = Double.valueOf(df);
                double bh = dfDouble - sqdfDouble;

                String bhqk = String.valueOf( (double) Math.round(bh * 100) / 100);

                data.get(i).put("BHQK",bhqk);

            }

            Map<String, Object> dataMap = getData(xzqdm, data);
            List resultData = new ArrayList<>();
            if ("省级".equals(dataMap.get("QHJB"))) {
                List<Map<String,String>> children = (List<Map<String,String>>)dataMap.get("children");
                dataMap.remove("children");
                resultData.add(dataMap);
                resultData.addAll(children);
            } else {
                resultData.add(dataMap);
            }
            resultMap.put("code","success");
            resultMap.put("data",resultData);
        } catch (Exception e) {
            resultMap.put("code","fail");
            resultMap.put("msg",e.getMessage());
            LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
        return resultMap;
    }


    /**
     * 导出接入质量评价数据
     * @param request
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param qhdm 区划代码
     */
    @RequestMapping("exportJrpjzlData")
    @ResponseBody
    public void exportJrpjzlData(HttpServletRequest request, HttpServletResponse response, String kssj, String jssj,String sqkssj, String sqjssj, String qhdm) {
        Map<String, String> map = new HashMap<>(7);
        UserAuthDTO userAuthDTO = getCurrentUser(request);
        String useXzq = "";
        String regionLevel = "";
        if (userAuthDTO !=null) {
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if (CollectionUtils.isNotEmpty(regionList)) {
                regionLevel = CommonUtil.formatEmptyValue(regionList.get(0).get("level"));
                if ("市级".equals(regionLevel)) {
                    useXzq = regionList.get(0).get("qhdm").toString();
                    map.put("xzq",useXzq);
                }
            }else{
                regionLevel = "省级";
            }
        }

        if (StringUtils.isNotBlank(kssj)) {
            map.put("kssj",kssj);
        } else {
            // 默认时间
            map.put("kssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-14),"yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(jssj)) {
            map.put("jssj",jssj);
        } else {
            // 默认当前时间
            map.put("jssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-1),"yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank(qhdm)) {
            map.put("qhdm",qhdm);
            map.put("qhmc",jrdbzlpjService.getRegion(qhdm).get("QHMC"));
        } else {
            if (StringUtils.isNotBlank(useXzq)) {
                map.put("qhmc",jrdbzlpjService.getRegion(useXzq).get("QHMC"));
            } else {
                map.put("qhmc",jrdbzlpjService.getRegion(region).get("QHMC"));
            }
        }

        String regionQhdm = AppConfig.getProperty("region.qhdm");
        /**
         * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
         * @description 省级用户使用新版本，市级用户使用原来的老模板（江苏模板）。
         */
        if (StringUtils.isNotBlank(regionQhdm)&& "32".equals(regionQhdm.substring(0, 2)) || !StringUtils.equals(regionLevel,"省级")) {
            jrdbzlpjService.exportJrpjzlData(response, request, map);
        }else{
            Map<String, String> sqmap = new HashMap<>(7);
            if (StringUtils.isNotBlank(sqkssj)) {
                sqmap.put("kssj",sqkssj);
            } else {
                // 默认时间
                sqmap.put("kssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-14),"yyyy-MM-dd"));
            }
            if (StringUtils.isNotBlank(sqjssj)) {
                sqmap.put("jssj",sqjssj);
            } else {
                // 默认当前时间
                sqmap.put("jssj",TimeUtils.dateToStr(TimeUtils.getAddDate(new Date(),-1),"yyyy-MM-dd"));
            }
            if (StringUtils.isNotBlank(qhdm)) {
                sqmap.put("qhdm",qhdm);
                sqmap.put("qhmc",jrdbzlpjService.getRegion(qhdm).get("QHMC"));
            } else {
                if (StringUtils.isNotBlank(useXzq)) {
                    sqmap.put("qhmc",jrdbzlpjService.getRegion(useXzq).get("QHMC"));
                } else {
                    sqmap.put("qhmc",jrdbzlpjService.getRegion(region).get("QHMC"));
                }
            }
            //省级用户市级导出
            if(CommonUtil.formatEmptyValue(map.get("qhdm")) != "" ){
                jrdbzlpjService.exportJrpjzlData(response, request, map);
            }else {
                jrdbzlpjService.exportJrpjzlDataSX(response, request, map,sqmap);
            }

        }

    }



    /**
     * 组装数据
     * @param xzqdm 行政区代码
     * @param data 数据
     * @return 组装的数据
     */
    private Map<String, Object> getData(String xzqdm, List<Map<String, String>> data) {
        Map<String, Object> resultMap = new HashMap<>(12);
        List<Map<String, Object>> result = new ArrayList<>();
        for (Map<String, String> map : data) {
            if (xzqdm.equals(map.get("QHDM"))) {
                resultMap.putAll(map);
            }
            if (xzqdm.equals(map.get("FDM"))) {
                Map<String, Object> temp = getData(map.get("QHDM"), data);
                result.add(temp);
            }
            if (!result.isEmpty()) {
                resultMap.put("children", result);
            }
        }
        return resultMap;
    }

    /**
     * 保存统计数据
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @return
     */
    @RequestMapping("saveCountData")
    @ResponseBody
    public Map<String, String> saveCountData(String kssj, String jssj) {
        Map<String, String> resultMap = new HashMap<>(5);
        if (StringUtils.isBlank(kssj) || StringUtils.isBlank(jssj)) {
            resultMap.put("code","fail");
            resultMap.put("msg","时间不能为空");
            return resultMap;
        }
        try {
            jrdbzlpjService.saveCountData(kssj, jssj);
            jrdbzlpjService.updateTjczrz(kssj,jssj);
            resultMap.put("code","success");
        } catch (Exception e) {
            resultMap.put("code","fail");
            resultMap.put("msg",e.getMessage());
            LOGGER.error(e.getMessage());
        }
        return resultMap;
    }

    /**
     * 导出明细
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param qhdm 区划代码
     */
    @RequestMapping("exportDetail")
    @ResponseBody
    public void exportDetail(HttpServletRequest request, HttpServletResponse response, String kssj, String jssj, String qhdm){
        Map<String, String> map = new HashMap<>(5);
        UserAuthDTO userAuthDTO = getCurrentUser(request);
        String useXzq = "";
        if (userAuthDTO !=null) {
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if (CollectionUtils.isNotEmpty(regionList)) {
                if ("市级".equals(regionList.get(0).get("level"))) {
                    useXzq = regionList.get(0).get("qhdm").toString();
                    if (useXzq.endsWith("00")) {
                        map.put("qhdm",useXzq);
                    } else {
                        map.put("qhdm",jrdbzlpjService.getCity(useXzq).get(0).get("QHDM"));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank(kssj)) {
            map.put("kssj",kssj);
        }
        if (StringUtils.isNotBlank(jssj)) {
            map.put("jssj",jssj);
        }
        if (StringUtils.isNotBlank(qhdm)) {
            if (qhdm.endsWith("00")) {
                map.put("qhdm",qhdm);
            } else {
                map.put("qhdm",jrdbzlpjService.getCity(qhdm).get(0).get("QHDM"));
            }
            map.put("fdm",qhdm);
            map.put("qhmc",jrdbzlpjService.getRegion(qhdm).get("QHMC"));
        } else {
            map.put("fdm",useXzq);
            map.put("qhmc",jrdbzlpjService.getRegion(useXzq).get("QHMC"));
        }
        jrdbzlpjService.exportDetail(request, response, map);
    }


}
