package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.service.LogService;
import cn.gtmap.realestate.supervise.server.service.MonitorService;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 监控统计
 */

@Controller
@RequestMapping("/jktj")
public class JktjController extends BaseController {


    @Autowired
    MonitorService monitorService;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    LogService logService;

    /**
     * 页面初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String getIndex(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        List<Map<String, String>> ywbmInfos = logService.getYwbmInfos();
        model.addAttribute("ywbmInfos", ywbmInfos);
        model.addAttribute("serverUrl", serverUrl);
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String,Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if(CollectionUtils.isNotEmpty(cityList)){
            model.addAttribute("xzqhInfos", cityList);
            model.addAttribute("flag","city");//省级平台
        }else{
            List<Map<String, Object>> xzqhInfos = xzqhInfoService.getQxxxByFdm(qhdm);
            model.addAttribute("xzqhInfos", xzqhInfos);
            model.addAttribute("flag","county");//市级平台
        }
        String regionName = getRegionName();
        String qhjb = getQhjb();
        if(StringUtils.isNotBlank(qhjb) && StringUtils.equals("省级",qhjb)){
            model.addAttribute("regionName", regionName);
            model.addAttribute("regionNameStr", regionName+"省");
        }else{
            model.addAttribute("regionName", regionName);
            model.addAttribute("regionNameStr", regionName);
        }
        if("32".equals(qhdm.substring(0, 2))){
            return "/join/jktj";
        }else {
            return "/join/jktjNew";
//            return "/join/jktj";
        }

}


    /**
     * 接入数量统计，上报数量与响应成功统计
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getJrslData")
    public List<Map<String, String>> getJrslData(String startTime, String endTime) {

        String tempStartTime = startTime.replace("-", "");
        String tempEndTime = endTime.replace("-", "");
        HashMap<String, String> map = new HashMap<>();
        map.put("startTime", tempStartTime);
        map.put("endTime", tempEndTime);

        List<Map<String, String>> resList = monitorService.getJrslData(map);
        return resList;
    }

    /**
     * 根据代码查询对应区县信息
     * @param fdm
     * @return
     */
    @ResponseBody
    @RequestMapping("getQxxxByFdm")
    public List<Map<String,String>> getQxxxByFdm(String startTime, String endTime,String fdm){
        String tempStartTime = startTime.replace("-", "");
        String tempEndTime = endTime.replace("-", "");
        HashMap<String, String> map = new HashMap<>();
        map.put("startTime", tempStartTime);
        map.put("endTime", tempEndTime);
        map.put("fdm",fdm);
        List<Map<String, String>> resList = monitorService.getQxxxByFdm(map);
        return resList;
    }

    /**
     * 接入数量统计、提供外围调用
     *
     * @param cityName
     * @param startTime
     * @param endTime
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getJrsl")
    public List<LinkedHashMap<String, String>> getJrsl(String cityName, String startTime, String endTime) {

        HashMap<String, String> map = new HashMap<>();
        if (StringUtils.isNotBlank(cityName)) {
            map.put("cityName", cityName);
        }
        if (StringUtils.isNotBlank(startTime)) {
            map.put("startTime", startTime);
        }
        if (StringUtils.isNotBlank(endTime)) {
            map.put("endTime", endTime);
        }
        List<LinkedHashMap<String, String>> resList = monitorService.getJrsl(map);
        return resList;
    }


    /**
     * 接入情况监控
     *
     * @param city
     * @param startTime
     * @param endTime
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getJrqkData")
    public List<Map<String, String>> getJrqkData(String city,String jrqkQxCity, String startTime, String endTime) {

        HashMap<String, String> map = new HashMap<>();

        if (StringUtils.isNotBlank(city) ) {
            map.put("city", city);//大市
        }
        if (StringUtils.isNotBlank(jrqkQxCity)) {
            map.put("county", jrqkQxCity);//区县
        }
        //陕西特殊地区、特殊处理 begin
        if(StringUtils.equals(city, Constant.YL) || StringUtils.equals(city,Constant.HC)){
            map.put("county", city);//区县
            map.put("city", "");//大市
        }
        //陕西特殊地区、特殊处理 end

        if (StringUtils.isNotBlank(startTime)) {
            map.put("startTime", startTime.replace("-",""));
        }
        if (StringUtils.isNotBlank(endTime)) {
            map.put("endTime", endTime.replace("-",""));
        }
        if (StringUtils.isBlank(startTime)) {
            String start = getStartTime();

            map.put("startTime", start.replace("-",""));
        }
        if (StringUtils.isBlank(endTime)) {
            String endStr = getEndTime();
            map.put("endTime", endStr.replace("-",""));
        }
        List<Map<String, String>> resList = monitorService.getJrqkData(map);
        return resList;
    }


    /**
     * 上报数量统计
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getSbslData")
    public List<Map<String, String>> getSbslData(String startTime, String endTime) {
        HashMap<String, String> map = new HashMap<>();
        String tempStartTime = startTime.replace("-", "");
        String tempEndTime = endTime.replace("-", "");
        map.put("startTime", tempStartTime);
        map.put("endTime", tempEndTime);
        List<Map<String, String>> resList = monitorService.getSbslData(map);
        return resList;
    }


    /**
     * 上报情况监控
     *
     * @param city
     * @param startTime
     * @param endTime
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getSbqkData")
    public List<Map<String, String>> getSbqkData(String city,String qxCity, String startTime, String endTime) {

        HashMap<String, String> map = new HashMap<>();
        if (StringUtils.isNotBlank(city)) {
            map.put("city", city);
        }
        if (StringUtils.isNotBlank(qxCity)) {
            map.put("county", qxCity);
        }
        //陕西特殊地区、特殊处理 begin
        if(StringUtils.equals(city,Constant.YL) || StringUtils.equals(city,Constant.HC)){
            map.put("county", city);//区县
            map.put("city", "");//大市
        }
        //陕西特殊地区、特殊处理 end
        if (StringUtils.isNotBlank(startTime)) {
            map.put("startTime", startTime.replace("-",""));
        }
        if (StringUtils.isNotBlank(endTime)) {
            map.put("endTime", endTime.replace("-",""));
        }
        if (StringUtils.isBlank(startTime)) {
            String start = getStartTime();

            map.put("startTime", start.replace("-",""));
        }
        if (StringUtils.isBlank(endTime)) {
            String endStr = getEndTime();
            map.put("endTime", endStr.replace("-",""));
        }
        List<Map<String, String>> resList = monitorService.getSbqkData(map);
        return resList;
    }


    /**
     * 获取系统当月第一天
     *
     * @return
     */
    public String getStartTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = TimeUtils.getBeginDayOfMonth();
        String start = sdf.format(begin);
        return start;
    }

    /**
     * 获取系统当月最后一天
     *
     * @return
     */
    public String getEndTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date end = TimeUtils.getEndDayOfMonth();
        String endStr = sdf.format(end);
        return endStr;
    }

    /**
     *  根据父代码查区县信息
     * @param fdm
     * @return
     */
    @RequestMapping("getQxxxByQhdm")
    @ResponseBody
    public List<Map<String, Object>> getQxxxByQhdm(String fdm){
        List<Map<String, Object>> qxxxList = xzqhInfoService.getQxxxByFdm(fdm);
        return qxxxList;
    }

    /**
     * 根据代码查询对应区县上报数量信息
     * @param fdm
     * @return
     */
    @ResponseBody
    @RequestMapping("getQxSbslByFdm")
    public List<Map<String,String>> getQxSbslByFdm(String startTime, String endTime,String fdm){
        String tempStartTime = startTime.replace("-", "");
        String tempEndTime = endTime.replace("-", "");
        HashMap<String, String> map = new HashMap<>();
        map.put("startTime", tempStartTime);
        map.put("endTime", tempEndTime);
        map.put("fdm",fdm);
        List<Map<String, String>> resList = monitorService.getQxSbslByFdm(map);
        return resList;
    }



    /**
     * 接入上报数量统计
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getJrsbslData")
    public List<Map<String, String>> getJrsbslData(String startTime, String endTime) {

        String tempStartTime = startTime.replace("-", "");
        String tempEndTime = endTime.replace("-", "");
        HashMap<String, String> map = new HashMap<>();
        map.put("startTime", tempStartTime);
        map.put("endTime", tempEndTime);

        List<Map<String, String>> resList = monitorService.getJrsbslData(map);
        return resList;
    }


    /**
     * 根据代码查询对应区县信息
     * @param fdm
     * @return
     */
    @ResponseBody
    @RequestMapping("getJrsbslByFdm")
    public List<Map<String,String>> getJrsbslByFdm(String startTime, String endTime,String fdm){
        String tempStartTime = startTime.replace("-", "");
        String tempEndTime = endTime.replace("-", "");
        HashMap<String, String> map = new HashMap<>();
        map.put("startTime", tempStartTime);
        map.put("endTime", tempEndTime);
        map.put("fdm",fdm);
        List<Map<String, String>> resList = monitorService.getJrsbslByFdm(map);
        return resList;
    }


    /**
     * 接入上报情况监控
     *
     * @param city
     * @param startTime
     * @param endTime
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getJrsbqkData")
    public List<Map<String, String>> getJrsbqkData(String city,String jrqkQxCity, String startTime, String endTime) {

        HashMap<String, String> map = new HashMap<>();

        if (StringUtils.isNotBlank(city) ) {
            map.put("city", city);//大市
        }
        if (StringUtils.isNotBlank(jrqkQxCity)) {
            map.put("county", jrqkQxCity);//区县
        }
        //陕西特殊地区、特殊处理 begin
        if(StringUtils.equals(city, Constant.YL) || StringUtils.equals(city,Constant.HC)){
            map.put("county", city);//区县
            map.put("city", "");//大市
        }
        //陕西特殊地区、特殊处理 end

        if (StringUtils.isNotBlank(startTime)) {
            map.put("startTime", startTime.replace("-",""));
        }
        if (StringUtils.isNotBlank(endTime)) {
            map.put("endTime", endTime.replace("-",""));
        }

        if (StringUtils.isBlank(startTime)) {
            String start = getStartTime();
            map.put("startTime", start.replace("-",""));
        }
        if (StringUtils.isBlank(endTime)) {
            String endStr = getEndTime();
            map.put("endTime", endStr.replace("-",""));
        }
        List<Map<String, String>> resList = monitorService.getJrsbqkData(map);
        return resList;
    }

}
