package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitmqClientQueueInfo;
import cn.gtmap.realestate.supervise.server.quartz.rabbitmqinfo.RabbitMqInfoScheduledTasks;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitMqInfoContain;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitServerConfig;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitServerInfo;
import cn.gtmap.realestate.supervise.server.service.ClientInfoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.List;

/**
 * Created by Administrator on 2018/4/11.
 * 客户端队列监控
 */
@Controller
@RequestMapping("dljk")
@Profile(value = "rabbitMQ")
public class DljkController {

    private static final Logger LOGGER = LoggerFactory.getLogger(DljkController.class);

    private static final String IO_EXCEPTION = "IOException:";

    @Autowired
    ClientInfoService clientInfoService;

    @Autowired
    RabbitMqInfoContain rabbitMqInfoContain;

    @Autowired
    RabbitServerInfo rabbitServerInfo;

    @Autowired
    RabbitMqInfoScheduledTasks rabbitMqInfoScheduledTasks;


    /**
     * 首页初始化
     *
     * @return
     */
    @RequestMapping("")
    public String index() {
        return "/join/dljk";
    }

    /**
     * 根据队列信息进行监控
     *
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getInfos")
    public List<RabbitmqClientQueueInfo> getInfos(String dlmc, String jrdmc, String yxzt) {

        List<ClientInfo> clientInfos = clientInfoService.getUserInfos(Maps.newHashMap());

        List<RabbitmqClientQueueInfo> resList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(clientInfos)) {
            RabbitServerConfig rabbitServerConfig = rabbitMqInfoScheduledTasks.getRabbitServerConfig();
            RabbitmqClientQueueInfo rabbitmqClientQueueInfo = null;
            for (ClientInfo clientInfo : clientInfos) {
                String queueName = clientInfo.getDlmc();
                String qxmc = clientInfo.getQxmc();

                //全查
                if (StringUtils.isNotBlank(queueName) && StringUtils.isEmpty(dlmc)
                        && StringUtils.isEmpty(jrdmc) && StringUtils.isEmpty(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String state = rabbitmqClientQueueInfo.getState();
                        if (StringUtils.isNotBlank(state)) {
                            String idle = rabbitmqClientQueueInfo.getIdle_since();
                            if (StringUtils.isNotBlank(idle)) {
                                rabbitmqClientQueueInfo.setState("idle");
                            } else {
                                rabbitmqClientQueueInfo.setState("running");
                            }
                            rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                            rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                            resList.add(rabbitmqClientQueueInfo);
                        }
                    }

                }
                //页面查询按钮操作逻辑
                //队列名称查询
                if (StringUtils.isNotBlank(queueName) && StringUtils.isNotBlank(dlmc) &&
                        StringUtils.contains(queueName, dlmc)
                        && StringUtils.isEmpty(jrdmc) && StringUtils.isEmpty(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String state = rabbitmqClientQueueInfo.getState();
                        if (StringUtils.isNotBlank(state)) {
                            String idle = rabbitmqClientQueueInfo.getIdle_since();
                            if (StringUtils.isNotBlank(idle)) {
                                rabbitmqClientQueueInfo.setState("idle");
                            } else {
                                rabbitmqClientQueueInfo.setState("running");
                            }
                            rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                            rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                            resList.add(rabbitmqClientQueueInfo);
                        }
                    }

                }
                //接入点名称
                if (StringUtils.isNotBlank(queueName) && StringUtils.isEmpty(dlmc) && StringUtils.contains(qxmc, jrdmc)
                        && StringUtils.isNotBlank(jrdmc) && StringUtils.isEmpty(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String state = rabbitmqClientQueueInfo.getState();
                        if (StringUtils.isNotBlank(state)) {
                            String idle = rabbitmqClientQueueInfo.getIdle_since();
                            if (StringUtils.isNotBlank(idle)) {
                                rabbitmqClientQueueInfo.setState("idle");
                            } else {
                                rabbitmqClientQueueInfo.setState("running");
                            }
                            rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                            rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                            resList.add(rabbitmqClientQueueInfo);
                        }
                    }


                }

                //运行状态
                if (StringUtils.isNotBlank(queueName) && StringUtils.isEmpty(dlmc)
                        && StringUtils.isEmpty(jrdmc) && StringUtils.isNotBlank(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String state = rabbitmqClientQueueInfo.getState();
                        String idle = rabbitmqClientQueueInfo.getIdle_since();
                        if (StringUtils.isNotBlank(state)) {
                            //空闲
                            if (StringUtils.isNotBlank(idle) && StringUtils.equals("idle", yxzt)) {
                                rabbitmqClientQueueInfo.setState("idle");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }
                            //运行
                            if (StringUtils.isNotBlank(state) && StringUtils.isBlank(idle) && StringUtils.equals(state, yxzt)) {
                                rabbitmqClientQueueInfo.setState("running");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }

                        }
                    }

                }

                //队列名称和接入点名称查询
                if (StringUtils.isNotBlank(queueName) && StringUtils.isNotBlank(dlmc)
                        && StringUtils.contains(queueName, dlmc) && StringUtils.contains(qxmc, jrdmc)
                        && StringUtils.isNotBlank(jrdmc) && StringUtils.isEmpty(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String state = rabbitmqClientQueueInfo.getState();
                        String idle = rabbitmqClientQueueInfo.getIdle_since();
                        if (StringUtils.isNotBlank(state)) {
                            if (StringUtils.isNotBlank(idle)) {
                                rabbitmqClientQueueInfo.setState("idle");
                            } else {
                                rabbitmqClientQueueInfo.setState("running");
                            }
                            rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                            rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                            resList.add(rabbitmqClientQueueInfo);
                        }
                    }

                }

                //队列名称和运行状态
                if (StringUtils.isNotBlank(queueName) && StringUtils.isNotBlank(dlmc)
                        && StringUtils.contains(queueName, dlmc)
                        && StringUtils.isEmpty(jrdmc) && StringUtils.isNotBlank(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }

                    if(null!=rabbitmqClientQueueInfo){
                        String idle = rabbitmqClientQueueInfo.getIdle_since();
                        String state = rabbitmqClientQueueInfo.getState();
                        if (StringUtils.isNotBlank(state)) {
                            //空闲
                            if (StringUtils.isNotBlank(idle) && StringUtils.equals("idle", yxzt)) {
                                rabbitmqClientQueueInfo.setState("idle");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }
                            //运行
                            if (StringUtils.isNotBlank(state) &&StringUtils.isBlank(idle) && StringUtils.equals(state, yxzt)) {
                                rabbitmqClientQueueInfo.setState("running");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }

                        }
                    }

                }

                //接入点名称和运行状态
                if (StringUtils.isNotBlank(queueName) && StringUtils.isEmpty(dlmc)
                        && StringUtils.contains(qxmc, jrdmc)
                        && StringUtils.isNotBlank(jrdmc) && StringUtils.isNotBlank(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String idle = rabbitmqClientQueueInfo.getIdle_since();
                        String state = rabbitmqClientQueueInfo.getState();
                        if (StringUtils.isNotBlank(state)) {
                            //空闲
                            if (StringUtils.isNotBlank(idle) && StringUtils.equals("idle", yxzt)) {
                                rabbitmqClientQueueInfo.setState("idle");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }
                            //运行
                            if (StringUtils.isNotBlank(state)&&StringUtils.isBlank(idle) && StringUtils.equals(state, yxzt)) {
                                rabbitmqClientQueueInfo.setState("running");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }
                        }
                    }

                }

                //全条件匹配
                if (StringUtils.isNotBlank(queueName) && StringUtils.isNotBlank(dlmc)
                        && StringUtils.contains(qxmc, jrdmc) && StringUtils.contains(queueName, dlmc)
                        && StringUtils.isNotBlank(jrdmc) && StringUtils.isNotBlank(yxzt)) {
                    try {
                        rabbitmqClientQueueInfo = rabbitServerInfo.getRabbitMqClientQueueInfo(rabbitServerConfig, queueName);
                    } catch (IOException e) {
                        LOGGER.info(IO_EXCEPTION + e);
                    }
                    if(null!=rabbitmqClientQueueInfo){
                        String idle = rabbitmqClientQueueInfo.getIdle_since();
                        String state = rabbitmqClientQueueInfo.getState();
                        if (StringUtils.isNotBlank(state)) {
                            //空闲
                            if (StringUtils.isNotBlank(idle) && StringUtils.equals("idle", yxzt)) {
                                rabbitmqClientQueueInfo.setState("idle");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }
                            //运行
                            if (StringUtils.isNotBlank(state)&&StringUtils.isBlank(idle) && StringUtils.equals(state, yxzt)) {
                                rabbitmqClientQueueInfo.setState("running");
                                rabbitmqClientQueueInfo.setQueueName(clientInfo.getDlmc());
                                rabbitmqClientQueueInfo.setJrdmc(clientInfo.getQxmc());
                                resList.add(rabbitmqClientQueueInfo);
                            }
                        }
                    }
                }
            }
        }
        return resList;
    }

}
