package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.server.service.BwcxrkrzService;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 报文重新入库
 */
@Controller
@RequestMapping("bwcxrkrz")
public class BwcxrkrzController extends BaseController {


    @Autowired
    private Repository repository;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    private BwcxrkrzService bwcxrkrzService;

    /**
     * 页面初始化
     * @param model
     * @return
     */
    @RequestMapping("")
    public String index(Model model)  {
        String  serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String,Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if(CollectionUtils.isNotEmpty(cityList)){
            model.addAttribute("cityList", cityList);
            model.addAttribute("flag","city");//省级平台
        }else{
            List<Map<String, Object>> xzqhInfos = xzqhInfoService.getQxxxByFdm(qhdm);
            model.addAttribute("cityList", xzqhInfos);
            model.addAttribute("flag","county");//市级平台
        }
        return "/join/bwcxrkrz";
    }

    /**
     * 查询数据
     * @param startDate
     * @param endDate
     * @return
     */
    @ResponseBody
    @RequestMapping("/select")
    public Page<List<Map<String, String>>> selectBwcxrk(String bwmc, String rkjg, String dsCode, String qxCode, Date startDate, Date endDate, Pageable pageable) {
        Map<String, Object> param = Maps.newHashMap();
        if(StringUtils.isNotBlank(bwmc)){
            param.put("bwmc", bwmc);
        }
        if(StringUtils.isNotBlank(rkjg)){
            param.put("rkjg", rkjg);
        }
        if(StringUtils.isNotBlank(dsCode)) {
            param.put("dsCode", dsCode);
        }
        if(StringUtils.isNotBlank(qxCode)){
            param.put("qxCode", qxCode);
        }
        if(startDate != null) {
            param.put("startDate", startDate);
        }
        if(endDate != null) {
            param.put("endDate", endDate);
        }
        Page<List<Map<String, String>>> BwcxrkrzList = repository.selectPaging("queryBwcxrkrzByPage", param, pageable);
        return BwcxrkrzList;
    }

    @ResponseBody
    @RequestMapping(value = "querySbyyDetail", method = RequestMethod.POST)
    public Map<String, Object> querySbyyDetail(String id) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id",id);
        Map<String, Object> resdata = bwcxrkrzService.querySbyyDetail(param);
        return resdata;
    }

}
