package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.entity.Babwcxrkxx;
import cn.gtmap.realestate.supervise.server.service.impl.BwcxrkServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 报文重新入库
 */
@Controller
@RequestMapping("bwcxrk")
public class BwcxrkController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(BwcxrkController.class);

    private static final String SCUUESS = "success";

    private static final String FAILURE = "failure";

    private static final String RETURNMSG = "returnMsg";

    @Autowired
    private BwcxrkServiceImpl bwcxrkService;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    private Repository repository;

    /**
     * 页面初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String index(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        model.addAttribute("serverUrl", serverUrl);
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            model.addAttribute("cityList", cityList);
            model.addAttribute("flag", "city");//省级平台
        } else {
            List<Map<String, Object>> xzqhInfos = xzqhInfoService.getQxxxByFdm(qhdm);
            model.addAttribute("cityList", xzqhInfos);
            model.addAttribute("flag", "county");//市级平台
        }
        return "/join/bwcxrk";
    }


    /**
     * 重新入库开始操作
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @param httpServletRequest
     * @return
     */
    @RequestMapping("dataHandle")
    @ResponseBody
    public Object bwcxrk(String qhdm, Date kssj, Date jssj, HttpServletRequest httpServletRequest) {
        UserAuthDTO userAuthDTO = getCurrentUser(httpServletRequest);
        Map<String, Object> param = Maps.newHashMap();
        param.put("qhdm", qhdm);
        param.put("kssj", "");
        param.put("jssj", "");
        if (null != kssj) {
            param.put("kssj", TimeUtils.dateToStr(kssj, "yyyyMMdd"));
        }
        if (null != jssj) {
            param.put("jssj", TimeUtils.dateToStr(jssj, "yyyyMMdd"));
        }
        bwcxrkService.dataHandle(param, userAuthDTO, httpServletRequest);
        return Maps.newHashMap();
    }

    /**
     * 查询数据
     *
     * @param dsCode
     * @param qxCode
     * @param rkzt
     * @param pageable
     * @return
     */
    @ResponseBody
    @RequestMapping("/select")
    public Page<List<Map<String, String>>> selectBwcxrk(String dsCode, String qxCode, String rkzt, Pageable pageable) {
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotBlank(dsCode)) {
            param.put("dsCode", dsCode);
        }
        if (StringUtils.isNotBlank(qxCode)) {
            param.put("qxCode", qxCode);
        }
        if (StringUtils.isNotBlank(rkzt)) {
            param.put("rkzt", rkzt);
        }
        return repository.selectPaging("queryBwcxrkByPage", param, pageable);
    }


    /**
     * 更新数据：入库开始时间、入库结束时间
     *
     * @param babwcxrkxx
     * @param request
     * @return
     */
    @ResponseBody
    @RequestMapping("/updateRkkjsjAndrkjssj")
    public Map<String, Object> updateRkkjsjAndrkjssj(Babwcxrkxx babwcxrkxx, HttpServletRequest request) {
        Map<String, Object> resultMap = Maps.newHashMap();
        UserAuthDTO userInfos = getCurrentUser(request);
        try {
            bwcxrkService.updateRkkjsjAndrkjssj(babwcxrkxx, userInfos);
        } catch (DataAccessException e) {
            LOGGER.error("DataAccessException:", e);
            resultMap.put(RETURNMSG, FAILURE);
            return resultMap;
        }
        resultMap.put(RETURNMSG, SCUUESS);
        return resultMap;
    }


    /**
     * 更新数据：入库状态
     *
     * @param babwcxrkxx
     * @param request
     * @return
     */
    @ResponseBody
    @RequestMapping("/updateRkzt")
    public Map<String, Object> updateRkzt(Babwcxrkxx babwcxrkxx, HttpServletRequest request) {
        Map<String, Object> resultMap = Maps.newHashMap();
        UserAuthDTO userInfos = getCurrentUser(request);
        try {
            bwcxrkService.updateRkzt(babwcxrkxx, userInfos);
        } catch (DataAccessException e) {
            LOGGER.error("DataAccessException:{}", e);
            resultMap.put(RETURNMSG, FAILURE);
            return resultMap;
        }
        resultMap.put(RETURNMSG, SCUUESS);
        return resultMap;
    }

}
