package cn.gtmap.realestate.supervise.server.web;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.quartz.es.EsScheduledTasks;
import cn.gtmap.realestate.supervise.server.service.impl.BwcxrkServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.LogServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.XzqhInfoServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 报文查询
 */
@Controller
@RequestMapping("/bwcx")
public class BwcxController extends BaseController {


    @Autowired
    private LogServiceImpl logService;

    @Autowired
    private SearchService searchService;

    @Autowired
    private EsScheduledTasks esScheduledTasks;

    @Autowired
    private Repository repository;

    @Autowired
    private XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    private BaRzjlMapper baRzjlMapper;

    @Autowired
    private BwcxrkServiceImpl bwcxrkService;

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    /**
     * 报文查询页面初始化
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String logQuery(Model model) {
        String serverUrl = AppConfig.getProperty("server.url");
        List<Map<String, String>> ywbmInfos = logService.getYwbmInfos();
        model.addAttribute("ywbmInfos", ywbmInfos);
        model.addAttribute("serverUrl", serverUrl);
        String qhdm = AppConfig.getProperty("region.qhdm");
        String qhmc = baXzqhMapper.getQhmcByqhdm(qhdm);
        List<Map<String, Object>> cityList = xzqhInfoService.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            model.addAttribute("cityList", cityList);
            model.addAttribute("flag", "city");//省级平台
        } else {
            List<Map<String,Object>> dsInfos = new ArrayList<>();
            Map<String,Object> dsmap = new HashMap<>();
            dsmap.put("QHMC",qhmc);
            dsmap.put("QHDM",qhdm);
            dsInfos.add(dsmap);
            model.addAttribute("cityList", dsInfos);
            model.addAttribute("flag", "county");//市级平台
        }

        if(qhdm.substring(0,2).equals("32")){
            return "/join/bwcx";
        }else {
            return "/join/bwcxSX";
        }
    }


    /**
     * 报文查询按钮操作
     *
     * @param bdcdyh
     * @param kssj
     * @param jssj
     * @param ywbm
     * @param xyjg
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "queryBwInfos")
    public Object queryBwInfos(String bdcdyh, Date kssj, Date jssj, String ywbm, String dsCode, String qxCode, String jcjg, String xyjg, Pageable pageable) {
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotBlank(bdcdyh)) {
            param.put("bdcdyh", bdcdyh);
        }
        if (StringUtils.isNotBlank(ywbm)) {
            param.put("ywbm", ywbm);
        }
        if (StringUtils.isNotBlank(dsCode)) {
            param.put("dsCode", dsCode);
        }
        if (StringUtils.isNotBlank(qxCode)) {
            param.put("qxCode", qxCode);
        }
        //陕西特殊地区、特殊处理 begin
        if (StringUtils.equals(dsCode, Constant.YL) || StringUtils.equals(dsCode, Constant.HC)) {
            param.put("qxCode", dsCode);//区县
            param.put("dsCode", "");//大市
        }
        //陕西特殊地区、特殊处理 end
        if (null != kssj) {
            param.put("kssj", TimeUtils.dateToStr(kssj, "yyyyMMdd"));
        }
        if (null != jssj) {
            param.put("jssj", TimeUtils.dateToStr(jssj, "yyyyMMdd"));
        }

        if (StringUtils.isNotBlank(jcjg)) {
            param.put("jcjg", jcjg);
        }
        if (StringUtils.isNotBlank(xyjg)) {
            if (StringUtils.equals(xyjg, "0")) {
                param.put("rkjg", "成功");
            }
            if (StringUtils.equals(xyjg, "1")) {
                param.put("rkjg", "失败");
            }

        }

        if (null == kssj && StringUtils.isBlank(bdcdyh) && StringUtils.isBlank(ywbm)
                && StringUtils.isBlank(dsCode) && StringUtils.isBlank(qxCode) && StringUtils.isBlank(xyjg) && null == jssj) {
            param.put("kssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(-30), "yyyyMMdd"));
        }
        if (null == jssj && StringUtils.isBlank(bdcdyh) && StringUtils.isBlank(ywbm)
                && StringUtils.isBlank(dsCode) && StringUtils.isBlank(qxCode) && StringUtils.isBlank(xyjg) && null == kssj) {
            param.put("jssj", TimeUtils.dateToStr(TimeUtils.getBeforeDay(0), "yyyyMMdd"));
        }
        Page<List<Map<String, String>>> resList = repository.selectPaging("getBwInfosByPage", param, pageable);
        return resList;
    }

    /**
     * 查看业务报文内容
     *
     * @param bwlj
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "searchbw", method = RequestMethod.POST)
    public Map<String, String> searchBw(String bwlj, String ywbwid) {
        Map<String, String> data = new HashMap<>();
        String xmlFormat = searchService.mainGetData(bwlj, "", "", ywbwid, "");
        data.put("bw", xmlFormat);
        return data;
    }

    /**
     * 响应报文
     *
     * @param fhbwlj
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "searchfhbw", method = RequestMethod.POST)
    public Map<String, String> searchFhBw(String fhbwlj, String xybm, String xybwid) {
        Map<String, String> data = new HashMap<>();
        String xmlFormat = searchService.mainGetData(fhbwlj, xybm, "", "", xybwid);
        data.put("bw", xmlFormat);
        return data;
    }

    /**
     * 响应报文
     *
     * @param id
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "searchfhbwErrMsg", method = RequestMethod.POST)
    public Map<String, String> searchfhbwErrMsg(String id) {
        Map<String, String> data = new HashMap<>();
        String result = baRzjlMapper.getfhbwErrMsg(id);
        data.put("bw", result);
        return data;
    }


    /**
     * 本地报文放到ES
     */
    @ResponseBody
    @RequestMapping("/dataHandleToES")
    public void dataHandle() {
        esScheduledTasks.handleEsInfos();
    }

    /**
     * 删除ES数据
     */
    @ResponseBody
    @RequestMapping("/dataDelFromES")
    public void dataDelHandle() {
        searchService.recreateIndex();
    }


    /**
     * 报文手动重新入库&上报
     *
     * @param fileNames
     * @param request
     * @return
     */
    @RequestMapping("bwsdrkHandle")
    @ResponseBody
    public Object bwsdrkHandle(String fileNames, HttpServletRequest request) {

        UserAuthDTO userInfos =  getCurrentUser(request);
        bwcxrkService.bwsdrkHandle(fileNames, userInfos, request);
        return Maps.newHashMap();
    }
}
