package cn.gtmap.realestate.supervise.server.utils;

import cn.gtmap.realestate.supervise.utils.FileUtil;
import cn.gtmap.realestate.supervise.utils.XmlStemFilter;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/6/23 取xsd校验模板
 * @description
 */
public class XsdUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(XsdUtil.class);

    private static Map<String, String> data = new HashMap<String, String>();

    public static void InitXsdData(String path) {
        XsdStemFilter xsdStemFilter = new XsdStemFilter();
        List<File> files = XsdUtil.getFiles(path);
        for (File f : files) {
            if (xsdStemFilter.accept(f)) {
                data.put(f.getName().split("\\.")[0], FileUtil.getFileString(f));
            }
        }
    }


    public static String getTemplateByRecType(String recType) {
        if (null == data || data.isEmpty()) {
            String xsdTemplatePath = AppConfig.getProperty("supervise.xsd.template");
            InitXsdData(xsdTemplatePath);
        }
        String tempString = data.get(recType);
        return tempString;
    }


    public static List<File> getFiles(String path) {
        List<File> filess = new ArrayList<File>();
        File file = new File(path);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (null == files || files.length == 0) {
                LOGGER.info("文件夹是空的!");
                return null;
            } else {
                for (File file2 : files) {
                    if (file2.isDirectory()) {
                        String tempPath = file2.getAbsolutePath();
                        List<File> fileList = getFiles(tempPath);
                        if (null != fileList && !fileList.isEmpty()) {
                            for (File fileTemp : fileList) {
                                filess.add(fileTemp);

                            }

                        }

                    } else {
                        filess.add(file2);
                    }
                }
            }
        } else {
            file.mkdirs();
        }
        return filess;
    }
}
