package cn.gtmap.realestate.supervise.server.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.List;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/6/27
 * @description 文件工具类
 */
public class FileUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);


    /**
     * 保存文件工具类
     *
     * @param data
     * @param filePath
     */
    public static synchronized void saveFile(byte[] data, String filePath, String fileOldname, String fileNewName) {
        LOGGER.info("上报部里开始写文件,旧文件名称:{},新文件名称:{}", fileOldname, fileNewName);
        InputStream is = new ByteArrayInputStream(data);
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String filePathStr = filePath + fileOldname;
        FileOutputStream fos = null;
        int ch = 0;
        try {
            fos = new FileOutputStream(filePathStr);
            while ((ch = is.read()) != -1) {
                fos.write(ch);
            }
            fos.flush();//如果不手动刷新缓存并且关闭流,很可能文件内容为空
//            fos.getFD().sync();
//            fos.close();// sonar检查需要
//            is.close();// sonar检查需要
        } catch (IOException e1) {
            LOGGER.error("FileUtils.IOException in!{},old文件名字:{},new文件名字:{},filePath:{}", e1, fileOldname, fileNewName, filePath);
        } finally {
            try {
                if (null != fos) {
                    fos.close();
                }
                if (null != is) {
                    is.close();
                }
            } catch (IOException e) {
                LOGGER.error("上报部里写文件失败!{},old文件名字:{},new文件名字:{},filePath:{}", e, fileOldname, fileNewName, filePath);
            } finally {
                LOGGER.info("上报部里写文件结束文件路径!{}", filePathStr);
                renameFile(filePath, fileOldname, fileNewName);
            }
        }
    }


    /**
     * 文件重命名
     *
     * @param path    文件目录
     * @param oldname 原来的文件名
     * @param newname 新文件名
     */
    public static void renameFile(String path, String oldname, String newname) {
        //新的文件名和以前文件名不同时,才有必要进行重命名
        if (!oldname.equals(newname)) {
            File oldfile = new File(path + "/" + oldname);
            File newfile = new File(path + "/" + newname);
            if (!oldfile.exists()) {
                LOGGER.info("重命名文件不存在!{}", oldfile);
                return;//重命名文件不存在
            }
            if (newfile.exists()) {
                //若在该目录下已经有一个文件和新文件名相同，则不允许重命名
                oldfile.delete();
                LOGGER.info("重命名已经存在!{}", newname);
            } else {
                oldfile.renameTo(newfile);
                LOGGER.info("上报部里重命名文件结束!oldfile:{},newfile:{}", oldfile, newfile);
            }
        } else {
            LOGGER.info("新文件名和旧文件名相同!newName:{},oldName:{}", newname, oldname);
        }
    }

    public static byte[] getBytes(File file) {
        ByteSource byteSource;
        byteSource = Files.asByteSource(file);
        byte[] outBytes = new byte[0];
        try {
            outBytes = byteSource.read();
        } catch (IOException e) {
            LOGGER.error("解析文件异常:{}", e);
        }
        return outBytes;
    }


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param
     * @return
     * @description 获取配置的上报报文xml排除字段信息
     */
    public static List<String> getReportMessageExcludedFieldList() {
        List<String> reportMessageExcludedFieldList = null;
        String filePath = AppConfig.getProperty("egov.conf") + "server/ReportMessageExcludedFields.json";
        try {
            String osName = System.getProperty("os.name");
            if (osName.contains("Windows")) {
                filePath = filePath.substring(filePath.indexOf("/") + 1);
                filePath = new String(filePath.getBytes("UTF-8"), "ISO8859-1");
            } else {//linux
                filePath = filePath.substring(filePath.indexOf(":") + 1);
                filePath = new String(filePath.getBytes("UTF-8"), "ISO8859-1");
            }
            String reportMessageExcludedFields = readJsonFile(filePath);
            reportMessageExcludedFieldList = JSON.parseObject(reportMessageExcludedFields,List.class);
        }catch (Exception e) {
            LOGGER.error("FileUtils.getReportMessageExcludedFieldList Exception{}",e);
        }
        return reportMessageExcludedFieldList;
    }


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param jsonFilePath json文件磁盘路径
     * @return
     * @description 读取磁盘Json文件数据
     */
    public static String readJsonFile(String jsonFilePath){
        File dir = new File(jsonFilePath);
        if (!dir.exists()){
            LOGGER.error("FileUtils.readJsonFile:jsonFile not found!");
        }
        StringBuilder sb = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(dir);
            InputStreamReader isr = new InputStreamReader(fis,Constants.DEFAULT_CHARSET_UTF8);
            BufferedReader br = new BufferedReader(isr);
            String str = null;
            while ((str = br.readLine())!= null){
                sb.append(str);
            }
            br.close();
            isr.close();
            fis.close();
        } catch (Exception e) {
            LOGGER.error("FileUtils.readJsonFile Exception{}",e);
        }
        return sb.toString();
    }



}
