package cn.gtmap.realestate.supervise.server.utils;

import cn.gtmap.realestate.supervise.model.graph.base.Area;
import cn.gtmap.realestate.supervise.model.graph.base.Line;
import cn.gtmap.realestate.supervise.model.graph.base.Point;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjain</a>
 * @version 1.0, 2017/7/21
 * @description 图形工具
 */
public class Feature {

    private static final Logger LOGGER = LoggerFactory.getLogger(Feature.class);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 图形类型
     */
    private String type;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 图形点信息
     */
    private List coordinates = new ArrayList();

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 图形参数信息
     */
    private Object properties;

    public Feature() {
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(List coordinates) {
        this.coordinates = coordinates;
    }

    public Object getProperties() {
        return properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return json字符串
     * @description 重写toString()方法，通过fastjson拼接符合要求的json字符串
     */
    public String toString() {
        Map<String, Object> changeValue = new HashMap<String, Object>();
        Map<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        /**
         * 根据图形进行判断
         */
        if(type.equals("Polygon")) {
            if((coordinates instanceof Area)) {
                data.put("coordinates", coordinates);
            }
        }
        if(type.equals("LineString")) {
            if((coordinates instanceof Line)) {
                data.put("coordinates", coordinates);
            }
        }
        if(type.equals("Point")) {
            if((coordinates instanceof Point)) {
                data.put("coordinates", coordinates);
            }
        }
        changeValue.put("geometry", data);
        changeValue.put("type", "Feature");
        if(properties != null) {
            JSONObject t = (JSONObject)JSONObject.toJSON(properties);

            Map<String,Object> pro = new HashMap<String, Object>();

            for(Map.Entry<String,Object> entry : t.entrySet()) {
                pro.put(entry.getKey().toUpperCase(), entry.getValue());
            }

            changeValue.put("properties", pro);
        }else {
            LOGGER.info("数据为null");
        }
        return JSONObject.toJSONString(changeValue);
    }

}
