package cn.gtmap.realestate.supervise.server.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.entity.Error;
import cn.gtmap.realestate.supervise.server.entity.ErrorDetail;
import cn.gtmap.realestate.supervise.server.entity.Zlbg;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/10
 * @description Excel导出工具类
 */
public class ExportExcelUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExportExcelUtils.class);

    //方法初始化Map
    private static final List<String> keysList = Lists.newArrayList();

    private ExportExcelUtils() {
    }

    /**
     * 导出excel
     *
     * @param countList
     * @param errorList
     * @param response
     */
    public static void exportExcel(List<Zlbg> countList, List<Error> errorList, List<ErrorDetail> errorDetailList, HttpServletResponse response) {
        OutputStream fOut = null;
        String[] title = {"序号", "区县代码名称", "业务编码", "业务名称", "总数量", "成功数量", "成功率"};
        String[] errorTitle = {"序号", "失败原因代码", "数目"};
        String[] errorDetailTitle = {"序号", "报文名称", "不动产单元号", "报文检查结果"};

        try {
            // 进行转码，使其支持中文文件名
            String codedFileName = java.net.URLEncoder.encode("质量报告", "UTF-8");
            //读取固定模板excel
            String egovConf = AppConfig.getProperty("egov.conf");
            String filePath = egovConf + "/server/model.xlsx";
            String osName = System.getProperty("os.name");
            if (osName.contains("Windows")) {
                filePath = filePath.substring(filePath.indexOf("/") + 1);
            } else {//linux
                filePath = filePath.substring(filePath.indexOf(":") + 1);
            }

            FileInputStream fis = new FileInputStream(filePath);

            // 产生工作簿对象
            XSSFWorkbook workbook = new XSSFWorkbook(fis);
            //产生工作表对象
            workbook.setSheetName(0, "质量报告");
            workbook.setSheetName(1, "异常报告");
            workbook.setSheetName(2, "异常报告详细");
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFSheet errorSheet = workbook.getSheetAt(1);
            XSSFSheet errorDetailSheet = workbook.getSheetAt(2);
//            XSSFSheet sheet = workbook.createSheet("质量报告");
//            XSSFSheet errorSheet = workbook.createSheet("异常报告");
            XSSFRow row = sheet.createRow(0);
            XSSFRow rowError = errorSheet.createRow(0);
            XSSFRow rowErrorDetail = errorDetailSheet.createRow(0);
            for (int i = 0; i < title.length; i++) {
                XSSFCell hssfCell = row.createCell(i);
                hssfCell.setCellValue(title[i]);
            }
            for (int i = 0; i < errorTitle.length; i++) {
                XSSFCell hssfCell = rowError.createCell(i);
                hssfCell.setCellValue(errorTitle[i]);
            }
            for (int i = 0; i < errorDetailTitle.length; i++) {
                XSSFCell hssfCell = rowErrorDetail.createCell(i);
                hssfCell.setCellValue(errorDetailTitle[i]);
            }
            /** ***************以下是EXCEL正文数据********************* */
            Field[] fields;
            int i = 1;
            for (Object obj : countList) {
                fields = obj.getClass().getDeclaredFields();
                int j = 0;
                XSSFRow rowIndex = sheet.createRow(i);
                for (Field v : fields) {
                    v.setAccessible(true);
                    Object va = v.get(obj);
                    XSSFCell hssfCell = rowIndex.createCell(j);
                    if (null != va) {
                        hssfCell.setCellValue(va.toString());
                    }
                    j++;
                }
                i++;
            }


            Field[] fieldsError;
            int h = 1;
            for (Object obj : errorList) {
                fieldsError = obj.getClass().getDeclaredFields();
                int k = 0;
                XSSFRow rowIndex = errorSheet.createRow(h);
                for (Field v : fieldsError) {
                    v.setAccessible(true);
                    Object va = v.get(obj);
                    XSSFCell hssfCell = rowIndex.createCell(k);
                    hssfCell.setCellValue(va.toString());
                    k++;
                }
                h++;
            }

            Field[] fieldsErrorDetail;
            int g = 1;
            for (Object obj : errorDetailList) {
                fieldsErrorDetail = obj.getClass().getDeclaredFields();
                int k = 0;
                XSSFRow rowIndex = errorDetailSheet.createRow(g);
                for (Field v : fieldsErrorDetail) {
                    v.setAccessible(true);
                    Object va = v.get(obj);
                    XSSFCell hssfCell = rowIndex.createCell(k);
                    hssfCell.setCellValue(CommonUtil.formatEmptyValue(va));
                    k++;
                }
                g++;
            }

            response.reset();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName + ".xlsx");
            response.setHeader("Location", codedFileName + ".xlsx");
            fOut = response.getOutputStream();
            workbook.write(fOut);
            fOut.close();
        } catch (IOException ex) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException in !{}", ex.getMessage());
            throw new AppException(ex, 2005);
        } catch (IllegalAccessException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IllegalAccessException in !{}", e.getMessage());
            throw new AppException(e, 2005);
        }
        try {
            if (null != fOut) {
                fOut.flush();
                fOut.close();
            }
        } catch (IOException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException out !{}", e.getMessage());
            throw new AppException(e, 2005);
        }
    }


    /**
     * 接入情况统计
     * 汇总导出Excle
     *
     * @param tjxx     汇总信息
     * @param response
     */
    public static void exportSummary(List<Map<String, Object>> tjxx, String fileName, HttpServletResponse response, Map<String, String> param) {
        OutputStream fOut = null;
        try {
            // 进行转码，使其支持中文文件名
            String codedFileName = java.net.URLEncoder.encode(fileName, "UTF-8");
            //读取固定模板excel
            String egovConf = AppConfig.getProperty("egov.conf");
            String filePath = egovConf + "server/jrqktjTemplet.xlsx";
            filePath = filePath.substring(filePath.indexOf("/") + 1);
            FileInputStream fis = new FileInputStream(filePath);
            // 产生工作簿对象
            XSSFWorkbook workbook = new XSSFWorkbook(fis);
            CellStyle cellStyle = workbook.createCellStyle();
            XSSFFont xssfFont = workbook.createFont();
            xssfFont.setFontName("宋体");//字体
            xssfFont.setFontHeightInPoints((short) 9);//9号字体
            cellStyle.setFont(xssfFont);
            cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//左右居中
            cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//上下居中
            cellStyle.setWrapText(true);//自动换行
            cellStyle.setBorderBottom(CellStyle.BORDER_THIN); // 底部边框
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex()); // 底部边框颜色
            cellStyle.setBorderLeft(CellStyle.BORDER_THIN);  // 左边边框
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex()); // 左边边框颜色
            cellStyle.setBorderRight(CellStyle.BORDER_THIN); // 右边边框
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());  // 右边边框颜色
            cellStyle.setBorderTop(CellStyle.BORDER_THIN); // 上边边框
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());  // 上边边框颜色
            //产生工作表对象
            workbook.setSheetName(0, "接入情况统计信息");
            XSSFSheet sheet = workbook.getSheetAt(0);
            /** ***************以下是EXCEL正文数据********************* */
            XSSFRow rowIndex0 = sheet.createRow(0);
            CellStyle cellStyle0 = workbook.createCellStyle();
            rowIndex0.setHeight((short) 800);
            XSSFFont xssfFont0 = workbook.createFont();
            XSSFCell hssfCell0 = rowIndex0.createCell(0);
            xssfFont0.setFontHeightInPoints((short) 12);//9号字体
            xssfFont0.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
            String title = param.get("cityName") + "不动产信息平台接入情况统计表\n" +
                    "（" + param.get("startTime") + "~" + param.get("endTime") + "）";
            hssfCell0.setCellValue(title);
            cellStyle0.setFont(xssfFont0);
            cellStyle0.setAlignment(HSSFCellStyle.ALIGN_CENTER);//左右居中
            cellStyle0.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//上下居中
            cellStyle0.setWrapText(true);//自动换行
            hssfCell0.setCellStyle(cellStyle0);

            int i = 2;
            int j = 1;

            for (Map<String, Object> obj : tjxx) {
                XSSFRow rowIndex = sheet.createRow(i);
                XSSFCell hssfCell = rowIndex.createCell(0);
                hssfCell.setCellStyle(cellStyle);
                hssfCell.setCellValue(j);//序号
                hssfCell = rowIndex.createCell(1);
                hssfCell.setCellStyle(cellStyle);
                hssfCell.setCellValue((String) obj.get("QHMC"));//行政区划名称
                hssfCell = rowIndex.createCell(2);
                hssfCell.setCellStyle(cellStyle);
                hssfCell.setCellValue(String.valueOf(obj.get("QXSL")));//区县数量
                hssfCell = rowIndex.createCell(3);
                hssfCell.setCellStyle(cellStyle);
                hssfCell.setCellValue(String.valueOf(obj.get("ZJRL")));//总接入量
                hssfCell = rowIndex.createCell(4);
                hssfCell.setCellStyle(cellStyle);
                hssfCell.setCellValue(String.valueOf(obj.get("CGJRL")));//成功接入量
                hssfCell = rowIndex.createCell(5);
                hssfCell.setCellStyle(cellStyle);
                hssfCell.setCellValue(String.valueOf(obj.get("JRCGL")));//接入成功率
                hssfCell = rowIndex.createCell(6);
                hssfCell.setCellValue(String.valueOf(obj.get("JRCGLDF")));//接入成功率得分
                hssfCell.setCellStyle(cellStyle);
                hssfCell = rowIndex.createCell(7);
                hssfCell.setCellValue(String.valueOf(obj.get("WSCSJQXSL")));//未上传数据县区数量
                hssfCell.setCellStyle(cellStyle);
                hssfCell = rowIndex.createCell(8);
                hssfCell.setCellValue(String.valueOf(obj.get("SJJRDF")));//数据接入得分
                hssfCell.setCellStyle(cellStyle);
                hssfCell = rowIndex.createCell(9);
                hssfCell.setCellValue(String.valueOf(obj.get("WSCDBQXSL")));//未上传登簿日志县区数量
                hssfCell.setCellStyle(cellStyle);
                hssfCell = rowIndex.createCell(10);
                hssfCell.setCellValue(String.valueOf(obj.get("DBRZJRDF")));//登簿日志接入得分
                hssfCell.setCellStyle(cellStyle);
                hssfCell = rowIndex.createCell(11);
                hssfCell.setCellValue(String.valueOf(obj.get("JRZLZHPF")));//接入质量综合评分
                hssfCell.setCellStyle(cellStyle);
                j++;
                i++;
            }


            response.reset();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName + ".xlsx");
            response.setHeader("Location", codedFileName + ".xlsx");
            fOut = response.getOutputStream();
            workbook.write(fOut);
            fOut.close();
        } catch (IOException ex) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException in !{}", ex);
        }
        try {
            if (null != fOut) {
                fOut.flush();
                fOut.close();
            }
        } catch (IOException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException out !{}", e);
        }
    }


    /**
     * 特殊字段空项率统计导出Excle
     *
     * @param paramList 汇总信息
     * @param response
     */
    public static void exportTszdkxtjInfos(List<Map<String, Object>> paramList, String fileName, HttpServletResponse response) {
        OutputStream fOut = null;
        try {
//            // 进行转码，使其支持中文文件名
//            String codedFileName = new String(fileName.getBytes("ISO8859-1"), "utf-8");
//            // 注意在 windows 环境下需要用下面这行替换上面的转换，如果是 Linux 就需要这两行
            String codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");

            //读取固定模板excel
            String egovConf = AppConfig.getProperty("egov.conf");
            String filePath = egovConf + "server/tszdkxtj.xlsx";
            String osName = System.getProperty("os.name");
            if (osName.contains("Windows")) {
                filePath = filePath.substring(filePath.indexOf("/") + 1);
            } else {//linux
                filePath = filePath.substring(filePath.indexOf(":") + 1);
            }

            FileInputStream fis = new FileInputStream(filePath);
            // 产生工作簿对象
            XSSFWorkbook workbook = new XSSFWorkbook(fis);
            CellStyle cellStyle = workbook.createCellStyle();
            XSSFFont xssfFont = workbook.createFont();
            xssfFont.setFontHeightInPoints((short) 15);//9号字体
            xssfFont.setFontName("宋体");//字体
            cellStyle.setFont(xssfFont);
            cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//左右居中
            cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//上下居中
            cellStyle.setWrapText(true);//自动换行
            cellStyle.setBorderBottom(CellStyle.BORDER_THIN); // 底部边框
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex()); // 底部边框颜色
            cellStyle.setBorderLeft(CellStyle.BORDER_THIN);  // 左边边框
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex()); // 左边边框颜色
            cellStyle.setBorderRight(CellStyle.BORDER_THIN); // 右边边框
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());  // 右边边框颜色
            cellStyle.setBorderTop(CellStyle.BORDER_THIN); // 上边边框
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());  // 上边边框颜色
            //产生工作表对象
            workbook.setSheetName(0, "特殊字段空项率统计");
            XSSFSheet sheet = workbook.getSheetAt(0);
            /** ***************以下是EXCEL正文数据********************* */
//            String title = "江苏省不动产登记增量数据关键字段完整率统计（2018.11.26-2018.12.2）";


            int i = 3;
            if (CollectionUtils.isNotEmpty(paramList)) {
                for (int j = 0; j < paramList.size(); j++) {
                    Map<String, Object> temp = paramList.get(j);
                    XSSFRow rowIndex = sheet.createRow(i);
                    for (int k = 0; k < keysList.size(); k++) {
                        String key = keysList.get(k);
                        XSSFCell hssfCell = rowIndex.createCell(k);
                        hssfCell.setCellStyle(cellStyle);
                        hssfCell.setCellValue((String) temp.get(key));
                    }
                    i++;
                }
            }
            XSSFRow rowIndex0 = sheet.createRow(0);
            XSSFCell hssfCell0 = rowIndex0.createCell(0);
            hssfCell0.setCellStyle(cellStyle);
            hssfCell0.setCellValue(fileName);
            response.reset();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName + ".xlsx");
            response.setHeader("Location", codedFileName + ".xlsx");
            fOut = response.getOutputStream();
            workbook.write(fOut);
            fOut.close();
        } catch (IOException ex) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException in !{}", ex);
        }
        try {
            if (null != fOut) {
                fOut.flush();
                fOut.close();
            }
        } catch (IOException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException out !{}", e);
        }
    }

    static {
        keysList.add("qhmc");
        keysList.add(Constant.BDCDYH);
        keysList.add(Constant.BDCDJZMH);
        keysList.add(Constant.BDCQZH);
        keysList.add(Constant.DJLX);
        keysList.add(Constant.DJSJ);
        keysList.add(Constant.GHYT);
        keysList.add(Constant.GYFS);
        keysList.add(Constant.JZMJ);
        keysList.add(Constant.QLLX);
        keysList.add(Constant.QLRLX);
        keysList.add(Constant.QLRMC);
        keysList.add(Constant.QXDM);
        keysList.add(Constant.SLSJ);
        keysList.add(Constant.SYQMJ);
        keysList.add(Constant.YT);
        keysList.add(Constant.YWH);
        keysList.add(Constant.ZJH);
        keysList.add(Constant.FDCJYJG);
        keysList.add(Constant.BDBZZQSE);
        keysList.add(Constant.COUNT);
    }

    /**
     * 特殊字段空项率统计导出Excle
     *
     * @param paramList 汇总信息
     * @param response
     */
    public static void exportJrjcfkqkInfos(List<Map<String, Object>> paramList, String fileName
            , List<String> kxlKeysList, String modelName, HttpServletResponse response) {
        OutputStream fOut = null;
        try {
            String osName = System.getProperty("os.name");
            String codedFileName;
            //读取固定模板excel
            String egovConf = AppConfig.getProperty("egov.conf");
            String filePath = egovConf + "server/" + modelName + ".xlsx";
            if (osName.contains("Windows")) {
                filePath = filePath.substring(filePath.indexOf("/") + 1);
                codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            } else {//linux
                filePath = filePath.substring(filePath.indexOf(":") + 1);
                codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            }

            FileInputStream fis = new FileInputStream(filePath);
            XSSFWorkbook workbook = new XSSFWorkbook(fis);

            //产生工作表对象
            XSSFSheet sheet = workbook.getSheetAt(0);
            /** ***************以下是EXCEL正文数据********************* */

            int i = 2;
            if (CollectionUtils.isNotEmpty(paramList)) {
                for (int j = 0; j < paramList.size(); j++) {
                    Map<String, Object> temp = paramList.get(j);
                    XSSFRow rowIndex = sheet.getRow(i);
                    for (int k = 0; k < kxlKeysList.size(); k++) {
                        String key = kxlKeysList.get(k);
                        XSSFCell hssfCell = rowIndex.getCell(k);
                        hssfCell.setCellValue(MapUtils.getString(temp, key));
                    }
                    i++;
                }
            }

            XSSFRow rowIndex0 = sheet.getRow(0);
            XSSFCell hssfCell0 = rowIndex0.getCell(0);
            hssfCell0.setCellValue(fileName);

            response.reset();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName + ".xlsx");
            response.setHeader("Location", codedFileName + ".xlsx");
            fOut = response.getOutputStream();
            workbook.write(fOut);
            fOut.close();
        } catch (IOException ex) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException in !{}", ex);
        }
        try {
            if (null != fOut) {
                fOut.flush();
                fOut.close();
            }
        } catch (IOException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException out !{}", e);
        }
    }

    /**
     * 特殊字段空项率统计导出Excle
     *
     * @param paramList 汇总信息
     * @param response
     */
    public static void exportDbzlInfos(List<Map<String, Object>> paramList, String fileName
            , List<String> kxlKeysList, String modelName, HttpServletResponse response) {
        OutputStream fOut = null;
        try {
            String osName = System.getProperty("os.name");
            String codedFileName;
            //读取固定模板excel
            String egovConf = AppConfig.getProperty("egov.conf");
            String filePath = egovConf + "server/" + modelName + ".xlsx";
            if (osName.contains("Windows")) {
                filePath = filePath.substring(filePath.indexOf("/") + 1);
                codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            } else {//linux
                filePath = filePath.substring(filePath.indexOf(":") + 1);
                codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            }

            FileInputStream fis = new FileInputStream(filePath);
            XSSFWorkbook workbook = new XSSFWorkbook(fis);

            //产生工作表对象
            XSSFSheet sheet0 = workbook.getSheetAt(0);
            XSSFSheet sheet1 = workbook.getSheetAt(1);

            /** ***************以下是EXCEL正文数据********************* */

            int i0 = 2;
            int index0 = 0;

            List<Map<String, Object>> cityList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(paramList)) {
                for (int j = 0; j < paramList.size(); j++) {
                    Map<String, Object> temp = paramList.get(j);
                    if (temp.containsKey("children")) {
                        cityList.add(temp);
                    }
                }
            }
            cityList = sortList(cityList);
            List<Map<String, Object>> newCityList = Lists.newArrayList();
            for (int j = 0; j < paramList.size(); j++) {
                Map<String, Object> temp = paramList.get(j);
                if (MapUtils.getString(temp, "CITY_QHDM").length() < 3) {
                    //cityList.add(temp);
                    newCityList.add(temp);
                }
            }
            newCityList.addAll(cityList);

            if (CollectionUtils.isNotEmpty(newCityList)) {
                for (int j = 0; j < newCityList.size(); j++) {
                    Map<String, Object> temp = newCityList.get(j);
                    if (temp.containsKey("children")) {
                        temp.put("XH", index0++);
                        XSSFRow rowIndex = sheet0.getRow(i0);
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                        i0++;
                    } else if (MapUtils.getString(temp, "CITY_QHDM").length() < 3) {
                        temp.put("XH", index0++);
                        XSSFRow rowIndex = sheet0.getRow(i0);
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                        i0++;
                    }
                }
            }

            int i1 = 3;
            int index1 = 0;
            if (CollectionUtils.isNotEmpty(paramList)) {
                Map<String, Object> temp = paramList.get(paramList.size() - 1);
                if (MapUtils.getString(temp, "CITY_QHDM").length() < 3) {
                    temp.put("XH", index1++);
                    XSSFRow rowIndex = sheet1.getRow(i1);
                    for (int k = 0; k < kxlKeysList.size(); k++) {
                        String key = kxlKeysList.get(k);
                        XSSFCell hssfCell = rowIndex.getCell(k);
                        hssfCell.setCellValue(MapUtils.getString(temp, key));
                    }
                    i1++;
                    paramList.remove(paramList.size() - 1);
                }
            }

            if (CollectionUtils.isNotEmpty(paramList)) {
                for (int j = 0; j < paramList.size(); j++) {
                    Map<String, Object> temp = paramList.get(j);
                    temp.put("XH", index1++);
                    XSSFRow rowIndex = sheet1.getRow(i1);
                    if (temp.containsKey("children") || MapUtils.getString(temp, "CITY_QHDM").length() < 3) {
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                    } else {
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                    }

                    i1++;
                }
            }

            XSSFRow rowIndex0 = sheet0.getRow(0);
            XSSFRow rowIndex1 = sheet1.getRow(0);
            XSSFCell hssfCell0 = rowIndex0.getCell(0);
            XSSFCell hssfCell1 = rowIndex1.getCell(0);
            hssfCell0.setCellValue(fileName);
            hssfCell1.setCellValue(fileName);
            response.reset();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName + ".xlsx");
            response.setHeader("Location", codedFileName + ".xlsx");
            fOut = response.getOutputStream();
            workbook.write(fOut);
            fOut.close();
        } catch (IOException ex) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException in !{}", ex);
        }
        try {
            if (null != fOut) {
                fOut.flush();
                fOut.close();
            }
        } catch (IOException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException out !{}", e);
        }
    }

    /**
     * 特殊字段空项率统计导出Excle
     *
     * @param paramList 汇总信息
     * @param response
     */
    public static void exportKxlInfos(List<Map<String, Object>> paramList, String fileName
            , List<String> kxlKeysList, String modelName, HttpServletResponse response) {
        OutputStream fOut = null;
        try {
            String osName = System.getProperty("os.name");
            String codedFileName;
            //读取固定模板excel
            String egovConf = AppConfig.getProperty("egov.conf");
            String filePath = egovConf + "server/" + modelName + ".xlsx";
            if (osName.contains("Windows")) {
                filePath = filePath.substring(filePath.indexOf("/") + 1);
                codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            } else {//linux
                filePath = filePath.substring(filePath.indexOf(":") + 1);
                codedFileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            }

            FileInputStream fis = new FileInputStream(filePath);
            XSSFWorkbook workbook = new XSSFWorkbook(fis);

            //产生工作表对象
            XSSFSheet sheet0 = workbook.getSheetAt(0);
            XSSFSheet sheet1 = workbook.getSheetAt(1);


            /** ***************以下是EXCEL正文数据********************* */

            int i0 = 4;
            if (CollectionUtils.isNotEmpty(paramList)) {
                for (int j = 0; j < paramList.size(); j++) {
                    Map<String, Object> temp = paramList.get(j);
                    XSSFRow rowIndex1 = sheet1.getRow(i0);
                    if (temp.containsKey("children") || MapUtils.getString(temp, "CITY_QHDM").length() < 3) {
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex1.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                    } else {
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex1.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                    }
                    i0++;
                }
            }

            int i1 = 4;
            if (CollectionUtils.isNotEmpty(paramList)) {
                for (int j = 0; j < paramList.size(); j++) {
                    Map<String, Object> temp = paramList.get(j);
                    XSSFRow rowIndex0 = sheet0.getRow(i1);
                    if (temp.containsKey("children") || MapUtils.getString(temp, "CITY_QHDM").length() < 3) {
                        temp.put("XH", i1 - 4);
                        for (int k = 0; k < kxlKeysList.size(); k++) {
                            String key = kxlKeysList.get(k);
                            XSSFCell hssfCell = rowIndex0.getCell(k);
                            hssfCell.setCellValue(MapUtils.getString(temp, key));
                        }
                        i1++;
                    }
                }
            }

            XSSFRow rowIndex0 = sheet0.getRow(0);
            XSSFRow rowIndex1 = sheet1.getRow(0);
            XSSFCell hssfCell0 = rowIndex0.getCell(0);
            XSSFCell hssfCell1 = rowIndex1.getCell(0);
            hssfCell0.setCellValue(fileName);
            hssfCell1.setCellValue(fileName);
            response.reset();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName + ".xlsx");
            response.setHeader("Location", codedFileName + ".xlsx");
            fOut = response.getOutputStream();
            workbook.write(fOut);
            fOut.close();
        } catch (IOException ex) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException in !{}", ex);
        }
        try {
            if (null != fOut) {
                fOut.flush();
                fOut.close();
            }
        } catch (IOException e) {
            LOGGER.error("ExportExcelUtils.exportExcel IOException out !{}", e);
        }
    }

    /**
     * 排序
     *
     * @param list
     * @return
     */
    private static List<Map<String, Object>> sortList(List<Map<String, Object>> list) {
        Collections.sort(list, new Comparator<Map<String, Object>>() {
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Double dm1 = Double.parseDouble(MapUtils.getString(o1, "ZHPF"));
                Double dm2 = Double.parseDouble(MapUtils.getString(o2, "ZHPF"));
                return (new Double(dm2*100 - dm1*100)).intValue();
            }
        });
        return list;
    }
}
