package cn.gtmap.realestate.supervise.server.utils;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/4/17
 * @description 获取已经注册的的FileSendService
 */
@Service
public class BeanUtils implements BeanFactoryAware {
    // Spring的bean工厂
    private static volatile  BeanFactory beanFactory;

    @Override
    public  void setBeanFactory(BeanFactory factory) throws BeansException {
        beanFactory = factory;
    }
    public static<ServeDetail> ServeDetail getBean(String name){
        return (ServeDetail) beanFactory.getBean(name);
    }

    public static<FileSendService> FileSendService getFileSendService(String name) {
        return (FileSendService) beanFactory.getBean(name);
    }

    public static<DataInsertDbService> DataInsertDbService getDataInsertDbService() {
        return (DataInsertDbService) beanFactory.getBean("dataInsertDbService");
    }

    public static<SystemWebSocketHandler> SystemWebSocketHandler getSystemWebSocketHandler() {
        return (SystemWebSocketHandler) beanFactory.getBean("systemWebSocketHandler");
    }
}