package cn.gtmap.realestate.supervise.server.socket;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/9/2
 * @description
 */
@Configuration
@EnableWebMvc
@EnableWebSocket
public class SocketConfig extends WebMvcConfigurerAdapter implements WebSocketConfigurer {

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {

        //支持nginx配置
        registry.addHandler(systemWebSocketHandler(), "/webSocketServer").addInterceptors(new MyWebSocketInterceptor()).setAllowedOrigins("*");
        registry.addHandler(systemWebSocketHandler(), "/sockjs/webSocketServer").addInterceptors(new MyWebSocketInterceptor()).withSockJS();
    }

    @Bean
    public WebSocketHandler systemWebSocketHandler() {
        return new SocketHandler();
    }

}