package cn.gtmap.realestate.supervise.server.sftp;


import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.model.MessageServer;
import cn.gtmap.realestate.supervise.model.Respond;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertPulbicRZJLDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaJrdMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.entity.PublicRzJl;
import cn.gtmap.realestate.supervise.server.entity.Qxsbjkxx;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.rabbitmq.SendMessage;
import cn.gtmap.realestate.supervise.server.rocketmq.ProducerMsg;
import cn.gtmap.realestate.supervise.server.service.MonitorService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/7/21
 * @description 监听文件夹工具
 */
@Service
public class WatchDirService {

    private static final Logger LOGGER = LoggerFactory.getLogger(WatchDirService.class);

    String qxdm = AppConfig.getProperty("supersive.server.qhdm");//需要转换的区划代码

    @Autowired
    SftpService sftpService;

    @Autowired
    InsertPulbicRZJLDaoImpl insertPublicRZJLDao;

    @Autowired
    BaSftpMapper baSftpMapper;

    @Autowired
    MonitorService monitorService;

    @Autowired
    BaXzqhMapper baXzqhMapper;

    @Autowired
    BaRzjlMapper baRzjlMapper;

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    private BaJrdMapper baJrdMapper;

    private SendMessage sendMessage;

    @Autowired
    private DataInsertDbService dataInsertDbService;

    private ProducerMsg producerMsg;


    @Autowired
    SearchService searchService;


    /**
     * 上报记录日志
     *
     * @param head
     * @param fileName
     * @param khdbm
     * @return
     */
    public boolean uploadFileRzjl(Map<String, String> head, String fileName, String khdbm, String ywh, String bwid, String jrxzqdm) {

        boolean res = true;
        try {
            String areaCode = head.get("AreaCode");
            String exchangeQxdm = XmlUtil.getExhangeQxdm(qxdm, jrxzqdm);
            if (StringUtils.isNotBlank(exchangeQxdm)) {
                areaCode = exchangeQxdm;
            }
            String qhmc = baXzqhMapper.getCityInfoByqhdm(areaCode);
            PublicRzJl rzjl = new PublicRzJl();
            rzjl.setSbsj(new Date());
            String id = UUIDGenerator.generate18();
            rzjl.setId(id);
            rzjl.setYwbwid(bwid);
            rzjl.setFilename(fileName);
            rzjl.setAreacode(areaCode);
            rzjl.setYwbm(head.get("RecType"));

            rzjl.setBdcdyh(head.get("EstateNum"));
            rzjl.setSbjg("空");
            rzjl.setBwxzqmc(qhmc);
            rzjl.setKhdbm(khdbm);//客户端编码
            rzjl.setBwlj(fileName);
            rzjl.setYwh(ywh);
            //上报插入日志
            insertPublicRZJLDao.insertPublicRzjl(rzjl);
        } catch (Exception e) {
            LOGGER.error("WatchDirService.uploadFileRzjl exception !{},fileName:{}", e, fileName);
            res = false;
            return res;
        }
        return res;
    }

    public void updateSftpRzjlSbjg(Map<String, String> head, String fileName) {
        Map<String, String> paramMap = Maps.newHashMap();
        String areaCode = head.get("AreaCode");
        paramMap.put("fileName", fileName);
        paramMap.put("bdcdyh", head.get("EstateNum"));
        paramMap.put("areaCode", areaCode);
        baSftpMapper.updateSftpRzjlSbjg(paramMap);
    }

    /**
     * 更新上报日志表信息
     *
     * @param fileName
     * @param resString
     * @return
     */
    @Transactional
    public boolean updateSftpRzjl(String fileName, String resString) {

        String areaCode = fileName.substring(3, 9);
        String exchangeQxdm = XmlUtil.getExhangeQxdm(qxdm, areaCode);
        if (StringUtils.isNotBlank(exchangeQxdm)) {
            List<Rzjl> rzjls = baSftpMapper.getRzjlList(fileName);
            if (CollectionUtils.isNotEmpty(rzjls)) {
                areaCode = rzjls.get(0).getBwxzqdm();
            }
        }
        List<Map<String, String>> sftpRzjlList = baSftpMapper.getSftpRzjl(fileName);
        Map<String, String> sftpMap = sftpRzjlList.get(0);
        String bdcdyh = sftpMap.get("BDCDYH");//不动产单元号
        String ywh = sftpMap.get("YWH");
        String responseCode = "";
        String bizmsgid = "";
        String fileNameRep = fileName.replace("Biz", "Rep");
        String xybwid = UUIDGenerator.generate18();
        //保存部里面响应报文
        if (StringUtils.isNotBlank(resString)) {
            //报部响应报文入Es
            insertEs(fileNameRep, resString, xybwid);
            //解析获取响应编码
            responseCode = XmlUtil.getTextByXpath("/respond/ResponseCode", resString);
            bizmsgid = XmlUtil.getTextByXpath("/respond/BizMsgID", resString);
        }
        Map<String, String> updateMap = Maps.newHashMap();
        updateMap.put("bdcdyh", bdcdyh);
        updateMap.put("areacode", areaCode);
        updateMap.put("filename", fileName);
        updateMap.put("respcode", responseCode);
        updateMap.put("xybwlj", fileNameRep);
        if ("0000".equals(responseCode)) {
            Map<String, Object> param = Maps.newHashMap();
            Date date = new Date();
            param.put("bwxzqdm", areaCode);
            param.put("date", date);
            Qxsbjkxx qxsbjkxx = baRzjlMapper.getQxsbjkxx(param);
            if (null != qxsbjkxx) {
                qxsbjkxx.setSjgxsj(new Date());
                String cgsl = qxsbjkxx.getCgsl();
                if (StringUtils.isBlank(cgsl)) {
                    qxsbjkxx.setCgsl("1");
                } else {
                    Map<String, Object> params = Maps.newHashMap();
                    params.put("bdcdyh", bdcdyh);
                    params.put("ywh", ywh);
                    int sbcgsl = baSftpMapper.getSbcgsl(params);
                    if (sbcgsl < 1) {
                        LOGGER.info("ba_qxsbjkxx成功数量更新{}", fileName);
                        int cgslNum = Integer.parseInt(cgsl);
                        qxsbjkxx.setCgsl(String.valueOf(cgslNum + 1));
                    }
                }
                baRzjlMapper.updateQxsbjkxxCgsl(qxsbjkxx);
            }
            updateMap.put("sbjg", "成功");
        } else if ("1000".equals(responseCode)) {
            updateMap.put("sbjg", "数据校验错误");
        } else if ("2000".equals(responseCode)) {
            updateMap.put("sbjg", "中心解压错误");
        } else {
            updateMap.put("sbjg", "其他类型的错误");
        }
        updateMap.put("xybwid", xybwid);
        baSftpMapper.updateSftpRzjl(updateMap);
        //向客户端发消息
        if (!StringUtils.equals("0000", responseCode)) {
            LOGGER.info("开始发送失败响应消息,bizmsgid:" + bizmsgid);
            ClientInfo clientInfo = baJrdMapper.getJrdxxByQhdm(areaCode);
            if (null == clientInfo) {
                clientInfo = baJrdMapper.getJrdxxByFdm(areaCode);
                if (null != clientInfo) {
                    LOGGER.info("发送到队列1,队列名称:{}", clientInfo.getDlmc());
                    sendRespMessage(resString, fileName, areaCode, clientInfo.getDlmc());
                }
            } else {
                LOGGER.info("发送到队列2,队列名称:" + clientInfo.getDlmc());
                sendRespMessage(resString, fileName, areaCode, clientInfo.getDlmc());
            }
            LOGGER.info("结束发送失败响应消息,bizmsgid:{}", bizmsgid);
        }
        return true;
    }

    /**
     * 向客户端发送上报失败消息
     *
     * @param content
     * @param fileName
     * @param areaCode
     * @param queueName
     */
    public void sendRespMessage(String content, String fileName, String areaCode, String queueName) {

        String bizmsgid = XmlUtil.getTextByXpath("/respond/BizMsgID", content);
        String additionalData = XmlUtil.getTextByXpath("/respond/AdditionalData", content);
        String additionalData2 = XmlUtil.getTextByXpath("/respond/AdditionalData2", content);
        String responseInfo = XmlUtil.getTextByXpath("/respond/ResponseInfo", content);
        String responseCode = XmlUtil.getTextByXpath("/respond/ResponseCode", content);
        Respond responseMessage = new Respond();
        responseMessage.setSuccessFlag("1");
        responseMessage.setCertID("");
        responseMessage.setBizMsgID(bizmsgid);
        responseMessage.setAdditionalData2(additionalData2);
        responseMessage.setAdditionalData(additionalData);
        responseMessage.setQRCode("");
        responseMessage.setResponseInfo(responseInfo);
        responseMessage.setResponseCode(responseCode);
        responseMessage.setServerName(queueName);
        responseMessage.setFileName(fileName);
        responseMessage.setAreaCode(areaCode);
        responseMessage.setSbsbbj("1");//上报失败标记
        MessageServer messageServer = new MessageServer();
        messageServer.setResponseMessage(responseMessage);
        messageServer.setServerQueue(queueName);
        boolean envFlag = dataInsertDbService.getEnv();
        if (envFlag) {
            if (null == producerMsg) {
                WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                producerMsg = (ProducerMsg) wac.getBean(ProducerMsg.class);
            }
            producerMsg.sendMsg(JSON.toJSONString(messageServer), queueName,fileName);
        } else {
            if (null == sendMessage) {
                WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                sendMessage = (SendMessage) wac.getBean(SendMessage.class);
            }
            sendMessage.sendDirectMsg(JSON.toJSONString(messageServer), queueName);
        }
    }

    /**
     * 获取xml文件head头
     *
     * @param file
     * @return
     */
    public Map<String, String> getXmlHead(File file) {

        Map<String, String> head = null;
        try {
            String content = XmlUtil.getFileByByte(file);
            if (StringUtils.isNotBlank(content)) {
                head = XmlUtil.getParamValueByElement(content, "Head");
            }
        } catch (Exception e) {
            LOGGER.error("WatchDirService.解析xml文件异常，异常信息:{}，文件名称:{}", e, file.getName());
        }
        return head;
    }

    /**
     * 插入报部响应报文
     *
     * @param fileName
     * @param respString
     */
    public void insertEs(String fileName, String respString, String xybwid) {

        try {
            List<String> xybwIdList = searchService.getBwidByFileName(fileName, Constant.BBXYBWBJ, "");//响应报文ID
            if (CollectionUtils.isNotEmpty(xybwIdList)) {
                String xybwidTemp = xybwIdList.get(0);
                searchService.delData(Constant.BBREP_INDEXTYPE, xybwidTemp);//删除es已存在响应报文
            }

            Map<String, Object> jsonStr = new HashMap<>();
            jsonStr.put("fileName", fileName);
            jsonStr.put("message", respString);
            jsonStr.put("dataTime", TimeUtils.dateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
            jsonStr.put("fileId", xybwid);
            searchService.mainCreateIndex(jsonStr, Constant.BBXYBWBJ);
        } catch (Exception e) {
            LOGGER.error("保存响应报文，入Es异常!{},fileName:{}", e, fileName);
        }
    }

}
